/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.plugins;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.List;
import org.jboss.as.security.plugins.ModuleClassLoaderLocator;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.wildfly.security.manager.WildFlySecurityManager;
import org.wildfly.security.manager.action.GetModuleClassLoaderAction;

class SecurityActions {
    SecurityActions() {
    }

    static ModuleClassLoader getModuleClassLoader(ModuleLoader loader, String moduleSpec) throws ModuleLoadException {
        Module module = loader.loadModule(ModuleIdentifier.fromString((String)moduleSpec));
        return WildFlySecurityManager.isChecking() ? (ModuleClassLoader)AccessController.doPrivileged(new GetModuleClassLoaderAction(module)) : module.getClassLoader();
    }

    static SecurityContext getSecurityContext() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

                @Override
                public SecurityContext run() {
                    return SecurityContextAssociation.getSecurityContext();
                }
            });
        }
        return SecurityContextAssociation.getSecurityContext();
    }

    static Principal getPrincipal() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<Principal>(){

                @Override
                public Principal run() {
                    Principal principal = null;
                    SecurityContext sc = SecurityActions.getSecurityContext();
                    if (sc != null) {
                        principal = sc.getUtil().getUserPrincipal();
                    }
                    return principal;
                }
            });
        }
        Principal principal = null;
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc != null) {
            principal = sc.getUtil().getUserPrincipal();
        }
        return principal;
    }

    static Object getCredential() {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Object credential = null;
                    SecurityContext sc = SecurityActions.getSecurityContext();
                    if (sc != null) {
                        credential = sc.getUtil().getCredential();
                    }
                    return credential;
                }
            });
        }
        Object credential = null;
        SecurityContext sc = SecurityActions.getSecurityContext();
        if (sc != null) {
            credential = sc.getUtil().getCredential();
        }
        return credential;
    }

    static ModuleClassLoaderLocator.CombinedClassLoader createCombinedClassLoader(final List<ClassLoader> classLoaders) {
        if (WildFlySecurityManager.isChecking()) {
            return AccessController.doPrivileged(new PrivilegedAction<ModuleClassLoaderLocator.CombinedClassLoader>(){

                @Override
                public ModuleClassLoaderLocator.CombinedClassLoader run() {
                    return new ModuleClassLoaderLocator.CombinedClassLoader(classLoaders);
                }
            });
        }
        return new ModuleClassLoaderLocator.CombinedClassLoader(classLoaders);
    }
}

