/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.module;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.Context;
import org.jboss.weld.bean.builtin.AbstractBuiltInBean;
import org.jboss.weld.bootstrap.BeanDeployment;
import org.jboss.weld.bootstrap.ContextHolder;
import org.jboss.weld.bootstrap.api.Environment;
import org.jboss.weld.bootstrap.api.Service;
import org.jboss.weld.bootstrap.api.ServiceRegistry;
import org.jboss.weld.bootstrap.api.helpers.ServiceRegistries;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.module.PlugableValidator;
import org.jboss.weld.module.WeldModule;
import org.jboss.weld.resources.WeldClassLoaderResourceLoader;
import org.jboss.weld.util.ServiceLoader;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.ImmutableSet;

public class WeldModules
implements Service {
    private final List<WeldModule> modules = (List)ServiceLoader.load(WeldModule.class, WeldClassLoaderResourceLoader.INSTANCE).stream().map(metadata -> (WeldModule)metadata.getValue()).sorted((m1, m2) -> m1.getName().compareTo(m2.getName())).collect(ImmutableList.collector());
    private Set<PlugableValidator> validators = Collections.emptySet();

    public WeldModules() {
        BootstrapLogger.LOG.debugv("Using Weld modules: {0}", this.modules.stream().map(m -> m.getName()).collect(Collectors.toList()));
    }

    public void postServiceRegistration(final String contextId, final ServiceRegistry services) {
        final HashSet validators = new HashSet();
        WeldModule.PostServiceRegistrationContext ctx = new WeldModule.PostServiceRegistrationContext(){

            @Override
            public ServiceRegistry getServices() {
                return services;
            }

            @Override
            public String getContextId() {
                return contextId;
            }

            @Override
            public void registerPlugableValidator(PlugableValidator validator) {
                validators.add(validator);
            }
        };
        for (WeldModule module : this.modules) {
            module.postServiceRegistration(ctx);
        }
        this.validators = ImmutableSet.copyOf(validators);
    }

    public void postContextRegistration(final String contextId, final ServiceRegistry services, final List<ContextHolder<? extends Context>> contexts) {
        WeldModule.PostContextRegistrationContext ctx = new WeldModule.PostContextRegistrationContext(){

            @Override
            public String getContextId() {
                return contextId;
            }

            @Override
            public ServiceRegistry getServices() {
                return ServiceRegistries.unmodifiableServiceRegistry((ServiceRegistry)services);
            }

            @Override
            public void addContext(ContextHolder<? extends Context> context) {
                contexts.add(context);
            }
        };
        for (WeldModule module : this.modules) {
            module.postContextRegistration(ctx);
        }
    }

    public void postBeanArchiveServiceRegistration(final ServiceRegistry services, final BeanManagerImpl manager, final BeanDeploymentArchive archive) {
        WeldModule.PostBeanArchiveServiceRegistrationContext ctx = new WeldModule.PostBeanArchiveServiceRegistrationContext(){

            @Override
            public ServiceRegistry getServices() {
                return services;
            }

            @Override
            public BeanManagerImpl getBeanManager() {
                return manager;
            }

            @Override
            public BeanDeploymentArchive getBeanDeploymentArchive() {
                return archive;
            }
        };
        for (WeldModule module : this.modules) {
            module.postBeanArchiveServiceRegistration(ctx);
        }
    }

    public void preBeanRegistration(final BeanDeployment deployment, final Environment environment) {
        WeldModule.PreBeanRegistrationContext ctx = new WeldModule.PreBeanRegistrationContext(){

            @Override
            public void registerBean(AbstractBuiltInBean<?> bean) {
                deployment.getBeanDeployer().addBuiltInBean(bean);
            }

            @Override
            public Environment getEnvironment() {
                return environment;
            }

            @Override
            public BeanManagerImpl getBeanManager() {
                return deployment.getBeanManager();
            }

            @Override
            public BeanDeploymentArchive getBeanDeploymentArchive() {
                return deployment.getBeanDeploymentArchive();
            }
        };
        for (WeldModule module : this.modules) {
            module.preBeanRegistration(ctx);
        }
    }

    public void cleanup() {
    }

    public Set<PlugableValidator> getPluggableValidators() {
        return this.validators;
    }
}

