/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.nullpm;

import io.netty.buffer.Unpooled;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.buffers.impl.ChannelBufferWrapper;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.server.LargeServerMessage;

class NullStorageLargeServerMessage
extends CoreMessage
implements LargeServerMessage {
    NullStorageLargeServerMessage() {
    }

    NullStorageLargeServerMessage(NullStorageLargeServerMessage other) {
        super((CoreMessage)other);
    }

    @Override
    public void releaseResources(boolean sync) {
    }

    @Override
    public synchronized void addBytes(byte[] bytes) {
        if (this.buffer == null) {
            this.buffer = Unpooled.buffer((int)bytes.length);
        }
        this.buffer.writeBytes(bytes);
    }

    @Override
    public synchronized void addBytes(ActiveMQBuffer bytes) {
        int readableBytes = bytes.readableBytes();
        if (this.buffer == null) {
            this.buffer = Unpooled.buffer((int)readableBytes);
        }
        this.buffer.ensureWritable(readableBytes);
        assert (this.buffer.hasArray());
        int writerIndex = this.buffer.writerIndex();
        bytes.readBytes(this.buffer.array(), this.buffer.arrayOffset() + writerIndex, readableBytes);
        this.buffer.writerIndex(writerIndex + readableBytes);
    }

    public synchronized ActiveMQBuffer getReadOnlyBodyBuffer() {
        return new ChannelBufferWrapper(this.buffer.slice(0, this.buffer.writerIndex()).asReadOnly());
    }

    public synchronized int getBodyBufferSize() {
        return this.buffer.writerIndex();
    }

    @Override
    public void deleteFile() throws Exception {
    }

    public boolean isLargeMessage() {
        return true;
    }

    @Override
    public void decrementDelayDeletionCount() {
    }

    @Override
    public void incrementDelayDeletionCount() {
    }

    public boolean isServerMessage() {
        return true;
    }

    public synchronized int getEncodeSize() {
        return this.getHeadersAndPropertiesEncodeSize();
    }

    public String toString() {
        return "NullStorageLargeServerMessage[messageID=" + this.messageID + ", durable=" + this.durable + ", address=" + this.getAddress() + ",properties=" + this.properties.toString() + "]";
    }

    public Message copy() {
        return new NullStorageLargeServerMessage(this);
    }

    @Override
    public void setPaged() {
    }

    @Override
    public void setPendingRecordID(long pendingRecordID) {
    }

    @Override
    public long getPendingRecordID() {
        return -1L;
    }

    @Override
    public SequentialFile getFile() {
        return null;
    }
}

