/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.faulttolerance.deployment;

import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.ConfigurationManager;
import io.smallrye.faulttolerance.HystrixExtension;
import javax.enterprise.inject.spi.Extension;
import org.apache.commons.configuration.AbstractConfiguration;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.wildfly.extension.microprofile.faulttolerance.MicroProfileFaultToleranceLogger;
import org.wildfly.extension.microprofile.faulttolerance.deployment.MicroProfileFaultToleranceCDIExtension;
import org.wildfly.extension.microprofile.faulttolerance.deployment.MicroProfileFaultToleranceMarker;

public class MicroProfileFaultToleranceDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final ConcurrentMapConfiguration configInstance = new ConcurrentMapConfiguration();
    private static final AttachmentKey<Boolean> ATTACHMENT_KEY = AttachmentKey.create(Boolean.class);
    private static volatile int remainingHystrixConfiguringDeployments;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        WeldCapability weldCapability;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!MicroProfileFaultToleranceMarker.isMarked(deploymentUnit)) {
            return;
        }
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        try {
            weldCapability = (WeldCapability)support.getCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class);
        }
        catch (CapabilityServiceSupport.NoSuchCapabilityException e) {
            throw new IllegalStateException();
        }
        weldCapability.registerExtensionInstance((Extension)new MicroProfileFaultToleranceCDIExtension(), deploymentUnit);
        weldCapability.registerExtensionInstance((Extension)new HystrixExtension(), deploymentUnit);
        MicroProfileFaultToleranceDeploymentProcessor microProfileFaultToleranceDeploymentProcessor = this;
        synchronized (microProfileFaultToleranceDeploymentProcessor) {
            if (remainingHystrixConfiguringDeployments == 0) {
                Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
                Config mpConfig = ConfigProvider.getConfig((ClassLoader)module.getClassLoader());
                boolean isHystrixConfiguringDeployment = false;
                for (String key : mpConfig.getPropertyNames()) {
                    if (!key.startsWith("hystrix.")) continue;
                    String value = (String)mpConfig.getValue(key, String.class);
                    MicroProfileFaultToleranceLogger.ROOT_LOGGER.debugf("Configuring Hystrix: %s=%s", key, value);
                    configInstance.setProperty(key, (Object)value);
                    isHystrixConfiguringDeployment = true;
                }
                if (isHystrixConfiguringDeployment) {
                    deploymentUnit.putAttachment(ATTACHMENT_KEY, (Object)Boolean.TRUE);
                    ++remainingHystrixConfiguringDeployments;
                }
            } else {
                MicroProfileFaultToleranceLogger.ROOT_LOGGER.hystrixAlreadyConfigured(deploymentUnit.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(DeploymentUnit deploymentUnit) {
        MicroProfileFaultToleranceDeploymentProcessor microProfileFaultToleranceDeploymentProcessor = this;
        synchronized (microProfileFaultToleranceDeploymentProcessor) {
            if (deploymentUnit.removeAttachment(ATTACHMENT_KEY) != null && --remainingHystrixConfiguringDeployments == 0) {
                configInstance.clear();
            }
        }
    }

    static {
        ConfigurationManager.install((AbstractConfiguration)configInstance);
    }
}

