/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt;

import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.jwt.Claims;
import org.jboss.logging.Logger;

public class SmallryeJwtUtils {
    private static final Integer MAX_PATH_DEPTH = 4;
    private static final String COOKIE_HEADER = "Cookie";
    private static final Set<String> SUPPORTED_ALGORITHMS = new HashSet<String>(Arrays.asList("RS256", "RS384", "RS512", "ES256", "ES384", "ES512"));
    private static final Logger log = Logger.getLogger(SmallryeJwtUtils.class);

    private SmallryeJwtUtils() {
    }

    public static void setContextSubPath(JWTAuthContextInfo contextInfo, Optional<String> subPath) {
        if (SmallryeJwtUtils.checkClaimPath(Claims.sub.name(), subPath)) {
            contextInfo.setSubjectPath(subPath.get());
        }
    }

    public static void setContextGroupsPath(JWTAuthContextInfo contextInfo, Optional<String> groupsPath) {
        if (SmallryeJwtUtils.checkClaimPath(Claims.groups.name(), groupsPath)) {
            contextInfo.setGroupsPath(groupsPath.get());
        }
    }

    private static boolean checkClaimPath(String claimName, Optional<String> claimPath) {
        if (claimPath.isPresent()) {
            String[] pathSegments = claimPath.get().split("/");
            if (MAX_PATH_DEPTH < pathSegments.length) {
                log.errorf("path." + claimName + " configuration will be ignored because the path depth is too large: %d, maximum depth is %d.", (Object)pathSegments.length, (Object)MAX_PATH_DEPTH);
            } else {
                return true;
            }
        }
        return false;
    }

    public static void setContextTokenCookie(JWTAuthContextInfo contextInfo, Optional<String> cookieName) {
        if (cookieName.isPresent()) {
            if (!COOKIE_HEADER.equals(contextInfo.getTokenHeader())) {
                log.error((Object)"Token header is not 'Cookie', the cookie name value will be ignored");
            } else {
                contextInfo.setTokenCookie(cookieName.get());
            }
        }
    }

    public static void setWhitelistAlgorithms(JWTAuthContextInfo contextInfo, Optional<String> whitelistAlgorithms) {
        if (whitelistAlgorithms.isPresent()) {
            List algorithms = Arrays.stream(whitelistAlgorithms.get().split(",")).map(String::trim).collect(Collectors.toList());
            for (String whitelistAlgorithm : algorithms) {
                if (SUPPORTED_ALGORITHMS.contains(whitelistAlgorithm)) {
                    contextInfo.getWhitelistAlgorithms().add(whitelistAlgorithm);
                    continue;
                }
                log.errorf("Algorithm %s not supported", (Object)whitelistAlgorithm);
            }
        }
    }

    public static void setTokenSchemes(JWTAuthContextInfo contextInfo, Optional<String> tokenSchemes) {
        if (tokenSchemes.isPresent()) {
            ArrayList<String> schemes = new ArrayList<String>();
            for (String s : tokenSchemes.get().split(",")) {
                schemes.add(s.trim());
            }
            contextInfo.setTokenSchemes(schemes);
        }
    }
}

