/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.AdvancedCache;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.expiration.RetrieveLastAccessCommand;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.expiration.impl.ExpirationManagerImpl;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ResponseCollectors;
import org.infinispan.remoting.transport.ValidResponseCollector;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class ClusterExpirationManager<K, V>
extends ExpirationManagerImpl<K, V> {
    private static final Log log = LogFactory.getLog(ClusterExpirationManager.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final int MAX_CONCURRENT_EXPIRATIONS = 100;
    @Inject
    protected ComponentRef<AdvancedCache<K, V>> cacheRef;
    @Inject
    protected ComponentRef<CommandsFactory> cf;
    @Inject
    protected RpcManager rpcManager;
    @Inject
    protected DistributionManager distributionManager;
    private AdvancedCache<K, V> cache;
    private Address localAddress;
    private long timeout;
    private String cacheName;

    @Override
    public void start() {
        super.start();
        this.cache = AbstractDelegatingCache.unwrapCache(this.cacheRef.wired()).getAdvancedCache();
        this.cacheName = this.cache.getName();
        this.localAddress = this.cache.getCacheManager().getAddress();
        this.timeout = this.cache.getCacheConfiguration().clustering().remoteTimeout();
    }

    @Override
    public void processExpiration() {
        if (!Thread.currentThread().isInterrupted()) {
            LocalizedCacheTopology topology;
            while (this.purgeInMemoryContents(topology = this.distributionManager.getCacheTopology())) {
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            this.persistenceManager.purgeExpired();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean purgeInMemoryContents(LocalizedCacheTopology topology) {
        long start = 0L;
        int removedEntries = 0;
        AtomicInteger errors = new AtomicInteger();
        try {
            if (trace) {
                log.tracef("Purging data container on cache %s for topology %d", this.cacheName, topology.getTopologyId());
                start = this.timeService.time();
            }
            ArrayBlockingQueue expirationPermits = new ArrayBlockingQueue(100);
            long currentTimeMillis = this.timeService.wallClockTime();
            IntSet segments = IntSets.from(topology.getReadConsistentHash().getPrimarySegmentsForOwner(this.localAddress));
            Iterator purgeCandidates = ((InternalDataContainer)this.dataContainer.running()).iteratorIncludingExpired(segments);
            while (purgeCandidates.hasNext()) {
                InternalCacheEntry ice = purgeCandidates.next();
                if (ice.canExpire()) {
                    boolean expiredTransient;
                    boolean expiredMortal;
                    long maxIdle;
                    long lifespan;
                    Object value;
                    InternalCacheEntry internalCacheEntry = ice;
                    synchronized (internalCacheEntry) {
                        value = ice.getValue();
                        lifespan = ice.getLifespan();
                        maxIdle = ice.getMaxIdle();
                        expiredMortal = ExpiryHelper.isExpiredMortal(lifespan, ice.getCreated(), currentTimeMillis);
                        expiredTransient = ExpiryHelper.isExpiredTransient(maxIdle, ice.getLastUsed(), currentTimeMillis);
                    }
                    if (expiredMortal || expiredTransient) {
                        if (++removedEntries > 100 && !this.pollForCompletion(expirationPermits, start, removedEntries, errors)) {
                            return false;
                        }
                        CompletableFuture<Object> stage = expiredMortal ? this.handleLifespanExpireEntry(ice.getKey(), value, lifespan, false) : this.actualRemoveMaxIdleExpireEntry(ice.getKey(), value, maxIdle, false);
                        stage.whenComplete((obj, t) -> expirationPermits.add(stage));
                    }
                }
                if (this.distributionManager.getCacheTopology() == topology) continue;
                this.printResults("Purging data container on cache %s stopped due to topology change. Total time was: %s and removed %d entries with %d errors", start, removedEntries, errors);
                return true;
            }
            int expirationsLeft = Math.min(removedEntries, 100);
            for (int i = 0; i < expirationsLeft; ++i) {
                if (this.pollForCompletion(expirationPermits, start, removedEntries, errors)) continue;
                return false;
            }
            this.printResults("Purging data container on cache %s completed in %s and removed %d entries with %d errors", start, removedEntries, errors);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.printResults("Purging data container on cache %s was interrupted. Total time was: %s and removed %d entries with %d errors", start, removedEntries, errors);
        }
        catch (Throwable t2) {
            log.exceptionPurgingDataContainer(t2);
        }
        return false;
    }

    private void printResults(String message, long start, int removedEntries, AtomicInteger errors) {
        if (trace) {
            log.tracef(message, new Object[]{this.cacheName, Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)), removedEntries, errors.get()});
        }
    }

    private boolean pollForCompletion(BlockingQueue<CompletableFuture<?>> queue, long start, int removedEntries, AtomicInteger errors) throws InterruptedException, TimeoutException {
        CompletableFuture<?> future = queue.poll(this.timeout * 3L, TimeUnit.MILLISECONDS);
        if (future != null) {
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
            }
            catch (ExecutionException e) {
                errors.incrementAndGet();
                log.exceptionPurgingDataContainer(e.getCause());
            }
            return true;
        }
        this.printResults("Purging data container on cache %s stopped due to waiting for prior removal (could be a bug or misconfiguration). Total time was: %s and removed %d entries", start, removedEntries, errors);
        return false;
    }

    CompletableFuture<Void> handleLifespanExpireEntry(K key, V value, long lifespan, boolean skipLocking) {
        if (this.expiring.putIfAbsent(key, key) == null) {
            if (trace) {
                log.tracef("Submitting expiration removal for key %s which had lifespan of %s", Util.toStr(key), lifespan);
            }
            AdvancedCache<K, V> cacheToUse = skipLocking ? this.cache.withFlags(Flag.SKIP_LOCKING) : this.cache;
            CompletableFuture<Void> future = cacheToUse.removeLifespanExpired(key, value, lifespan);
            return future.whenComplete((v, t) -> this.expiring.remove(key, key));
        }
        return CompletableFutures.completedNull();
    }

    CompletableFuture<Boolean> handleMaxIdleExpireEntry(K key, V value, long maxIdle, boolean skipLocking) {
        return this.actualRemoveMaxIdleExpireEntry(key, value, maxIdle, skipLocking);
    }

    CompletableFuture<Boolean> actualRemoveMaxIdleExpireEntry(K key, V value, long maxIdle, boolean skipLocking) {
        CompletableFuture<Boolean> completableFuture = new CompletableFuture<Boolean>();
        CompletableFuture<Boolean> expiringObject = this.expiring.putIfAbsent(key, completableFuture);
        if (expiringObject == null) {
            if (trace) {
                log.tracef("Submitting expiration removal for key %s which had maxIdle of %s", Util.toStr(key), maxIdle);
            }
            completableFuture.whenComplete((b, t) -> this.expiring.remove(key, completableFuture));
            try {
                AdvancedCache<K, V> cacheToUse = skipLocking ? this.cache.withFlags(Flag.SKIP_LOCKING) : this.cache;
                CompletableFuture<Boolean> expired = cacheToUse.removeMaxIdleExpired(key, value);
                expired.whenComplete((b, t) -> {
                    if (t != null) {
                        completableFuture.completeExceptionally((Throwable)t);
                    } else {
                        completableFuture.complete((Boolean)b);
                    }
                });
                return completableFuture;
            }
            catch (Throwable t2) {
                completableFuture.completeExceptionally(t2);
                throw t2;
            }
        }
        if (expiringObject instanceof CompletableFuture) {
            return expiringObject;
        }
        return CompletableFutures.completedTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> entryExpiredInMemory(InternalCacheEntry<K, V> entry, long currentTime, boolean hasLock) {
        boolean expiredMortal;
        long lifespan;
        Object value;
        InternalCacheEntry<K, V> internalCacheEntry = entry;
        synchronized (internalCacheEntry) {
            value = entry.getValue();
            lifespan = entry.getLifespan();
            expiredMortal = ExpiryHelper.isExpiredMortal(lifespan, entry.getCreated(), currentTime);
        }
        if (expiredMortal) {
            CompletableFuture<Void> future = this.handleLifespanExpireEntry(entry.getKey(), value, lifespan, hasLock);
            if (hasLock) {
                return future.thenCompose(CompletableFutures.composeTrue());
            }
            return CompletableFutures.completedTrue();
        }
        return this.handleMaxIdleExpireEntry(entry.getKey(), value, entry.getMaxIdle(), hasLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Boolean> entryExpiredInMemoryFromIteration(InternalCacheEntry<K, V> entry, long currentTime) {
        boolean expiredMortal;
        InternalCacheEntry<K, V> internalCacheEntry = entry;
        synchronized (internalCacheEntry) {
            expiredMortal = ExpiryHelper.isExpiredMortal(entry.getLifespan(), entry.getCreated(), currentTime);
        }
        if (expiredMortal) {
            return CompletableFutures.completedTrue();
        }
        return CompletableFutures.completedFalse();
    }

    @Override
    public void handleInStoreExpiration(K key) {
        if (this.expiring.putIfAbsent(key, key) == null) {
            try {
                this.cache.removeLifespanExpired(key, null, null).join();
            }
            finally {
                this.expiring.remove(key, key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleInStoreExpiration(MarshalledEntry<K, V> marshalledEntry) {
        K key = marshalledEntry.getKey();
        if (this.expiring.putIfAbsent(key, key) == null) {
            try {
                InternalMetadata metadata = marshalledEntry.getMetadata();
                this.cache.removeLifespanExpired(key, marshalledEntry.getValue(), metadata.lifespan() == -1L ? null : Long.valueOf(metadata.lifespan())).join();
            }
            finally {
                this.expiring.remove(key, key);
            }
        }
    }

    @Override
    public CompletableFuture<Long> retrieveLastAccess(Object key, Object value, int segment) {
        Long access = this.localLastAccess(key, value, segment);
        LocalizedCacheTopology topology = this.distributionManager.getCacheTopology();
        DistributionInfo info = topology.getDistribution(key);
        if (trace) {
            log.tracef("Asking all read owners %s for key: %s - for latest access time", info.readOwners(), key);
        }
        RetrieveLastAccessCommand rlac = this.cf.running().buildRetrieveLastAccessCommand(key, value, segment);
        rlac.setTopologyId(topology.getTopologyId());
        return this.rpcManager.invokeCommand(info.readOwners(), (ReplicableCommand)rlac, new MaxResponseCollector<Long>(access), this.rpcManager.getSyncRpcOptions()).toCompletableFuture();
    }

    static class MaxResponseCollector<T extends Comparable<T>>
    extends ValidResponseCollector<T> {
        T highest;

        MaxResponseCollector(T highest) {
            this.highest = highest;
        }

        @Override
        public T finish() {
            return this.highest;
        }

        @Override
        protected T addValidResponse(Address sender, ValidResponse response) {
            Comparable value = (Comparable)response.getResponseValue();
            if (value != null && (this.highest == null || this.highest.compareTo((Comparable)value) < 0)) {
                this.highest = value;
            }
            return null;
        }

        @Override
        protected T addTargetNotFound(Address sender) {
            return null;
        }

        @Override
        protected T addException(Address sender, Exception exception) {
            throw ResponseCollectors.wrapRemoteException(sender, exception);
        }
    }
}

