/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.context.Flag;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.jboss.ejb.client.Affinity;
import org.jboss.ejb.client.ClusterAffinity;
import org.jboss.ejb.client.NodeAffinity;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.CacheProperties;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.infinispan.PrimaryOwnerLocator;
import org.wildfly.clustering.ee.infinispan.scheduler.PrimaryOwnerScheduler;
import org.wildfly.clustering.ee.infinispan.tx.InfinispanBatcher;
import org.wildfly.clustering.ejb.Bean;
import org.wildfly.clustering.ejb.BeanManager;
import org.wildfly.clustering.ejb.IdentifierFactory;
import org.wildfly.clustering.ejb.RemoveListener;
import org.wildfly.clustering.ejb.infinispan.BeanEntry;
import org.wildfly.clustering.ejb.infinispan.BeanExpirationScheduler;
import org.wildfly.clustering.ejb.infinispan.BeanFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroup;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.ejb.infinispan.BeanGroupFactory;
import org.wildfly.clustering.ejb.infinispan.BeanGroupKey;
import org.wildfly.clustering.ejb.infinispan.BeanKey;
import org.wildfly.clustering.ejb.infinispan.CompositeScheduler;
import org.wildfly.clustering.ejb.infinispan.Configuration;
import org.wildfly.clustering.ejb.infinispan.EagerEvictionScheduler;
import org.wildfly.clustering.ejb.infinispan.ExpirationConfiguration;
import org.wildfly.clustering.ejb.infinispan.ExpiredBeanRemover;
import org.wildfly.clustering.ejb.infinispan.ImmutableBeanEntry;
import org.wildfly.clustering.ejb.infinispan.InfinispanBeanManagerConfiguration;
import org.wildfly.clustering.ejb.infinispan.PassivationConfiguration;
import org.wildfly.clustering.ejb.infinispan.bean.InfinispanBeanKey;
import org.wildfly.clustering.ejb.infinispan.logging.InfinispanEjbLogger;
import org.wildfly.clustering.group.Group;
import org.wildfly.clustering.group.Node;
import org.wildfly.clustering.infinispan.spi.PredicateCacheEventFilter;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.infinispan.spi.distribution.CacheLocality;
import org.wildfly.clustering.infinispan.spi.distribution.ConsistentHashLocality;
import org.wildfly.clustering.infinispan.spi.distribution.Locality;
import org.wildfly.clustering.infinispan.spi.distribution.SimpleLocality;
import org.wildfly.clustering.registry.Registry;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

@Listener(primaryOnly=true)
public class InfinispanBeanManager<I, T>
implements BeanManager<I, T, TransactionBatch> {
    private static final String GLOBAL_IDLE_TIMEOUT = WildFlySecurityManager.getPropertyPrivileged((String)"jboss.ejb.stateful.idle-timeout", null);
    private static final String IDLE_TIMEOUT_PROPERTY = "jboss.ejb.stateful.%s.idle-timeout";
    private final String name;
    private final Cache<BeanKey<I>, BeanEntry<I>> cache;
    private final CacheProperties properties;
    private final BeanFactory<I, T> beanFactory;
    private final BeanGroupFactory<I, T> groupFactory;
    private final IdentifierFactory<I> identifierFactory;
    private final KeyAffinityService<BeanKey<I>> affinity;
    private final Registry<String, ?> registry;
    private final CommandDispatcherFactory dispatcherFactory;
    private final ExpirationConfiguration<T> expiration;
    private final PassivationConfiguration<T> passivation;
    private final Batcher<TransactionBatch> batcher;
    private final Predicate<Map.Entry<? super BeanKey<I>, ? super BeanEntry<I>>> filter;
    private final AtomicReference<Future<?>> rehashFuture = new AtomicReference();
    private final AtomicInteger rehashTopology = new AtomicInteger();
    private final Function<BeanKey<I>, Node> primaryOwnerLocator;
    private volatile org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<I, ImmutableBeanEntry<I>> scheduler;
    private volatile ExecutorService executor;
    private volatile Scheduler<I, ImmutableBeanEntry<I>> primaryOwnerScheduler;

    public InfinispanBeanManager(InfinispanBeanManagerConfiguration<I, T> configuration, IdentifierFactory<I> identifierFactory, Configuration<BeanKey<I>, BeanEntry<I>, BeanFactory<I, T>> beanConfiguration, Configuration<BeanGroupKey<I>, BeanGroupEntry<I, T>, BeanGroupFactory<I, T>> groupConfiguration) {
        this.name = configuration.getName();
        this.filter = configuration.getBeanFilter();
        this.groupFactory = groupConfiguration.getFactory();
        this.beanFactory = beanConfiguration.getFactory();
        this.cache = beanConfiguration.getCache();
        this.properties = configuration.getProperties();
        this.batcher = new InfinispanBatcher(this.cache);
        Address address = this.cache.getCacheManager().getAddress();
        KeyAffinityServiceFactory affinityFactory = configuration.getAffinityFactory();
        KeyGenerator beanKeyGenerator = () -> ((BeanFactory)beanConfiguration.getFactory()).createKey(identifierFactory.createIdentifier());
        this.affinity = affinityFactory.createService(this.cache, beanKeyGenerator);
        this.identifierFactory = () -> ((BeanKey)this.affinity.getKeyForAddress(address)).getId();
        this.registry = configuration.getRegistry();
        this.dispatcherFactory = configuration.getCommandDispatcherFactory();
        this.expiration = configuration.getExpirationConfiguration();
        this.passivation = configuration.getPassivationConfiguration();
        this.primaryOwnerLocator = new PrimaryOwnerLocator(beanConfiguration.getCache(), configuration.getNodeFactory(), configuration.getRegistry().getGroup());
    }

    public void start() {
        Duration idleDuration;
        this.executor = Executors.newSingleThreadExecutor((ThreadFactory)new DefaultThreadFactory(InfinispanBeanManager.class));
        this.affinity.start();
        Duration stopTimeout = Duration.ofMillis(this.cache.getCacheConfiguration().transaction().cacheStopTimeout());
        ArrayList schedulers = new ArrayList(2);
        Duration timeout = this.expiration.getTimeout();
        if (timeout != null && !timeout.isNegative()) {
            schedulers.add(new BeanExpirationScheduler<I, T>(this.dispatcherFactory.getGroup(), this.batcher, this.beanFactory, this.expiration, new ExpiredBeanRemover<I, T>(this.beanFactory, this.expiration), stopTimeout));
        }
        String dispatcherName = String.join((CharSequence)"/", this.cache.getName(), this.filter.toString());
        String idleTimeout = WildFlySecurityManager.getPropertyPrivileged((String)String.format(IDLE_TIMEOUT_PROPERTY, this.name), (String)GLOBAL_IDLE_TIMEOUT);
        if (idleTimeout != null && !(idleDuration = Duration.parse(idleTimeout)).isNegative()) {
            schedulers.add(new EagerEvictionScheduler<I, T>(this.dispatcherFactory.getGroup(), this.batcher, this.beanFactory, this.groupFactory, idleDuration, this.dispatcherFactory, dispatcherName + "/eager-passivation", stopTimeout));
        }
        CompositeScheduler compositeScheduler = this.scheduler = !schedulers.isEmpty() ? new CompositeScheduler(schedulers) : null;
        this.primaryOwnerScheduler = this.scheduler != null ? (this.dispatcherFactory.getGroup().isSingleton() ? this.scheduler : new PrimaryOwnerScheduler(this.dispatcherFactory, dispatcherName, this.scheduler, this.primaryOwnerLocator, InfinispanBeanKey::new)) : null;
        this.cache.addListener((Object)this, (CacheEventFilter)new PredicateCacheEventFilter(this.filter), null);
        if (this.scheduler != null) {
            new ScheduleExpirationTask<I>(this.cache, this.filter, this.scheduler, (Locality)new SimpleLocality(false), (Locality)new CacheLocality(this.cache)).run();
        }
    }

    public void stop() {
        this.groupFactory.close();
        this.cache.removeListener((Object)this);
        WildFlySecurityManager.doUnchecked((Object)this.executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
        try {
            this.executor.awaitTermination(this.cache.getCacheConfiguration().transaction().cacheStopTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.primaryOwnerScheduler != null) {
                this.primaryOwnerScheduler.close();
            }
            this.affinity.stop();
        }
    }

    public boolean isRemotable(Throwable throwable) {
        for (Throwable subject = throwable; subject != null; subject = subject.getCause()) {
            if (!(subject instanceof CacheException)) continue;
            return false;
        }
        return true;
    }

    public Affinity getStrictAffinity() {
        Group group = this.registry.getGroup();
        return this.cache.getCacheConfiguration().clustering().cacheMode().isClustered() ? new ClusterAffinity(group.getName()) : new NodeAffinity((String)this.registry.getEntry(group.getLocalMember()).getKey());
    }

    public Affinity getWeakAffinity(I id) {
        Node node;
        Map.Entry entry;
        CacheMode mode = this.cache.getCacheConfiguration().clustering().cacheMode();
        if (mode.isClustered() && (entry = this.registry.getEntry(node = !mode.isScattered() ? this.locatePrimaryOwner(id) : this.registry.getGroup().getLocalMember())) != null) {
            return new NodeAffinity((String)entry.getKey());
        }
        return Affinity.NONE;
    }

    Node locatePrimaryOwner(I id) {
        return this.primaryOwnerLocator.apply(new InfinispanBeanKey<I>(id));
    }

    public Bean<I, T> createBean(I id, I groupId, T bean) {
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Creating bean %s associated with group %s", id, groupId);
        BeanGroupEntry groupEntry = id == groupId ? (BeanGroupEntry)this.groupFactory.createValue(groupId, null) : (BeanGroupEntry)this.groupFactory.findValue(groupId);
        BeanGroup<I, T> group = this.groupFactory.createGroup(groupId, groupEntry);
        group.addBean(id, bean);
        group.releaseBean(id, this.properties.isPersistent() ? this.passivation.getPassivationListener() : null);
        BeanEntry entry = (BeanEntry)this.beanFactory.createValue(id, groupId);
        return new SchedulableBean<I, T>(this.beanFactory.createBean(id, entry), entry, this.primaryOwnerScheduler);
    }

    public Bean<I, T> findBean(I id) {
        Bean<I, T> bean;
        InfinispanEjbLogger.ROOT_LOGGER.tracef("Locating bean %s", id);
        BeanEntry entry = (BeanEntry)this.beanFactory.findValue(id);
        Bean<I, T> bean2 = bean = entry != null ? this.beanFactory.createBean(id, entry) : null;
        if (bean == null) {
            InfinispanEjbLogger.ROOT_LOGGER.debugf("Could not find bean %s", id);
            return null;
        }
        if (bean.isExpired()) {
            InfinispanEjbLogger.ROOT_LOGGER.tracef("Bean %s was found, but has expired", id);
            this.beanFactory.remove(id, this.expiration.getRemoveListener());
            return null;
        }
        if (this.primaryOwnerScheduler != null) {
            this.primaryOwnerScheduler.cancel(id);
        }
        return new SchedulableBean<I, T>(bean, entry, this.primaryOwnerScheduler);
    }

    public boolean containsBean(I id) {
        return this.cache.containsKey(this.beanFactory.createKey(id));
    }

    public IdentifierFactory<I> getIdentifierFactory() {
        return this.identifierFactory;
    }

    public Batcher<TransactionBatch> getBatcher() {
        return this.batcher;
    }

    public int getActiveCount() {
        try (CacheStream entries = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD}).entrySet().stream();){
            int n = (int)entries.filter(this.filter).count();
            return n;
        }
    }

    public int getPassiveCount() {
        return this.groupFactory.getPassiveCount();
    }

    @DataRehashed
    public void dataRehashed(DataRehashedEvent<BeanKey<I>, BeanEntry<I>> event) {
        if (this.scheduler != null) {
            ConsistentHashLocality newLocality = new ConsistentHashLocality(event.getCache(), event.getConsistentHashAtEnd());
            try {
                if (event.isPre()) {
                    this.rehashTopology.set(event.getNewTopologyId());
                    Future future = this.rehashFuture.getAndSet(null);
                    if (future != null) {
                        future.cancel(true);
                    }
                    this.executor.submit(new CancelExpirationTask<I>(this.scheduler, (Locality)newLocality));
                } else {
                    this.rehashTopology.compareAndSet(event.getNewTopologyId(), 0);
                    ConsistentHashLocality oldLocality = new ConsistentHashLocality(event.getCache(), event.getConsistentHashAtStart());
                    this.rehashFuture.set(this.executor.submit(new ScheduleExpirationTask<I>(this.cache, this.filter, this.scheduler, (Locality)oldLocality, (Locality)newLocality)));
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    @TopologyChanged
    public void topologyChanged(TopologyChangedEvent<BeanKey<I>, BeanEntry<I>> event) {
        if (this.scheduler != null && !event.isPre() && this.rehashTopology.get() != event.getNewTopologyId()) {
            Future future = this.rehashFuture.getAndSet(null);
            if (future != null) {
                future.cancel(true);
            }
            Cache cache = event.getCache();
            ConsistentHashLocality oldLocality = new ConsistentHashLocality(cache, event.getReadConsistentHashAtStart());
            ConsistentHashLocality newLocality = new ConsistentHashLocality(cache, event.getWriteConsistentHashAtEnd());
            try {
                this.rehashFuture.compareAndSet(null, this.executor.submit(new ScheduleExpirationTask<I>(cache, this.filter, this.scheduler, (Locality)oldLocality, (Locality)newLocality)));
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    private static class SchedulableBean<I, T>
    implements Bean<I, T> {
        private final Bean<I, T> bean;
        private final ImmutableBeanEntry<I> entry;
        private Scheduler<I, ImmutableBeanEntry<I>> scheduler;

        SchedulableBean(Bean<I, T> bean, ImmutableBeanEntry<I> entry, Scheduler<I, ImmutableBeanEntry<I>> scheduler) {
            this.bean = bean;
            this.entry = entry;
            this.scheduler = scheduler;
        }

        public I getId() {
            return (I)this.bean.getId();
        }

        public I getGroupId() {
            return (I)this.bean.getGroupId();
        }

        public void remove(RemoveListener<T> listener) {
            this.bean.remove(listener);
        }

        public boolean isExpired() {
            return this.bean.isExpired();
        }

        public boolean isValid() {
            return this.bean.isValid();
        }

        public T acquire() {
            return (T)this.bean.acquire();
        }

        public boolean release() {
            return this.bean.release();
        }

        public void close() {
            this.bean.close();
            if (this.scheduler != null && this.bean.isValid()) {
                this.scheduler.schedule(this.bean.getId(), this.entry);
            }
        }
    }

    private static class ScheduleExpirationTask<I>
    implements Runnable {
        private final Cache<BeanKey<I>, BeanEntry<I>> cache;
        private final Predicate<Map.Entry<? super BeanKey<I>, ? super BeanEntry<I>>> filter;
        private final org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<I, ImmutableBeanEntry<I>> scheduler;
        private final Locality oldLocality;
        private final Locality newLocality;

        ScheduleExpirationTask(Cache<BeanKey<I>, BeanEntry<I>> cache, Predicate<Map.Entry<? super BeanKey<I>, ? super BeanEntry<I>>> filter, org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<I, ImmutableBeanEntry<I>> scheduler, Locality oldLocality, Locality newLocality) {
            this.cache = cache;
            this.filter = filter;
            this.scheduler = scheduler;
            this.oldLocality = oldLocality;
            this.newLocality = newLocality;
        }

        @Override
        public void run() {
            try (CacheStream stream = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL, Flag.SKIP_CACHE_LOAD}).entrySet().stream().filter(this.filter);){
                Iterator entries = stream.iterator();
                while (entries.hasNext()) {
                    if (Thread.currentThread().isInterrupted()) {
                        break;
                    }
                    Map.Entry entry = (Map.Entry)entries.next();
                    BeanKey key = (BeanKey)entry.getKey();
                    if (this.oldLocality.isLocal((Object)key) || !this.newLocality.isLocal((Object)key)) continue;
                    this.scheduler.schedule(key.getId(), entry.getValue());
                }
            }
        }
    }

    private static class CancelExpirationTask<I>
    implements Runnable {
        private final org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<I, ImmutableBeanEntry<I>> scheduler;
        private final Locality locality;

        CancelExpirationTask(org.wildfly.clustering.ee.infinispan.scheduler.Scheduler<I, ImmutableBeanEntry<I>> scheduler, Locality locality) {
            this.scheduler = scheduler;
            this.locality = locality;
        }

        @Override
        public void run() {
            this.scheduler.cancel(this.locality);
        }
    }
}

