/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.cdi;

import io.smallrye.jwt.JsonUtils;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.json.JsonValue;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jboss.logging.Logger;

@RequestScoped
public class CommonJwtProducer {
    private static Logger log = Logger.getLogger(CommonJwtProducer.class);
    @Inject
    JsonWebToken currentToken;

    public JsonValue generalJsonValueProducer(InjectionPoint ip) {
        String name = this.getName(ip);
        Object value = this.getValue(name, false);
        return JsonUtils.wrapValue(value);
    }

    public <T> T getValue(String name, boolean isOptional) {
        if (this.currentToken == null) {
            log.debugf("getValue(%s), null JsonWebToken", (Object)name);
            return null;
        }
        Optional claimValue = this.currentToken.claim(name);
        if (!isOptional && !claimValue.isPresent()) {
            log.debugf("Failed to find Claim for: %s", (Object)name);
        }
        log.debugf("getValue(%s), isOptional=%s, claimValue=%s", (Object)name, (Object)isOptional, (Object)claimValue);
        return claimValue.orElse(null);
    }

    public String getName(InjectionPoint ip) {
        String name = null;
        for (Annotation ann : ip.getQualifiers()) {
            if (!(ann instanceof Claim)) continue;
            Claim claim = (Claim)ann;
            name = claim.standard() == Claims.UNKNOWN ? claim.value() : claim.standard().name();
        }
        return name;
    }
}

