/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshall.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.GLOBAL)
public class EncoderRegistryImpl
implements EncoderRegistry {
    private static final Log log = LogFactory.getLog(EncoderRegistryImpl.class);
    private final Map<Short, Encoder> encoderMap = new ConcurrentHashMap<Short, Encoder>();
    private final Map<Byte, Wrapper> wrapperMap = new ConcurrentHashMap<Byte, Wrapper>();
    private final List<Transcoder> transcoders = Collections.synchronizedList(new ArrayList());
    private final Map<MediaType, Map<MediaType, Transcoder>> transcoderCache = new ConcurrentHashMap<MediaType, Map<MediaType, Transcoder>>();

    @Override
    public void registerEncoder(Encoder encoder) {
        if (encoder == null) {
            throw new NullPointerException("Encoder cannot be null");
        }
        short id = encoder.id();
        if (this.encoderMap.containsKey(id)) {
            throw log.duplicateIdEncoder(id);
        }
        this.encoderMap.put(id, encoder);
    }

    @Override
    public void registerWrapper(Wrapper wrapper) {
        if (wrapper == null) {
            throw new NullPointerException("Wrapper cannot be null");
        }
        byte id = wrapper.id();
        if (this.wrapperMap.containsKey(id)) {
            throw log.duplicateIdWrapper(id);
        }
        this.wrapperMap.put(id, wrapper);
    }

    @Override
    public void registerTranscoder(Transcoder transcoder) {
        this.transcoders.add(transcoder);
    }

    @Override
    public Transcoder getTranscoder(MediaType mediaType, MediaType another) {
        Transcoder transcoder = this.getTranscoderOrNull(mediaType, another);
        if (transcoder == null) {
            throw log.cannotFindTranscoder(mediaType, another);
        }
        return transcoder;
    }

    private Transcoder getTranscoderOrNull(MediaType mediaType, MediaType another) {
        return this.transcoderCache.computeIfAbsent(mediaType, mt -> new ConcurrentHashMap(4)).computeIfAbsent(another, mt -> this.transcoders.stream().filter(t -> t.supportsConversion(mediaType, another)).findFirst().orElse(null));
    }

    @Override
    public boolean isConversionSupported(MediaType from, MediaType to) {
        if (from == null || to == null) {
            throw new NullPointerException("MediaType must not be null!");
        }
        return from.match(to) || this.getTranscoderOrNull(from, to) != null;
    }

    @Override
    public Encoder getEncoder(Class<? extends Encoder> clazz, short encoderId) {
        Encoder encoder;
        if (clazz == null && encoderId == 0) {
            throw new NullPointerException("Encoder class or identifier must be provided!");
        }
        if (encoderId != 0) {
            encoder = this.encoderMap.get(encoderId);
            if (encoder == null) {
                throw log.encoderIdNotFound(encoderId);
            }
        } else {
            encoder = this.encoderMap.values().stream().filter(e -> e.getClass().equals(clazz)).findFirst().orElse(null);
            if (encoder == null) {
                throw log.encoderClassNotFound(clazz);
            }
        }
        return encoder;
    }

    @Override
    public boolean isRegistered(Class<? extends Encoder> encoderClass) {
        return this.encoderMap.values().stream().anyMatch(e -> e.getClass().equals(encoderClass));
    }

    @Override
    public Wrapper getWrapper(Class<? extends Wrapper> clazz, byte wrapperId) {
        Wrapper wrapper;
        if (clazz == null && wrapperId == 0) {
            throw new NullPointerException("Wrapper class or identifier must be provided!");
        }
        if (wrapperId != 0) {
            wrapper = this.wrapperMap.get(wrapperId);
            if (wrapper == null) {
                throw log.wrapperIdNotFound(wrapperId);
            }
        } else {
            wrapper = this.wrapperMap.values().stream().filter(e -> e.getClass().equals(clazz)).findAny().orElse(null);
            if (wrapper == null) {
                throw log.wrapperClassNotFound(clazz);
            }
        }
        return wrapper;
    }
}

