/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.registry;

import java.util.regex.Matcher;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.PathSegment;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceLocatorInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.registry.Expression;
import org.jboss.resteasy.core.registry.SegmentNode;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyUriInfo;

public class MethodExpression
extends Expression {
    protected SegmentNode parent;
    protected ResourceInvoker invoker;

    @Override
    public int compareTo(Expression expression) {
        int s = super.compareTo(expression);
        if (s != 0) {
            return s;
        }
        MethodExpression me = (MethodExpression)expression;
        if (this.invoker instanceof ResourceMethodInvoker && me.invoker instanceof ResourceLocatorInvoker) {
            return -1;
        }
        if (this.invoker instanceof ResourceLocatorInvoker && me.invoker instanceof ResourceMethodInvoker) {
            return 1;
        }
        return 0;
    }

    public MethodExpression(SegmentNode parent, String segment, ResourceInvoker invoker) {
        this(parent, segment, invoker, null);
    }

    public MethodExpression(SegmentNode parent, String segment, ResourceInvoker invoker, String additionalRegex) {
        super(segment, additionalRegex);
        this.parent = parent;
        this.invoker = invoker;
    }

    public void populatePathParams(HttpRequest request, Matcher matcher, String path) {
        ResteasyUriInfo uriInfo = request.getUri();
        for (Expression.Group group : this.groups) {
            int i;
            String value = matcher.group(group.group);
            uriInfo.addEncodedPathParameter(group.name, value);
            int index = matcher.start(group.group);
            int start = 0;
            if (path.charAt(0) == '/') {
                ++start;
            }
            int segmentIndex = 0;
            if (start < path.length()) {
                int count = 0;
                for (i = start; i < index && i < path.length(); ++i) {
                    if (path.charAt(i) != '/') continue;
                    ++count;
                }
                segmentIndex = count;
            }
            int numSegments = 1;
            for (i = 0; i < value.length(); ++i) {
                if (value.charAt(i) != '/') continue;
                ++numSegments;
            }
            if (segmentIndex + numSegments > request.getUri().getPathSegments().size()) {
                throw new BadRequestException(Messages.MESSAGES.numberOfMatchedSegments());
            }
            PathSegment[] encodedSegments = new PathSegment[numSegments];
            PathSegment[] decodedSegments = new PathSegment[numSegments];
            for (int i2 = 0; i2 < numSegments; ++i2) {
                decodedSegments[i2] = request.getUri().getPathSegments().get(segmentIndex + i2);
                encodedSegments[i2] = request.getUri().getPathSegments(false).get(segmentIndex + i2);
            }
            uriInfo.getEncodedPathParameterPathSegments().add((Object)group.name, (Object)encodedSegments);
            uriInfo.getPathParameterPathSegments().add((Object)group.name, (Object)decodedSegments);
        }
    }

    public boolean isLocator() {
        return this.invoker instanceof ResourceLocatorInvoker;
    }

    public ResourceInvoker getInvoker() {
        return this.invoker;
    }
}

