/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.metrics;

import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.metrics.MetricNames;
import io.smallrye.faulttolerance.metrics.MetricsCollector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.jboss.logging.Logger;

@ApplicationScoped
public class MetricsCollectorFactory {
    private static final Logger LOGGER = Logger.getLogger(MetricsCollectorFactory.class);
    @Inject
    MetricRegistry registry;
    @Inject
    @ConfigProperty(name="MP_Fault_Tolerance_Metrics_Enabled", defaultValue="true")
    Boolean metricsEnabled;

    public MetricsCollector createCollector(FaultToleranceOperation operation) {
        if (this.metricsEnabled.booleanValue()) {
            return new MetricsCollectorImpl(operation);
        }
        return MetricsCollector.NOOP;
    }

    private void runSafely(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (RuntimeException any) {
            LOGGER.warn((Object)"Collecting metrics failed", (Throwable)any);
        }
    }

    public static Metadata metadataOf(String name, MetricType metricType) {
        return Metadata.builder().withName(name).withType(metricType).reusable().build();
    }

    class MetricsCollectorImpl
    implements MetricsCollector {
        private final String metricsPrefix;
        private final FaultToleranceOperation operation;
        private final AtomicLong bulkheadQueueSize = new AtomicLong(0L);
        private final AtomicLong bulkheadConcurrentExecutions = new AtomicLong(0L);

        MetricsCollectorImpl(FaultToleranceOperation operation) {
            this.metricsPrefix = MetricNames.metricsPrefix(operation.getMethod());
            this.operation = operation;
            MetricsCollectorFactory.this.runSafely(() -> {
                if (operation.hasBulkhead()) {
                    if (operation.isAsync()) {
                        this.gaugeRegister(this.metricsPrefix + ".bulkhead.waitingQueue.population", this.bulkheadQueueSize::get);
                    }
                    this.gaugeRegister(this.metricsPrefix + ".bulkhead.concurrentExecutions", this.bulkheadConcurrentExecutions::get);
                }
            });
        }

        private void counterInc(String name) {
            this.counterOf(name).inc();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void gaugeRegister(String name, Supplier<Long> supplier) {
            MetricID metricID = new MetricID(name);
            Gauge gauge = (Gauge)MetricsCollectorFactory.this.registry.getGauges().get(metricID);
            if (gauge == null) {
                FaultToleranceOperation faultToleranceOperation = this.operation;
                synchronized (faultToleranceOperation) {
                    gauge = (Gauge)MetricsCollectorFactory.this.registry.getGauges().get(metricID);
                    if (gauge == null) {
                        MetricsCollectorFactory.this.registry.register(name, (Metric)((Gauge)supplier::get));
                    }
                }
            }
        }

        private void histogramUpdate(String name, long value) {
            this.histogramOf(name).update(value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Counter counterOf(String name) {
            MetricID metricID = new MetricID(name);
            Counter counter = (Counter)MetricsCollectorFactory.this.registry.getCounters().get(metricID);
            if (counter == null) {
                FaultToleranceOperation faultToleranceOperation = this.operation;
                synchronized (faultToleranceOperation) {
                    counter = (Counter)MetricsCollectorFactory.this.registry.getCounters().get(metricID);
                    if (counter == null) {
                        counter = MetricsCollectorFactory.this.registry.counter(MetricsCollectorFactory.metadataOf(name, MetricType.COUNTER));
                    }
                }
            }
            return counter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Histogram histogramOf(String name) {
            MetricID metricID = new MetricID(name);
            Histogram histogram = (Histogram)MetricsCollectorFactory.this.registry.getHistograms().get(metricID);
            if (histogram == null) {
                FaultToleranceOperation faultToleranceOperation = this.operation;
                synchronized (faultToleranceOperation) {
                    histogram = (Histogram)MetricsCollectorFactory.this.registry.getHistograms().get(metricID);
                    if (histogram == null) {
                        histogram = MetricsCollectorFactory.this.registry.histogram(MetricsCollectorFactory.metadataOf(name, MetricType.HISTOGRAM));
                    }
                }
            }
            return histogram;
        }

        public void bulkheadQueueEntered() {
            this.bulkheadQueueSize.incrementAndGet();
        }

        public void bulkheadQueueLeft(long timeInQueue) {
            if (timeInQueue > 0L) {
                this.histogramUpdate(this.metricsPrefix + ".bulkhead.waiting.duration", timeInQueue);
            }
            this.bulkheadQueueSize.decrementAndGet();
        }

        public void bulkheadEntered() {
            this.bulkheadConcurrentExecutions.incrementAndGet();
            this.counterInc(this.metricsPrefix + ".bulkhead.callsAccepted.total");
        }

        public void bulkheadRejected() {
            this.counterInc(this.metricsPrefix + ".bulkhead.callsRejected.total");
        }

        public void bulkheadLeft(long processingTime) {
            this.bulkheadConcurrentExecutions.decrementAndGet();
            this.histogramUpdate(this.metricsPrefix + ".bulkhead.executionDuration", processingTime);
        }

        public void circuitBreakerRejected() {
            this.counterInc(this.metricsPrefix + ".circuitbreaker.callsPrevented.total");
        }

        public void circuitBreakerOpenTimeProvider(Supplier<Long> supplier) {
            this.gaugeRegister(this.metricsPrefix + ".circuitbreaker.open.total", supplier);
        }

        public void circuitBreakerHalfOpenTimeProvider(Supplier<Long> supplier) {
            this.gaugeRegister(this.metricsPrefix + ".circuitbreaker.halfOpen.total", supplier);
        }

        public void circuitBreakerClosedTimeProvider(Supplier<Long> supplier) {
            this.gaugeRegister(this.metricsPrefix + ".circuitbreaker.closed.total", supplier);
        }

        public void circuitBreakerClosedToOpen() {
            this.counterInc(this.metricsPrefix + ".circuitbreaker.opened.total");
        }

        public void circuitBreakerFailed() {
            this.counterInc(this.metricsPrefix + ".circuitbreaker.callsFailed.total");
        }

        public void circuitBreakerSucceeded() {
            this.counterInc(this.metricsPrefix + ".circuitbreaker.callsSucceeded.total");
        }

        public void fallbackCalled() {
            this.counterInc(this.metricsPrefix + ".fallback.calls.total");
        }

        public void retrySucceededNotRetried() {
            this.counterInc(this.metricsPrefix + ".retry.callsSucceededNotRetried.total");
        }

        public void retrySucceededRetried() {
            this.counterInc(this.metricsPrefix + ".retry.callsSucceededRetried.total");
        }

        public void retryFailed() {
            this.counterInc(this.metricsPrefix + ".retry.callsFailed.total");
        }

        public void retryRetried() {
            this.counterInc(this.metricsPrefix + ".retry.retries.total");
        }

        public void timeoutSucceeded(long time) {
            this.histogramUpdate(this.metricsPrefix + ".timeout.executionDuration", time);
            this.counterInc(this.metricsPrefix + ".timeout.callsNotTimedOut.total");
        }

        public void timeoutTimedOut(long time) {
            this.histogramUpdate(this.metricsPrefix + ".timeout.executionDuration", time);
            this.counterInc(this.metricsPrefix + ".timeout.callsTimedOut.total");
        }

        public void timeoutFailed(long time) {
            this.histogramUpdate(this.metricsPrefix + ".timeout.executionDuration", time);
        }

        public void invoked() {
            this.counterInc(this.metricsPrefix + ".invocations.total");
        }

        public void failed() {
            this.counterInc(this.metricsPrefix + ".invocations.failed.total");
        }
    }
}

