/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfigurationBuilder;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.jboss.as.clustering.infinispan.subsystem.GlobalComponentServiceConfigurator;
import org.jboss.as.clustering.infinispan.subsystem.ThreadPoolDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.ServiceConfigurator;

public class ThreadPoolServiceConfigurator
extends GlobalComponentServiceConfigurator<ThreadPoolConfiguration> {
    private final ThreadPoolConfigurationBuilder builder = new ThreadPoolConfigurationBuilder(null);
    private final ThreadPoolDefinition definition;

    ThreadPoolServiceConfigurator(ThreadPoolDefinition definition, PathAddress address) {
        super(definition, address);
        this.definition = definition;
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        BlockingThreadPoolExecutorFactory factory = new BlockingThreadPoolExecutorFactory(this.definition.getMaxThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt(), this.definition.getMinThreads().resolveModelAttribute((ExpressionResolver)context, model).asInt(), this.definition.getQueueLength().resolveModelAttribute((ExpressionResolver)context, model).asInt(), this.definition.getKeepAliveTime().resolveModelAttribute((ExpressionResolver)context, model).asLong()){

            public ExecutorService createExecutor(ThreadFactory factory) {
                return super.createExecutor((ThreadFactory)new DefaultThreadFactory(factory));
            }
        };
        this.builder.threadPoolFactory((ThreadPoolExecutorFactory)factory);
        return this;
    }

    @Override
    public ThreadPoolConfiguration get() {
        return this.builder.create();
    }
}

