/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.undertow.sso;

import io.undertow.security.api.AuthenticatedSessionManager;
import io.undertow.security.impl.SingleSignOnManager;
import io.undertow.server.session.SessionIdGenerator;
import io.undertow.server.session.SessionListener;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.LifecycleListener;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.ee.Batch;
import org.wildfly.clustering.service.CascadeRemovalLifecycleListener;
import org.wildfly.clustering.service.ChildTargetService;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SimpleSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.web.WebDefaultProviderRequirement;
import org.wildfly.clustering.web.WebProviderRequirement;
import org.wildfly.clustering.web.container.HostSingleSignOnManagementConfiguration;
import org.wildfly.clustering.web.sso.DistributableSSOManagementProvider;
import org.wildfly.clustering.web.sso.LegacySSOManagementProviderFactory;
import org.wildfly.clustering.web.sso.SSOManager;
import org.wildfly.clustering.web.undertow.UndertowBinaryRequirement;
import org.wildfly.clustering.web.undertow.logging.UndertowClusteringLogger;
import org.wildfly.clustering.web.undertow.sso.DistributableSingleSignOnManager;
import org.wildfly.clustering.web.undertow.sso.SSOManagerServiceConfigurator;
import org.wildfly.clustering.web.undertow.sso.SessionIdGeneratorServiceConfigurator;
import org.wildfly.clustering.web.undertow.sso.SessionListenerServiceConfigurator;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistry;
import org.wildfly.clustering.web.undertow.sso.SessionManagerRegistryServiceConfigurator;

public class DistributableSingleSignOnManagerServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
Supplier<SingleSignOnManager> {
    private final HostSingleSignOnManagementConfiguration configuration;
    private final LegacySSOManagementProviderFactory legacyProviderFactory;
    private volatile SupplierDependency<SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, String, Void, Batch>> manager;
    private volatile SupplierDependency<SessionManagerRegistry> registry;
    private volatile SupplierDependency<DistributableSSOManagementProvider> provider;
    private volatile Consumer<ServiceTarget> installer;

    public DistributableSingleSignOnManagerServiceConfigurator(ServiceName name, HostSingleSignOnManagementConfiguration configuration, LegacySSOManagementProviderFactory legacyProviderFactory) {
        super(name);
        this.configuration = configuration;
        this.legacyProviderFactory = legacyProviderFactory;
    }

    @Override
    public SingleSignOnManager get() {
        return new DistributableSingleSignOnManager((SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, String, Void, Batch>)((SSOManager)this.manager.get()), (SessionManagerRegistry)this.registry.get());
    }

    public ServiceConfigurator configure(OperationContext context) {
        final String serverName = this.configuration.getServerName();
        final String hostName = this.configuration.getHostName();
        final CapabilityServiceSupport support = context.getCapabilityServiceSupport();
        final SupplierDependency<DistributableSSOManagementProvider> provider = this.getProvider(context, serverName, hostName);
        ServiceName serviceName = this.getServiceName();
        final ServiceName generatorServiceName = serviceName.append(new String[]{"generator"});
        final ServiceName managerServiceName = serviceName.append(new String[]{"manager"});
        final ServiceName listenerServiceName = serviceName.append(new String[]{"listener"});
        final ServiceName registryServiceName = serviceName.append(new String[]{"registry"});
        this.manager = new ServiceSupplierDependency(managerServiceName);
        this.registry = new ServiceSupplierDependency(registryServiceName);
        this.provider = provider;
        this.installer = new Consumer<ServiceTarget>(){

            @Override
            public void accept(ServiceTarget target) {
                ServiceConfigurator factoryConfigurator = ((DistributableSSOManagementProvider)provider.get()).getServiceConfigurator(hostName).configure(support);
                factoryConfigurator.build(target).install();
                new SessionIdGeneratorServiceConfigurator(generatorServiceName, serverName).configure(support).build(target).install();
                ServiceSupplierDependency factoryDependency = new ServiceSupplierDependency((ServiceNameProvider)factoryConfigurator);
                ServiceSupplierDependency generatorDependency = new ServiceSupplierDependency(generatorServiceName);
                new SSOManagerServiceConfigurator(managerServiceName, factoryDependency, (SupplierDependency<SessionIdGenerator>)generatorDependency, () -> null).configure(support).build(target).install();
                ServiceSupplierDependency managerDependency = new ServiceSupplierDependency(managerServiceName);
                new SessionListenerServiceConfigurator(listenerServiceName, (SupplierDependency<SSOManager<AuthenticatedSessionManager.AuthenticatedSession, String, String, Void, Batch>>)managerDependency).configure(support).build(target).install();
                ServiceSupplierDependency listenerDependency = new ServiceSupplierDependency(listenerServiceName);
                new SessionManagerRegistryServiceConfigurator(registryServiceName, serverName, hostName, (SupplierDependency<SessionListener>)listenerDependency).configure(support).build(target).install();
            }
        };
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceName name = this.getServiceName();
        ServiceController installerController = this.provider.register(target.addService(name.append(new String[]{"installer"}))).setInstance((Service)new ChildTargetService(this.installer)).install();
        ServiceBuilder builder = target.addService(name).addListener((LifecycleListener)new CascadeRemovalLifecycleListener(installerController));
        Consumer manager = new CompositeDependency(new Dependency[]{this.manager, this.registry}).register(builder).provides(new ServiceName[]{name});
        FunctionalService service = new FunctionalService(manager, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service);
    }

    private SupplierDependency<DistributableSSOManagementProvider> getProvider(OperationContext context, String serverName, String hostName) {
        String hostCapabilityName = UndertowBinaryRequirement.HOST.resolve(serverName, hostName);
        if (context.hasOptionalCapability(WebProviderRequirement.SSO_MANAGEMENT_PROVIDER.resolve(hostName), hostCapabilityName, null)) {
            return new ServiceSupplierDependency(WebProviderRequirement.SSO_MANAGEMENT_PROVIDER.getServiceName(context, hostName));
        }
        if (context.hasOptionalCapability(WebDefaultProviderRequirement.SSO_MANAGEMENT_PROVIDER.getName(), hostCapabilityName, null)) {
            return new ServiceSupplierDependency(WebDefaultProviderRequirement.SSO_MANAGEMENT_PROVIDER.getServiceName(context));
        }
        UndertowClusteringLogger.ROOT_LOGGER.legacySingleSignOnProviderInUse(hostName);
        return new SimpleSupplierDependency((Object)this.legacyProviderFactory.createSSOManagementProvider());
    }
}

