/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.federation;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.FederationConfiguration;
import org.apache.activemq.artemis.core.config.federation.FederationPolicy;
import org.apache.activemq.artemis.core.config.federation.FederationUpstreamConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.federation.FederatedAbstract;
import org.apache.activemq.artemis.core.server.federation.FederationManager;
import org.apache.activemq.artemis.core.server.federation.FederationUpstream;

public class Federation {
    private final ActiveMQServer server;
    private final SimpleString name;
    private final Map<String, FederationUpstream> upstreams = new HashMap<String, FederationUpstream>();
    private final FederationConfiguration config;
    private FederationManager.State state;

    public Federation(ActiveMQServer server, FederationConfiguration config) {
        this.server = server;
        this.config = config;
        Objects.requireNonNull(config.getName());
        this.name = SimpleString.toSimpleString((String)config.getName());
    }

    public synchronized void start() throws ActiveMQException {
        if (this.state == FederationManager.State.STARTED) {
            return;
        }
        this.deploy();
        for (FederationUpstream connection : this.upstreams.values()) {
            connection.start();
        }
        this.state = FederationManager.State.STARTED;
    }

    public synchronized void stop() {
        if (this.state == FederationManager.State.STOPPED) {
            return;
        }
        this.state = FederationManager.State.STOPPING;
        for (FederationUpstream connection : this.upstreams.values()) {
            connection.stop();
        }
        this.upstreams.clear();
        this.state = FederationManager.State.STOPPED;
    }

    public synchronized void deploy() throws ActiveMQException {
        for (FederationUpstreamConfiguration upstreamConfiguration : this.config.getUpstreamConfigurations()) {
            this.deploy(upstreamConfiguration, this.config.getFederationPolicyMap());
        }
        if (this.state != FederationManager.State.STARTED) {
            this.state = FederationManager.State.DEPLOYED;
        }
    }

    public boolean isStarted() {
        return this.state == FederationManager.State.STARTED;
    }

    public synchronized boolean undeploy(String name) {
        FederationUpstream federationConnection = this.upstreams.remove(name);
        if (federationConnection != null) {
            federationConnection.stop();
        }
        return true;
    }

    public synchronized boolean deploy(FederationUpstreamConfiguration upstreamConfiguration, Map<String, FederationPolicy> federationPolicyMap) throws ActiveMQException {
        String name = upstreamConfiguration.getName();
        FederationUpstream upstream = this.upstreams.get(name);
        if (upstream == null) {
            this.undeploy(name);
            upstream = this.deploy(name, upstreamConfiguration);
        } else if (!upstream.getConnection().getConfig().equals(upstreamConfiguration.getConnectionConfiguration())) {
            this.undeploy(name);
            upstream = this.deploy(name, upstreamConfiguration);
        }
        upstream.deploy(upstreamConfiguration.getPolicyRefs(), federationPolicyMap);
        return true;
    }

    private synchronized FederationUpstream deploy(String name, FederationUpstreamConfiguration upstreamConfiguration) {
        FederationUpstream upstream = new FederationUpstream(this.server, this, name, upstreamConfiguration);
        this.upstreams.put(name, upstream);
        if (this.state == FederationManager.State.STARTED) {
            upstream.start();
        }
        return upstream;
    }

    public FederationUpstream get(String name) {
        return this.upstreams.get(name);
    }

    public void register(FederatedAbstract federatedAbstract) {
        this.server.registerBrokerPlugin(federatedAbstract);
    }

    public void unregister(FederatedAbstract federatedAbstract) {
        this.server.unRegisterBrokerPlugin(federatedAbstract);
    }

    String getFederationPassword() {
        return this.config.getCredentials() == null ? null : this.config.getCredentials().getPassword();
    }

    String getFederationUser() {
        return this.config.getCredentials() == null ? null : this.config.getCredentials().getUser();
    }

    public FederationConfiguration getConfig() {
        return this.config;
    }

    public SimpleString getName() {
        return this.name;
    }

    static enum State {
        STOPPED,
        STOPPING,
        DEPLOYED,
        STARTED;

    }
}

