/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util.copier;

import com.sun.faces.util.copier.Copier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.Queue;

public class SerializationCopier
implements Copier {
    private static final String SERIALIZATION_COPIER_ERROR = "SerializationCopier cannot be used in this case. Please try other copier (e.g. MultiStrategyCopier, NewInstanceCopier, CopyCtorCopier, CloneCopier).";

    @Override
    public Object copy(Object object) {
        if (!(object instanceof Serializable)) {
            throw new IllegalStateException("Can't copy object of type " + object.getClass() + " since it doesn't implement Serializable");
        }
        try {
            return SerializationCopier.copyOutIn(object);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalArgumentException(SERIALIZATION_COPIER_ERROR);
        }
    }

    private static <T> T copyOutIn(T object) throws ClassNotFoundException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Out out = new Out(byteArrayOutputStream);
        out.writeObject(object);
        byte[] bytes = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        In in = new In(byteArrayInputStream, out);
        Object cloned = in.readObject();
        return (T)cloned;
    }

    private static class Out
    extends ObjectOutputStream {
        Queue<Class<?>> queue = new LinkedList();

        Out(OutputStream out) throws IOException {
            super(out);
        }

        @Override
        protected void annotateClass(Class<?> c) {
            this.queue.add(c);
        }

        @Override
        protected void annotateProxyClass(Class<?> c) {
            this.queue.add(c);
        }
    }

    private static class In
    extends ObjectInputStream {
        private final Out out;

        In(InputStream inputStream, Out out) throws IOException {
            super(inputStream);
            this.out = out;
        }

        @Override
        protected Class<?> resolveProxyClass(String[] interfaceNames) throws IOException, ClassNotFoundException {
            return this.out.queue.poll();
        }

        @Override
        protected Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
            String actuallyfound = null;
            Class<?> pollclass = this.out.queue.poll();
            if (pollclass != null) {
                actuallyfound = pollclass.getName();
            }
            if (!objectStreamClass.getName().equals(actuallyfound)) {
                throw new IllegalArgumentException(SerializationCopier.SERIALIZATION_COPIER_ERROR);
            }
            return pollclass;
        }
    }
}

