/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.logging.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class LoggerHelper {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());

    private LoggerHelper() {
    }

    public static PrintStream getLoggingPrintStream() {
        try {
            return new PrintStream((OutputStream)new CustomByteArrayOutputStream(), true, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw log.assertionNotLoadingUTF8Charset(e);
        }
    }

    static class CustomByteArrayOutputStream
    extends ByteArrayOutputStream {
        CustomByteArrayOutputStream() {
        }

        @Override
        public void flush() throws IOException {
            log.debug(this.toString("UTF-8"));
            super.flush();
        }
    }
}

