/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.embedded;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jboss.as.controller.client.ModelControllerClient;
import org.wildfly.core.embedded.Context;
import org.wildfly.core.embedded.EmbeddedManagedProcess;
import org.wildfly.core.embedded.EmbeddedProcessStartException;
import org.wildfly.core.embedded.HostController;
import org.wildfly.core.embedded.StandaloneServer;
import org.wildfly.core.embedded.logging.EmbeddedLogger;

class EmbeddedManagedProcessImpl
implements EmbeddedManagedProcess,
StandaloneServer,
HostController {
    private final Object managedProcess;
    private final Method methodStart;
    private final Method methodStop;
    private final Method methodGetModelControllerClient;
    private final Context context;

    EmbeddedManagedProcessImpl(Class<?> processClass, Object managedProcess, Context context) {
        this.managedProcess = managedProcess;
        try {
            this.methodStart = processClass.getMethod("start", new Class[0]);
            this.methodStop = processClass.getMethod("stop", new Class[0]);
            this.methodGetModelControllerClient = processClass.getMethod("getModelControllerClient", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw EmbeddedLogger.ROOT_LOGGER.cannotGetReflectiveMethod(nsme, nsme.getMessage(), processClass.getName());
        }
        this.context = context;
    }

    @Override
    public void start() throws EmbeddedProcessStartException {
        this.context.activate();
        this.invokeOnServer(this.methodStart, new Object[0]);
    }

    @Override
    public void stop() {
        try {
            this.safeInvokeOnServer(this.methodStop, new Object[0]);
        }
        finally {
            this.context.restore();
        }
    }

    @Override
    public ModelControllerClient getModelControllerClient() {
        return (ModelControllerClient)this.safeInvokeOnServer(this.methodGetModelControllerClient, new Object[0]);
    }

    private Object safeInvokeOnServer(Method method, Object ... args) {
        assert (method != this.methodStart);
        try {
            return this.invokeOnServer(method, args);
        }
        catch (EmbeddedProcessStartException unexpected) {
            throw new RuntimeException(unexpected);
        }
    }

    private Object invokeOnServer(Method method, Object ... args) throws EmbeddedProcessStartException {
        try {
            return method.invoke(this.managedProcess, args);
        }
        catch (RuntimeException rte) {
            throw rte;
        }
        catch (Exception ex) {
            Throwable cause = ex;
            if (ex instanceof InvocationTargetException) {
                cause = ex.getCause();
            }
            if (cause instanceof EmbeddedProcessStartException) {
                throw (EmbeddedProcessStartException)cause;
            }
            throw EmbeddedLogger.ROOT_LOGGER.cannotInvokeStandaloneServer(cause, method.getName());
        }
    }
}

