/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.password.impl;

import org.wildfly.security.asn1.ASN1Decoder;
import org.wildfly.security.asn1.ASN1Encoder;
import org.wildfly.security.password.spec.OneTimePasswordAlgorithmSpec;
import org.wildfly.security.util.AbstractAlgorithmParametersSpiImpl;

public final class OneTimePasswordAlgorithmParametersSpiImpl
extends AbstractAlgorithmParametersSpiImpl<OneTimePasswordAlgorithmSpec> {
    protected Class<OneTimePasswordAlgorithmSpec> getParameterType() {
        return OneTimePasswordAlgorithmSpec.class;
    }

    protected void engineEncode(ASN1Encoder encoder, OneTimePasswordAlgorithmSpec parameterSpec) {
        encoder.startSequence();
        encoder.encodeOctetString(parameterSpec.getAlgorithm());
        encoder.encodeIA5String(parameterSpec.getSeed());
        encoder.encodeInteger(parameterSpec.getSequenceNumber());
        encoder.endSequence();
    }

    protected OneTimePasswordAlgorithmSpec engineDecode(ASN1Decoder decoder) {
        decoder.startSequence();
        String algorithm = decoder.decodeOctetStringAsString();
        String seed = decoder.decodeIA5String();
        int sequenceNumber = decoder.decodeInteger().intValue();
        decoder.endSequence();
        return new OneTimePasswordAlgorithmSpec(algorithm, seed, sequenceNumber);
    }
}

