/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.microprofile.health;

import io.smallrye.health.SmallRyeHealth;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.util.function.Supplier;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.server.mgmt.domain.ExtensibleHttpManagement;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.microprofile.health.HealthReporter;
import org.wildfly.extension.microprofile.health.MicroProfileHealthSubsystemDefinition;

public class HealthContextService
implements Service {
    private static final String CONTEXT_NAME = "health";
    private final Supplier<ExtensibleHttpManagement> extensibleHttpManagement;
    private final boolean securityEnabled;
    private final Supplier<HealthReporter> healthReporter;

    static void install(OperationContext context, boolean securityEnabled) {
        ServiceBuilder serviceBuilder = context.getServiceTarget().addService(MicroProfileHealthSubsystemDefinition.HTTP_CONTEXT_SERVICE);
        Supplier extensibleHttpManagement = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.management.http.extensible", ExtensibleHttpManagement.class));
        Supplier healthReporter = serviceBuilder.requires(context.getCapabilityServiceName("org.wildfly.microprofile.health.reporter", HealthReporter.class));
        HealthContextService healthContextService = new HealthContextService(extensibleHttpManagement, securityEnabled, healthReporter);
        serviceBuilder.setInstance((Service)healthContextService).install();
    }

    HealthContextService(Supplier<ExtensibleHttpManagement> extensibleHttpManagement, boolean securityEnabled, Supplier<HealthReporter> healthReporter) {
        this.extensibleHttpManagement = extensibleHttpManagement;
        this.securityEnabled = securityEnabled;
        this.healthReporter = healthReporter;
    }

    public void start(StartContext context) {
        this.extensibleHttpManagement.get().addManagementHandler(CONTEXT_NAME, this.securityEnabled, (HttpHandler)new HealthCheckHandler(this.healthReporter.get()));
    }

    public void stop(StopContext context) {
        this.extensibleHttpManagement.get().removeContext(CONTEXT_NAME);
    }

    private class HealthCheckHandler
    implements HttpHandler {
        private final HealthReporter healthReporter;
        public static final String HEALTH = "/health";
        public static final String HEALTH_LIVE = "/health/live";
        public static final String HEALTH_READY = "/health/ready";

        public HealthCheckHandler(HealthReporter healthReporter) {
            this.healthReporter = healthReporter;
        }

        public void handleRequest(HttpServerExchange exchange) {
            SmallRyeHealth health;
            if (HEALTH.equals(exchange.getRequestPath())) {
                health = this.healthReporter.getHealth();
            } else if (HEALTH_LIVE.equals(exchange.getRequestPath())) {
                health = this.healthReporter.getLiveness();
            } else if (HEALTH_READY.equals(exchange.getRequestPath())) {
                health = this.healthReporter.getReadiness();
            } else {
                exchange.setStatusCode(404);
                return;
            }
            exchange.setStatusCode(health.isDown() ? 503 : 200).getResponseHeaders().add(Headers.CONTENT_TYPE, "application/json");
            exchange.getResponseSender().send(health.getPayload().toString());
        }
    }
}

