/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.metadata;

import java.util.Arrays;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.patching.metadata.ContentItem;
import org.jboss.as.patching.metadata.ContentType;
import org.jboss.as.patching.metadata.MiscContentItem;
import org.jboss.as.patching.runner.PatchingTaskContext;

public interface ModificationCondition {
    public boolean isSatisfied(PatchingTaskContext var1) throws PatchingException;

    public static final class ExistsCondition
    implements ModificationCondition {
        static final String ID = "exists";
        private final ContentItem contentItem;

        private ExistsCondition(ContentItem contentItem) {
            assert (contentItem != null) : "contentItem is null";
            this.contentItem = contentItem;
        }

        public ContentItem getContentItem() {
            return this.contentItem;
        }

        @Override
        public boolean isSatisfied(PatchingTaskContext ctx) throws PatchingException {
            return ctx.getTargetFile(this.contentItem).exists();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(ID).append(':');
            switch (this.contentItem.getContentType()) {
                case MISC: {
                    buf.append(ContentType.MISC.toString());
                    break;
                }
                case MODULE: {
                    buf.append(ContentType.MODULE.toString());
                    break;
                }
                case BUNDLE: {
                    buf.append(ContentType.BUNDLE.toString());
                    break;
                }
                default: {
                    throw new IllegalStateException(PatchLogger.ROOT_LOGGER.unsupportedContentType(this.contentItem.getContentType().name()));
                }
            }
            return buf.append(':').append(this.contentItem.getRelativePath()).toString();
        }
    }

    public static class Factory {
        public static ModificationCondition exists(ContentItem contentItem) {
            return new ExistsCondition(contentItem);
        }

        public static ModificationCondition fromString(String condition) throws PatchingException {
            assert (condition != null) : "condition is null";
            if (condition.startsWith("exists")) {
                MiscContentItem item;
                String str = condition.substring("exists".length() + 1);
                int i = str.indexOf(58);
                if (i < 0) {
                    throw PatchLogger.ROOT_LOGGER.contentItemTypeMissing(condition);
                }
                String typeStr = str.substring(0, i);
                ContentType type = ContentType.valueOf(typeStr);
                str = str.substring(i + 1);
                switch (type) {
                    case MISC: {
                        String[] s = str.split("/");
                        int length = s.length;
                        String name = s[length - 1];
                        String[] itemPath = Arrays.copyOf(s, length - 1);
                        item = new MiscContentItem(name, itemPath, null);
                        break;
                    }
                    default: {
                        throw new PatchingException(PatchLogger.ROOT_LOGGER.unsupportedContentType(type.name()));
                    }
                }
                return Factory.exists(item);
            }
            throw PatchLogger.ROOT_LOGGER.unrecognizedConditionFormat(condition);
        }
    }
}

