/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.extension.batch.jberet._private.BatchLogger;
import org.wildfly.extension.batch.jberet.deployment.WildFlyJobOperator;

public class BatchJobExecutionResource
implements Resource {
    private final Resource delegate;
    private final WildFlyJobOperator jobOperator;
    private final String jobName;
    private final Set<String> children = new LinkedHashSet<String>();

    BatchJobExecutionResource(WildFlyJobOperator jobOperator, String jobName) {
        this(Resource.Factory.create((boolean)true), jobOperator, jobName);
    }

    private BatchJobExecutionResource(Resource delegate, WildFlyJobOperator jobOperator, String jobName) {
        this.delegate = delegate;
        this.jobOperator = jobOperator;
        this.jobName = jobName;
    }

    public ModelNode getModel() {
        return this.delegate.getModel();
    }

    public void writeModel(ModelNode newModel) {
        this.delegate.writeModel(newModel);
    }

    public boolean isModelDefined() {
        return this.delegate.isModelDefined();
    }

    public boolean hasChild(PathElement element) {
        if ("execution".equals(element.getKey())) {
            return this.hasJobExecution(element.getValue());
        }
        return this.delegate.hasChild(element);
    }

    public Resource getChild(PathElement element) {
        if ("execution".equals(element.getKey())) {
            if (this.hasJobExecution(element.getValue())) {
                return PlaceholderResource.INSTANCE;
            }
            return null;
        }
        return this.delegate.getChild(element);
    }

    public Resource requireChild(PathElement element) {
        if ("execution".equals(element.getKey())) {
            if (this.hasJobExecution(element.getValue())) {
                return PlaceholderResource.INSTANCE;
            }
            throw new Resource.NoSuchResourceException(element);
        }
        return this.delegate.requireChild(element);
    }

    public boolean hasChildren(String childType) {
        if ("execution".equals(childType)) {
            return !this.getChildrenNames("execution").isEmpty();
        }
        return this.delegate.hasChildren(childType);
    }

    public Resource navigate(PathAddress address) {
        if (address.size() > 0 && "execution".equals(address.getElement(0).getKey())) {
            if (address.size() > 1) {
                throw new Resource.NoSuchResourceException(address.getElement(1));
            }
            return PlaceholderResource.INSTANCE;
        }
        return this.delegate.navigate(address);
    }

    public Set<String> getChildTypes() {
        LinkedHashSet<String> result = new LinkedHashSet<String>(this.delegate.getChildTypes());
        result.add("execution");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getChildrenNames(String childType) {
        if ("execution".equals(childType)) {
            Set<String> set = this.children;
            synchronized (set) {
                this.refreshChildren();
                return new LinkedHashSet<String>(this.children);
            }
        }
        return this.delegate.getChildrenNames(childType);
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        if ("execution".equals(childType)) {
            Set<String> names = this.getChildrenNames(childType);
            LinkedHashSet<Resource.ResourceEntry> result = new LinkedHashSet<Resource.ResourceEntry>(names.size());
            for (String name : names) {
                result.add((Resource.ResourceEntry)new PlaceholderResource.PlaceholderResourceEntry("execution", name));
            }
            return result;
        }
        return this.delegate.getChildren(childType);
    }

    public void registerChild(PathElement address, Resource resource) {
        String type = address.getKey();
        if ("execution".equals(type)) {
            throw BatchLogger.LOGGER.cannotRemoveResourceOfType(type);
        }
        this.delegate.registerChild(address, resource);
    }

    public void registerChild(PathElement address, int index, Resource resource) {
        throw BatchLogger.LOGGER.indexedChildResourceRegistrationNotAvailable(address);
    }

    public Resource removeChild(PathElement address) {
        String type = address.getKey();
        if ("execution".equals(type)) {
            throw BatchLogger.LOGGER.cannotRemoveResourceOfType(type);
        }
        return this.delegate.removeChild(address);
    }

    public Set<String> getOrderedChildTypes() {
        return Collections.emptySet();
    }

    public boolean isRuntime() {
        return this.delegate.isRuntime();
    }

    public boolean isProxy() {
        return this.delegate.isProxy();
    }

    public Resource clone() {
        return new BatchJobExecutionResource(this.delegate.clone(), this.jobOperator, this.jobName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasJobExecution(String executionName) {
        Set<String> set = this.children;
        synchronized (set) {
            if (this.children.contains(executionName)) {
                return true;
            }
            this.refreshChildren();
            return this.children.contains(executionName);
        }
    }

    private void refreshChildren() {
        ArrayList executions = new ArrayList();
        List instances = this.jobOperator.allowMissingJob(() -> this.jobOperator.getJobInstances(this.jobName, 0, this.jobOperator.getJobInstanceCount(this.jobName)), Collections.emptyList());
        for (JobInstance instance : instances) {
            executions.addAll(this.jobOperator.getJobExecutions(instance));
        }
        this.children.clear();
        for (JobExecution execution : executions) {
            String name = Long.toString(execution.getExecutionId());
            this.children.add(name);
        }
    }
}

