/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.context.InvocationContextFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.expiration.impl.InternalExpirationManager;
import org.infinispan.expiration.impl.TouchCommand;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@ThreadSafe
public class ExpirationManagerImpl<K, V>
implements InternalExpirationManager<K, V> {
    private static final Log log = LogFactory.getLog(ExpirationManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    @ComponentName(value="org.infinispan.executors.expiration")
    protected ScheduledExecutorService executor;
    @Inject
    protected Configuration configuration;
    @Inject
    protected PersistenceManager persistenceManager;
    @Inject
    protected ComponentRef<InternalDataContainer<K, V>> dataContainer;
    @Inject
    protected CacheNotifier<K, V> cacheNotifier;
    @Inject
    protected TimeService timeService;
    @Inject
    protected KeyPartitioner keyPartitioner;
    @Inject
    protected ComponentRef<CommandsFactory> cf;
    @Inject
    protected ComponentRef<AsyncInterceptorChain> invokerRef;
    @Inject
    protected ComponentRef<InvocationContextFactory> cfRef;
    @Inject
    protected ComponentRegistry componentRegistry;
    protected boolean enabled;
    protected String cacheName;
    protected ConcurrentMap<K, CompletableFuture<Boolean>> expiring = new ConcurrentHashMap<K, CompletableFuture<Boolean>>();
    protected ScheduledFuture<?> expirationTask;

    void initialize(ScheduledExecutorService executor, String cacheName, Configuration cfg) {
        this.executor = executor;
        this.configuration = cfg;
        this.cacheName = cacheName;
    }

    @Start(priority=55)
    public void start() {
        this.enabled = this.configuration.expiration().reaperEnabled();
        if (this.enabled) {
            long expWakeUpInt = this.configuration.expiration().wakeUpInterval();
            if (expWakeUpInt <= 0L) {
                log.notStartingEvictionThread();
                this.enabled = false;
            } else {
                this.expirationTask = this.executor.scheduleWithFixedDelay(new ScheduledTask(), expWakeUpInt, expWakeUpInt, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void processExpiration() {
        long start = 0L;
        if (!Thread.currentThread().isInterrupted()) {
            try {
                if (trace) {
                    log.trace("Purging data container of expired entries");
                    start = this.timeService.time();
                }
                long currentTimeMillis = this.timeService.wallClockTime();
                Iterator purgeCandidates = this.dataContainer.running().iteratorIncludingExpired();
                while (purgeCandidates.hasNext()) {
                    InternalCacheEntry e = purgeCandidates.next();
                    if (!e.isExpired(currentTimeMillis)) continue;
                    this.entryExpiredInMemory(e, currentTimeMillis, false);
                }
                if (trace) {
                    log.tracef("Purging data container completed in %s", Util.prettyPrintTime((long)this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
                }
            }
            catch (Exception e) {
                log.exceptionPurgingDataContainer(e);
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            this.persistenceManager.purgeExpired();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public CompletableFuture<Boolean> entryExpiredInMemory(InternalCacheEntry<K, V> entry, long currentTime, boolean hasLock) {
        this.dataContainer.running().compute(entry.getKey(), (k, oldEntry, factory) -> {
            if (oldEntry != null) {
                InternalCacheEntry internalCacheEntry = oldEntry;
                synchronized (internalCacheEntry) {
                    if (!oldEntry.isExpired(currentTime)) {
                        return oldEntry;
                    }
                    this.deleteFromStoresAndNotify(k, oldEntry.getValue(), oldEntry.getMetadata());
                }
            }
            return null;
        });
        return CompletableFutures.completedTrue();
    }

    @Override
    public boolean entryExpiredInMemoryFromIteration(InternalCacheEntry<K, V> entry, long currentTime) {
        return CompletionStages.join(this.entryExpiredInMemory(entry, currentTime, false));
    }

    private void entryExpiredInMemorySync(InternalCacheEntry<K, V> entry, long currentTime) {
        this.dataContainer.running().compute(entry.getKey(), (k, oldEntry, factory) -> {
            if (oldEntry != null) {
                InternalCacheEntry internalCacheEntry = oldEntry;
                synchronized (internalCacheEntry) {
                    if (!oldEntry.isExpired(currentTime)) {
                        return oldEntry;
                    }
                    this.deleteFromStoresAndNotifySync(k, oldEntry.getValue(), oldEntry.getMetadata());
                }
            }
            return null;
        });
    }

    private void deleteFromStoresAndNotifySync(K key, V value, Metadata metadata) {
        this.persistenceManager.deleteFromAllStores(key, this.keyPartitioner.getSegment(key), PersistenceManager.AccessMode.BOTH);
        this.cacheNotifier.notifyCacheEntryExpired(key, value, metadata, null);
    }

    @Override
    public void handleInMemoryExpiration(InternalCacheEntry<K, V> entry, long currentTime) {
        this.entryExpiredInMemory(entry, currentTime, false).join();
    }

    @Override
    public CompletionStage<Void> handleInStoreExpirationInternal(K key) {
        return this.handleInStoreExpirationInternal(key, null, null);
    }

    @Override
    public CompletionStage<Void> handleInStoreExpirationInternal(MarshalledEntry<K, V> marshalledEntry) {
        return this.handleInStoreExpirationInternal(marshalledEntry.getKey(), marshalledEntry.getValue(), marshalledEntry.getMetadata());
    }

    private CompletionStage<Void> handleInStoreExpirationInternal(K key, V value, Metadata metadata) {
        this.dataContainer.running().compute(key, (oldKey, oldEntry, factory) -> {
            long time;
            boolean shouldRemove = false;
            if (oldEntry == null) {
                shouldRemove = true;
                this.deleteFromStoresAndNotify(key, value, metadata);
            } else if (oldEntry.canExpire() && oldEntry.isExpired(time = this.timeService.time())) {
                InternalCacheEntry internalCacheEntry = oldEntry;
                synchronized (internalCacheEntry) {
                    if (oldEntry.isExpired(time) && (shouldRemove = !(metadata != null && !oldEntry.getMetadata().equals(metadata) || value != null && !value.equals(oldEntry.getValue())))) {
                        this.deleteFromStoresAndNotify(key, value, metadata);
                    }
                }
            }
            if (shouldRemove) {
                return null;
            }
            return oldEntry;
        });
        return CompletableFutures.completedNull();
    }

    private void deleteFromStoresAndNotify(K key, V value, Metadata metadata) {
        this.persistenceManager.deleteFromAllStores(key, this.keyPartitioner.getSegment(key), PersistenceManager.AccessMode.BOTH);
        this.cacheNotifier.notifyCacheEntryExpired(key, value, metadata, null);
    }

    @Override
    public CompletionStage<Boolean> handlePossibleExpiration(InternalCacheEntry<K, V> ice, int segment, boolean isWrite) {
        long currentTime = this.timeService.wallClockTime();
        if (ice.isExpired(currentTime)) {
            if (trace) {
                log.tracef("Retrieved entry for key %s was expired locally, attempting expiration removal", ice.getKey());
            }
            CompletionStage<Boolean> expiredStage = this.entryExpiredInMemory(ice, currentTime, isWrite);
            if (trace) {
                expiredStage = expiredStage.thenApply(expired -> {
                    if (expired == Boolean.FALSE) {
                        log.tracef("Retrieved entry for key %s was found to not be expired.", ice.getKey());
                    } else {
                        log.tracef("Retrieved entry for key %s was confirmed to be expired.", ice.getKey());
                    }
                    return expired;
                });
            }
            return expiredStage;
        }
        if (!isWrite && ice.canExpireMaxIdle()) {
            return this.touchEntryAndReturnIfExpired(ice, segment);
        }
        return CompletableFutures.completedFalse();
    }

    protected CompletionStage<Boolean> touchEntryAndReturnIfExpired(InternalCacheEntry entry, int segment) {
        TouchCommand touchCommand = this.cf.running().buildTouchCommand(entry.getKey(), segment);
        touchCommand.init(this.componentRegistry, false);
        CompletableFuture<Object> future = touchCommand.invokeAsync();
        return future.thenApply(touched -> touched == false);
    }

    @Stop(priority=5)
    public void stop() {
        if (this.expirationTask != null) {
            this.expirationTask.cancel(true);
        }
    }

    class ScheduledTask
    implements Runnable {
        ScheduledTask() {
        }

        @Override
        public void run() {
            LogFactory.pushNDC(ExpirationManagerImpl.this.cacheName, trace);
            try {
                ExpirationManagerImpl.this.processExpiration();
            }
            finally {
                LogFactory.popNDC(trace);
            }
        }
    }
}

