/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.expiration.impl;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.expiration.impl.ClusterExpirationManager;
import org.infinispan.transaction.LockingMode;

@ThreadSafe
public class TxClusterExpirationManager<K, V>
extends ClusterExpirationManager<K, V> {
    private boolean optimisticTransaction;

    @Override
    public void start() {
        super.start();
        this.optimisticTransaction = this.configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC;
    }

    @Override
    CompletableFuture<Boolean> removeLifespan(AdvancedCache<K, V> cacheToUse, K key, V value, long lifespan) {
        return CompletableFuture.supplyAsync(() -> super.removeLifespan(cacheToUse, key, value, lifespan), this.asyncExecutor).thenCompose(Function.identity());
    }

    @Override
    CompletableFuture<Boolean> removeMaxIdle(AdvancedCache<K, V> cacheToUse, K key, V value) {
        return CompletableFuture.supplyAsync(() -> cacheToUse.removeMaxIdleExpired(key, value), this.asyncExecutor).thenCompose(Function.identity());
    }

    @Override
    boolean waitOnLifespanExpiration(boolean isWrite) {
        return isWrite || this.optimisticTransaction;
    }

    @Override
    AdvancedCache<K, V> cacheToUse(boolean isWrite) {
        return isWrite ? (this.optimisticTransaction ? this.cache : this.cache.withFlags(Flag.SKIP_LOCKING)) : this.cache.withFlags(Flag.ZERO_LOCK_ACQUISITION_TIMEOUT);
    }
}

