/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.stream.impl.ClusterStreamManager;
import org.infinispan.stream.impl.ClusterStreamManagerImpl;
import org.infinispan.stream.impl.LocalStreamManager;
import org.infinispan.stream.impl.LocalStreamManagerImpl;
import org.infinispan.stream.impl.PartitionAwareClusterStreamManager;

@DefaultFactoryFor(classes={LocalStreamManager.class, ClusterStreamManager.class})
public class StreamManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public Object construct(String componentName) {
        CacheMode cacheMode = this.configuration.clustering().cacheMode();
        if (cacheMode.needsStateTransfer()) {
            if (componentName.equals(LocalStreamManager.class.getName())) {
                return new LocalStreamManagerImpl();
            }
            if (componentName.equals(ClusterStreamManager.class.getName())) {
                if (this.configuration.clustering().partitionHandling().whenSplit() != PartitionHandling.ALLOW_READ_WRITES) {
                    return new PartitionAwareClusterStreamManager();
                }
                return new ClusterStreamManagerImpl();
            }
        }
        return null;
    }
}

