/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.notifications.cachelistener;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.stream.BaseStream;
import java.util.stream.Stream;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.SegmentSpecificCommand;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.util.ServiceFinder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.distexec.DistributedExecutionCompletionService;
import org.infinispan.distexec.DistributedExecutorService;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.KeyFilter;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.BaseQueueingSegmentListener;
import org.infinispan.notifications.cachelistener.CacheEntryListenerInvocation;
import org.infinispan.notifications.cachelistener.DistributedQueueingSegmentListener;
import org.infinispan.notifications.cachelistener.EventWrapper;
import org.infinispan.notifications.cachelistener.ListenerHolder;
import org.infinispan.notifications.cachelistener.QueueingAllSegmentListener;
import org.infinispan.notifications.cachelistener.QueueingSegmentListener;
import org.infinispan.notifications.cachelistener.SecurityActions;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.annotation.DataRehashed;
import org.infinispan.notifications.cachelistener.annotation.PartitionStatusChanged;
import org.infinispan.notifications.cachelistener.annotation.PersistenceAvailabilityChanged;
import org.infinispan.notifications.cachelistener.annotation.TopologyChanged;
import org.infinispan.notifications.cachelistener.annotation.TransactionCompleted;
import org.infinispan.notifications.cachelistener.annotation.TransactionRegistered;
import org.infinispan.notifications.cachelistener.cluster.ClusterCacheNotifier;
import org.infinispan.notifications.cachelistener.cluster.ClusterEventManager;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerRemoveCallable;
import org.infinispan.notifications.cachelistener.cluster.ClusterListenerReplicateCallable;
import org.infinispan.notifications.cachelistener.cluster.RemoteClusterListener;
import org.infinispan.notifications.cachelistener.event.CacheEntriesEvictedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryCreatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryExpiredEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryInvalidatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryLoadedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryModifiedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryPassivatedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.notifications.cachelistener.event.CacheEntryVisitedEvent;
import org.infinispan.notifications.cachelistener.event.DataRehashedEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.PartitionStatusChangedEvent;
import org.infinispan.notifications.cachelistener.event.PersistenceAvailabilityChangedEvent;
import org.infinispan.notifications.cachelistener.event.TopologyChangedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionCompletedEvent;
import org.infinispan.notifications.cachelistener.event.TransactionRegisteredEvent;
import org.infinispan.notifications.cachelistener.event.impl.EventImpl;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverterAsConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterAsKeyValueFilter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilterConverterAsKeyValueFilterConverter;
import org.infinispan.notifications.cachelistener.filter.DelegatingCacheEntryListenerInvocation;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.notifications.cachelistener.filter.FilterIndexingServiceProvider;
import org.infinispan.notifications.cachelistener.filter.IndexedFilter;
import org.infinispan.notifications.cachelistener.filter.KeyFilterAsCacheEventFilter;
import org.infinispan.notifications.impl.AbstractListenerImpl;
import org.infinispan.notifications.impl.ListenerInvocation;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.topology.CacheTopology;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public final class CacheNotifierImpl<K, V>
extends AbstractListenerImpl<Event<K, V>, CacheEntryListenerInvocation<K, V>>
implements ClusterCacheNotifier<K, V> {
    private static final Log log = LogFactory.getLog(CacheNotifierImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final Map<Class<? extends Annotation>, Class<?>> allowedListeners = new HashMap(16);
    private static final Map<Class<? extends Annotation>, Class<?>> clusterAllowedListeners = new HashMap(4);
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryCreatedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryRemovedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryVisitedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryModifiedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryActivatedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryPassivatedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryLoadedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryInvalidatedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntryExpiredListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> cacheEntriesEvictedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> transactionRegisteredListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> transactionCompletedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> dataRehashedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> topologyChangedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> partitionChangedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    final List<CacheEntryListenerInvocation<K, V>> persistenceChangedListeners = new CopyOnWriteArrayList<CacheEntryListenerInvocation<K, V>>();
    @Inject
    private TransactionManager transactionManager;
    @Inject
    private Configuration config;
    @Inject
    private InternalEntryFactory entryFactory;
    @Inject
    private ClusterEventManager<K, V> eventManager;
    @Inject
    private BasicComponentRegistry componentRegistry;
    @Inject
    private KeyPartitioner keyPartitioner;
    @Inject
    private RpcManager rpcManager;
    @Inject
    private ComponentRef<AdvancedCache<K, V>> cache;
    @Inject
    private ComponentRef<ClusteringDependentLogic> clusteringDependentLogic;
    @Inject
    private ComponentRef<AsyncInterceptorChain> interceptorChain;
    private DistributedExecutorService distExecutorService;
    private final Map<Object, UUID> clusterListenerIDs = new ConcurrentHashMap<Object, UUID>();
    private Collection<FilterIndexingServiceProvider> filterIndexingServiceProviders;
    private final ConcurrentMap<UUID, QueueingSegmentListener<K, V, ? extends Event<K, V>>> segmentHandler;

    public CacheNotifierImpl() {
        this(new ConcurrentHashMap<UUID, QueueingSegmentListener<K, V, ? extends Event<K, V>>>());
    }

    CacheNotifierImpl(ConcurrentMap<UUID, QueueingSegmentListener<K, V, ? extends Event<K, V>>> handler) {
        this.segmentHandler = handler;
        this.listenersMap.put(CacheEntryCreated.class, this.cacheEntryCreatedListeners);
        this.listenersMap.put(CacheEntryRemoved.class, this.cacheEntryRemovedListeners);
        this.listenersMap.put(CacheEntryVisited.class, this.cacheEntryVisitedListeners);
        this.listenersMap.put(CacheEntryModified.class, this.cacheEntryModifiedListeners);
        this.listenersMap.put(CacheEntryActivated.class, this.cacheEntryActivatedListeners);
        this.listenersMap.put(CacheEntryPassivated.class, this.cacheEntryPassivatedListeners);
        this.listenersMap.put(CacheEntryLoaded.class, this.cacheEntryLoadedListeners);
        this.listenersMap.put(CacheEntriesEvicted.class, this.cacheEntriesEvictedListeners);
        this.listenersMap.put(CacheEntryExpired.class, this.cacheEntryExpiredListeners);
        this.listenersMap.put(TransactionRegistered.class, this.transactionRegisteredListeners);
        this.listenersMap.put(TransactionCompleted.class, this.transactionCompletedListeners);
        this.listenersMap.put(CacheEntryInvalidated.class, this.cacheEntryInvalidatedListeners);
        this.listenersMap.put(DataRehashed.class, this.dataRehashedListeners);
        this.listenersMap.put(TopologyChanged.class, this.topologyChangedListeners);
        this.listenersMap.put(PartitionStatusChanged.class, this.partitionChangedListeners);
        this.listenersMap.put(PersistenceAvailabilityChanged.class, this.persistenceChangedListeners);
    }

    @Override
    public void start() {
        super.start();
        if (!this.config.simpleCache()) {
            this.distExecutorService = SecurityActions.getDefaultExecutorService((Cache)this.cache.wired());
        }
        Collection providers = ServiceFinder.load(FilterIndexingServiceProvider.class, (ClassLoader[])new ClassLoader[0]);
        this.filterIndexingServiceProviders = new ArrayList<FilterIndexingServiceProvider>(providers.size());
        for (FilterIndexingServiceProvider provider : providers) {
            this.componentRegistry.wireDependencies(provider, false);
            provider.start();
            this.filterIndexingServiceProviders.add(provider);
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.filterIndexingServiceProviders != null) {
            for (FilterIndexingServiceProvider provider : this.filterIndexingServiceProviders) {
                provider.stop();
            }
            this.filterIndexingServiceProviders = null;
        }
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected Map<Class<? extends Annotation>, Class<?>> getAllowedMethodAnnotations(Listener l) {
        if (l.clustered()) {
            return clusterAllowedListeners;
        }
        return allowedListeners;
    }

    private K convertKey(CacheEntryListenerInvocation listenerInvocation, K key) {
        MediaType convertFormat;
        if (key == null) {
            return null;
        }
        DataConversion keyDataConversion = listenerInvocation.getKeyDataConversion();
        Wrapper wrp = keyDataConversion.getWrapper();
        Object unwrappedKey = keyDataConversion.getEncoder().fromStorage(wrp.unwrap(key));
        CacheEventFilter filter = listenerInvocation.getFilter();
        CacheEventConverter converter = listenerInvocation.getConverter();
        if (filter == null && converter == null) {
            if (listenerInvocation.useStorageFormat()) {
                return (K)unwrappedKey;
            }
            return (K)keyDataConversion.fromStorage(key);
        }
        MediaType mediaType = convertFormat = filter == null ? converter.format() : filter.format();
        if (listenerInvocation.useStorageFormat() || convertFormat == null) {
            return (K)unwrappedKey;
        }
        return (K)keyDataConversion.convert(unwrappedKey, keyDataConversion.getStorageMediaType(), convertFormat);
    }

    private V convertValue(CacheEntryListenerInvocation listenerInvocation, V value) {
        MediaType convertFormat;
        if (value == null) {
            return null;
        }
        DataConversion valueDataConversion = listenerInvocation.getValueDataConversion();
        Wrapper wrp = valueDataConversion.getWrapper();
        Object unwrappedValue = valueDataConversion.getEncoder().fromStorage(wrp.unwrap(value));
        CacheEventFilter filter = listenerInvocation.getFilter();
        CacheEventConverter converter = listenerInvocation.getConverter();
        if (filter == null && converter == null) {
            if (listenerInvocation.useStorageFormat()) {
                return (V)unwrappedValue;
            }
            return (V)valueDataConversion.fromStorage(value);
        }
        MediaType mediaType = convertFormat = filter == null ? converter.format() : filter.format();
        if (listenerInvocation.useStorageFormat() || convertFormat == null) {
            return (V)unwrappedValue;
        }
        return (V)valueDataConversion.convert(unwrappedValue, valueDataConversion.getStorageMediaType(), convertFormat);
    }

    @Override
    protected final Transaction suspendIfNeeded() {
        if (this.transactionManager == null) {
            return null;
        }
        try {
            switch (this.transactionManager.getStatus()) {
                case 0: 
                case 6: {
                    return null;
                }
            }
            return this.transactionManager.suspend();
        }
        catch (Exception e) {
            if (trace) {
                log.trace("An error occurred while trying to suspend a transaction.", e);
            }
            return null;
        }
    }

    @Override
    protected final void resumeIfNeeded(Transaction transaction) {
        block3: {
            if (transaction == null || this.transactionManager == null) {
                return;
            }
            try {
                this.transactionManager.resume(transaction);
            }
            catch (Exception e) {
                if (!trace) break block3;
                log.tracef(e, "An error occurred while trying to resume a suspended transaction. tx=%s", transaction);
            }
        }
    }

    int extractSegment(FlagAffectedCommand command, Object key) {
        return SegmentSpecificCommand.extractSegment(command, key, this.keyPartitioner);
    }

    @Override
    public void notifyCacheEntryCreated(K key, V value, Metadata metadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryCreatedListeners)) {
            this.doNotifyCreated(key, value, metadata, pre, ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotifyCreated(K key, V value, Metadata metadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (!this.cacheEntryCreatedListeners.isEmpty() && this.clusteringDependentLogic.running().commitType(command, ctx, this.extractSegment(command, key), false).isLocal()) {
            if (command != null && command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER)) {
                return;
            }
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_CREATED);
            boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
            boolean sendEvents = !ctx.isInTxScope();
            try {
                for (CacheEntryListenerInvocation listener : this.cacheEntryCreatedListeners) {
                    this.configureEvent(listener, e, key, value, metadata, pre, ctx, command, null, null);
                    listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner);
                }
                if (sendEvents) {
                    this.eventManager.sendEvents();
                    sendEvents = false;
                }
            }
            finally {
                if (sendEvents) {
                    this.eventManager.dropEvents();
                }
            }
        }
    }

    @Override
    public void notifyCacheEntryModified(K key, V value, Metadata metadata, V previousValue, Metadata previousMetadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryModifiedListeners)) {
            this.doNotifyModified(key, value, metadata, previousValue, previousMetadata, pre, ctx, command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doNotifyModified(K key, V value, Metadata metadata, V previousValue, Metadata previousMetadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (!this.cacheEntryModifiedListeners.isEmpty() && this.clusteringDependentLogic.running().commitType(command, ctx, this.extractSegment(command, key), false).isLocal()) {
            if (command != null && command.hasAnyFlag(FlagBitSets.PUT_FOR_STATE_TRANSFER)) {
                return;
            }
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_MODIFIED);
            boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
            boolean sendEvents = !ctx.isInTxScope();
            try {
                for (CacheEntryListenerInvocation listener : this.cacheEntryModifiedListeners) {
                    this.configureEvent(listener, e, key, value, metadata, pre, ctx, command, previousValue, previousMetadata);
                    listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner);
                }
                if (sendEvents) {
                    this.eventManager.sendEvents();
                    sendEvents = false;
                }
            }
            finally {
                if (sendEvents) {
                    this.eventManager.dropEvents();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCacheEntryRemoved(K key, V previousValue, Metadata previousMetadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryRemovedListeners) && this.clusteringDependentLogic.running().commitType(command, ctx, this.extractSegment(command, key), true).isLocal()) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_REMOVED);
            boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
            boolean sendEvents = !ctx.isInTxScope();
            try {
                for (CacheEntryListenerInvocation listener : this.cacheEntryRemovedListeners) {
                    if (pre) {
                        this.configureEvent(listener, e, key, previousValue, previousMetadata, true, ctx, command, previousValue, previousMetadata);
                    } else {
                        this.configureEvent(listener, e, key, null, previousMetadata, false, ctx, command, previousValue, previousMetadata);
                    }
                    listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner);
                }
                if (sendEvents) {
                    this.eventManager.sendEvents();
                    sendEvents = false;
                }
            }
            finally {
                if (sendEvents) {
                    this.eventManager.dropEvents();
                }
            }
        }
    }

    private void configureEvent(CacheEntryListenerInvocation listenerInvocation, EventImpl<K, V> e, K key, V value, Metadata metadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command, V previousValue, Metadata previousMetadata) {
        key = this.convertKey(listenerInvocation, key);
        value = this.convertValue(listenerInvocation, value);
        previousValue = this.convertValue(listenerInvocation, previousValue);
        e.setOriginLocal(ctx.isOriginLocal());
        e.setValue(pre ? previousValue : value);
        e.setPre(pre);
        e.setOldValue(previousValue);
        e.setOldMetadata(previousMetadata);
        e.setMetadata(metadata);
        if (command != null && command.hasAnyFlag(FlagBitSets.COMMAND_RETRY)) {
            e.setCommandRetried(true);
        }
        e.setKey(key);
        this.setTx(ctx, e);
    }

    private void configureEvent(CacheEntryListenerInvocation listenerInvocation, EventImpl<K, V> e, K key, V value, boolean pre, InvocationContext ctx) {
        e.setPre(pre);
        e.setKey(this.convertKey(listenerInvocation, key));
        e.setValue(this.convertValue(listenerInvocation, value));
        e.setOriginLocal(ctx.isOriginLocal());
        this.setTx(ctx, e);
    }

    private void configureEvent(CacheEntryListenerInvocation listenerInvocation, EventImpl<K, V> e, K key, V value, Metadata metadata) {
        e.setKey(this.convertKey(listenerInvocation, key));
        e.setValue(this.convertValue(listenerInvocation, value));
        e.setMetadata(metadata);
        e.setOriginLocal(true);
        e.setPre(false);
    }

    private void doVisitNotify(K key, V value, boolean pre, InvocationContext ctx) {
        EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_VISITED);
        boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
        for (CacheEntryListenerInvocation listener : this.cacheEntryVisitedListeners) {
            this.configureEvent(listener, e, key, value, pre, ctx);
            listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner);
        }
    }

    @Override
    public void notifyCacheEntryVisited(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryVisitedListeners)) {
            this.doVisitNotify(key, value, pre, ctx);
        }
    }

    @Override
    public void notifyCacheEntriesEvicted(Collection<InternalCacheEntry<? extends K, ? extends V>> entries, InvocationContext ctx, FlagAffectedCommand command) {
        if (!entries.isEmpty() && this.isNotificationAllowed(command, this.cacheEntriesEvictedListeners)) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_EVICTED);
            for (CacheEntryListenerInvocation<K, V> listener : this.cacheEntriesEvictedListeners) {
                HashMap evictedKeysAndValues = new HashMap();
                for (Map.Entry entry : entries) {
                    evictedKeysAndValues.put(this.convertKey(listener, entry.getKey()), this.convertValue(listener, entry.getValue()));
                }
                e.setEntries(evictedKeysAndValues);
                listener.invoke(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyCacheEntryExpired(K key, V value, Metadata metadata, InvocationContext ctx) {
        if (this.isNotificationAllowed(null, this.cacheEntryExpiredListeners)) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_EXPIRED);
            boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
            boolean sendEvents = ctx == null || !ctx.isInTxScope();
            try {
                for (CacheEntryListenerInvocation listener : this.cacheEntryExpiredListeners) {
                    this.configureEvent(listener, e, key, value, metadata);
                    listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner);
                }
                if (sendEvents) {
                    this.eventManager.sendEvents();
                    sendEvents = false;
                }
            }
            finally {
                if (sendEvents) {
                    this.eventManager.dropEvents();
                }
            }
        }
    }

    @Override
    public void notifyCacheEntryInvalidated(K key, V value, Metadata metadata, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryInvalidatedListeners)) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_INVALIDATED);
            boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
            for (CacheEntryListenerInvocation listener : this.cacheEntryInvalidatedListeners) {
                this.configureEvent(listener, e, key, value, metadata, pre, ctx, command, value, metadata);
                listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyCacheEntryLoaded(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryLoadedListeners)) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_LOADED);
            boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
            for (CacheEntryListenerInvocation listener : this.cacheEntryLoadedListeners) {
                this.configureEvent(listener, e, key, value, pre, ctx);
                listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner);
            }
        }
    }

    @Override
    public void notifyCacheEntryActivated(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryActivatedListeners)) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_ACTIVATED);
            boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
            for (CacheEntryListenerInvocation listener : this.cacheEntryActivatedListeners) {
                this.configureEvent(listener, e, key, value, pre, ctx);
                listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner);
            }
        }
    }

    private void setTx(InvocationContext ctx, EventImpl<K, V> e) {
        if (ctx != null && ctx.isInTxScope()) {
            GlobalTransaction tx = ((TxInvocationContext)ctx).getGlobalTransaction();
            e.setTransactionId(tx);
        }
    }

    @Override
    public void notifyCacheEntryPassivated(K key, V value, boolean pre, InvocationContext ctx, FlagAffectedCommand command) {
        if (this.isNotificationAllowed(command, this.cacheEntryPassivatedListeners)) {
            EventImpl<K, V> e = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_PASSIVATED);
            boolean isLocalNodePrimaryOwner = this.isLocalNodePrimaryOwner(key);
            for (CacheEntryListenerInvocation listener : this.cacheEntryPassivatedListeners) {
                key = this.convertKey(listener, key);
                value = this.convertValue(listener, value);
                e.setPre(pre);
                e.setKey(key);
                e.setValue(value);
                listener.invoke(new EventWrapper(key, e), isLocalNodePrimaryOwner);
            }
        }
    }

    private boolean isLocalNodePrimaryOwner(K key) {
        return this.clusteringDependentLogic.running().getCacheTopology().getDistribution(key).isPrimary();
    }

    @Override
    public void notifyTransactionCompleted(GlobalTransaction transaction, boolean successful, InvocationContext ctx) {
        if (!this.transactionCompletedListeners.isEmpty()) {
            boolean isOriginLocal = ctx.isOriginLocal();
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.TRANSACTION_COMPLETED);
            e.setOriginLocal(isOriginLocal);
            e.setTransactionId(transaction);
            e.setTransactionSuccessful(successful);
            for (CacheEntryListenerInvocation<K, V> listener : this.transactionCompletedListeners) {
                listener.invoke(e);
            }
            if (ctx.isInTxScope()) {
                if (successful) {
                    this.eventManager.sendEvents();
                } else {
                    this.eventManager.dropEvents();
                }
            }
        }
    }

    @Override
    public void notifyTransactionRegistered(GlobalTransaction globalTransaction, boolean isOriginLocal) {
        if (!this.transactionRegisteredListeners.isEmpty()) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.TRANSACTION_REGISTERED);
            e.setOriginLocal(isOriginLocal);
            e.setTransactionId(globalTransaction);
            for (CacheEntryListenerInvocation<K, V> listener : this.transactionRegisteredListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyDataRehashed(ConsistentHash oldCH, ConsistentHash newCH, ConsistentHash unionCH, int newTopologyId, boolean pre) {
        if (!this.dataRehashedListeners.isEmpty()) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.DATA_REHASHED);
            e.setPre(pre);
            e.setReadConsistentHashAtStart(oldCH);
            e.setWriteConsistentHashAtStart(oldCH);
            e.setReadConsistentHashAtEnd(newCH);
            e.setWriteConsistentHashAtEnd(newCH);
            e.setUnionConsistentHash(unionCH);
            e.setNewTopologyId(newTopologyId);
            for (CacheEntryListenerInvocation<K, V> listener : this.dataRehashedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyTopologyChanged(CacheTopology oldTopology, CacheTopology newTopology, int newTopologyId, boolean pre) {
        if (!this.topologyChangedListeners.isEmpty()) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.TOPOLOGY_CHANGED);
            e.setPre(pre);
            if (oldTopology != null) {
                e.setReadConsistentHashAtStart(oldTopology.getReadConsistentHash());
                e.setWriteConsistentHashAtStart(oldTopology.getWriteConsistentHash());
            }
            e.setReadConsistentHashAtEnd(newTopology.getReadConsistentHash());
            e.setWriteConsistentHashAtEnd(newTopology.getWriteConsistentHash());
            e.setNewTopologyId(newTopologyId);
            for (CacheEntryListenerInvocation<K, V> listener : this.topologyChangedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyPartitionStatusChanged(AvailabilityMode mode, boolean pre) {
        if (!this.partitionChangedListeners.isEmpty()) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.PARTITION_STATUS_CHANGED);
            e.setPre(pre);
            e.setAvailabilityMode(mode);
            for (CacheEntryListenerInvocation<K, V> listener : this.partitionChangedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyPersistenceAvailabilityChanged(boolean available) {
        if (!this.persistenceChangedListeners.isEmpty()) {
            EventImpl e = EventImpl.createEvent(this.cache.wired(), Event.Type.PERSISTENCE_AVAILABILITY_CHANGED);
            e.setAvailable(available);
            for (CacheEntryListenerInvocation<K, V> listener : this.persistenceChangedListeners) {
                listener.invoke(e);
            }
        }
    }

    @Override
    public void notifyClusterListeners(Collection<? extends CacheEntryEvent<K, V>> events, UUID uuid) {
        block6: for (CacheEntryEvent event : events) {
            if (event.isPre()) {
                throw new IllegalArgumentException("Events for cluster listener should never be pre change");
            }
            switch (event.getType()) {
                case CACHE_ENTRY_MODIFIED: {
                    for (CacheEntryListenerInvocation listener2 : this.cacheEntryModifiedListeners) {
                        if (!listener2.isClustered() || !uuid.equals(listener2.getIdentifier())) continue;
                        listener2.invokeNoChecks(new EventWrapper(event.getKey(), event), false, true, false);
                    }
                    continue block6;
                }
                case CACHE_ENTRY_CREATED: {
                    for (CacheEntryListenerInvocation listener2 : this.cacheEntryCreatedListeners) {
                        if (!listener2.isClustered() || !uuid.equals(listener2.getIdentifier())) continue;
                        listener2.invokeNoChecks(new EventWrapper(event.getKey(), event), false, true, false);
                    }
                    continue block6;
                }
                case CACHE_ENTRY_REMOVED: {
                    for (CacheEntryListenerInvocation listener2 : this.cacheEntryRemovedListeners) {
                        if (!listener2.isClustered() || !uuid.equals(listener2.getIdentifier())) continue;
                        listener2.invokeNoChecks(new EventWrapper(event.getKey(), event), false, true, false);
                    }
                    continue block6;
                }
                case CACHE_ENTRY_EXPIRED: {
                    this.cacheEntryExpiredListeners.forEach(listener -> {
                        if (listener.isClustered() && uuid.equals(listener.getIdentifier())) {
                            listener.invokeNoChecks(new EventWrapper(event.getKey(), event), false, true, false);
                        }
                    });
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected event type encountered!");
                }
            }
        }
    }

    @Override
    public Collection<DistributedCallable> retrieveClusterListenerCallablesToInstall() {
        HashSet<Object> enlistedAlready = new HashSet<Object>();
        HashSet<DistributedCallable> callables = new HashSet<DistributedCallable>();
        if (trace) {
            log.tracef("Request received to get cluster listeners currently registered", new Object[0]);
        }
        this.registerClusterListenerCallablesToInstall(enlistedAlready, callables, this.cacheEntryModifiedListeners);
        this.registerClusterListenerCallablesToInstall(enlistedAlready, callables, this.cacheEntryCreatedListeners);
        this.registerClusterListenerCallablesToInstall(enlistedAlready, callables, this.cacheEntryRemovedListeners);
        if (trace) {
            log.tracef("Cluster listeners found %s", callables);
        }
        return callables;
    }

    private void registerClusterListenerCallablesToInstall(Set<Object> enlistedAlready, Set<DistributedCallable> callables, List<CacheEntryListenerInvocation<K, V>> listenerInvocations) {
        for (CacheEntryListenerInvocation<K, V> listener : listenerInvocations) {
            if (enlistedAlready.contains(listener.getTarget())) continue;
            if (listener.isClustered()) {
                Set<Class<? extends Annotation>> filterAnnotations = listener.getFilterAnnotations();
                callables.add(new ClusterListenerReplicateCallable<K, V>(listener.getIdentifier(), this.rpcManager.getAddress(), listener.getFilter(), listener.getConverter(), listener.isSync(), filterAnnotations, listener.getKeyDataConversion(), listener.getValueDataConversion(), listener.useStorageFormat()));
                enlistedAlready.add(listener.getTarget());
                continue;
            }
            if (!(listener.getTarget() instanceof RemoteClusterListener)) continue;
            RemoteClusterListener lcl = (RemoteClusterListener)listener.getTarget();
            Set<Class<? extends Annotation>> filterAnnotations = listener.getFilterAnnotations();
            callables.add(new ClusterListenerReplicateCallable<K, V>(lcl.getId(), lcl.getOwnerAddress(), listener.getFilter(), listener.getConverter(), listener.isSync(), filterAnnotations, listener.getKeyDataConversion(), listener.getValueDataConversion(), listener.useStorageFormat()));
            enlistedAlready.add(listener.getTarget());
        }
    }

    public boolean isNotificationAllowed(FlagAffectedCommand cmd, List<CacheEntryListenerInvocation<K, V>> listeners) {
        return !listeners.isEmpty() && (cmd == null || !cmd.hasAnyFlag(FlagBitSets.SKIP_LISTENER_NOTIFICATION));
    }

    @Override
    public void addListener(Object listener) {
        this.addListener(listener, null, null, null);
    }

    @Override
    public void addListener(Object listener, ClassLoader classLoader) {
        this.addListener(listener, null, null, classLoader);
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter, ClassLoader classLoader) {
        this.addListener(listener, new KeyFilterAsCacheEventFilter<K>(filter), null, classLoader);
    }

    private <C> void addListenerInternal(Object listener, DataConversion keyDataConversion, DataConversion valueDataConversion, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, ClassLoader classLoader, boolean useStorageFormat) {
        QueueingSegmentListener handler;
        CacheInvocationBuilder builder;
        DataConversion valueConversion;
        Listener l = CacheNotifierImpl.testListenerClassValidity(listener.getClass());
        UUID generatedId = UUID.randomUUID();
        CacheMode cacheMode = this.config.clustering().cacheMode();
        FilterIndexingServiceProvider indexingProvider = null;
        boolean foundMethods = false;
        DataConversion keyConversion = keyDataConversion == null ? DataConversion.IDENTITY_KEY : keyDataConversion;
        DataConversion dataConversion = valueConversion = valueDataConversion == null ? DataConversion.IDENTITY_VALUE : valueDataConversion;
        if (filter instanceof IndexedFilter && (indexingProvider = this.findIndexingServiceProvider((IndexedFilter)filter)) != null) {
            builder = new DelegatingCacheInvocationBuilder(indexingProvider);
            builder.setIncludeCurrentState(l.includeCurrentState()).setClustered(l.clustered()).setOnlyPrimary(l.clustered() ? cacheMode.isDistributed() || cacheMode.isScattered() : l.primaryOnly()).setObservation(l.clustered() ? Listener.Observation.POST : l.observation()).setFilter(filter).setConverter(converter).setIdentifier(generatedId).setKeyDataConversion(keyConversion).setValueDataConversion(valueConversion).setClassLoader(classLoader);
            foundMethods = this.validateAndAddListenerInvocations(listener, builder);
            ((DelegatingCacheInvocationBuilder)builder).registerListenerInvocations();
        }
        if (indexingProvider == null) {
            builder = new CacheInvocationBuilder();
            builder.setIncludeCurrentState(l.includeCurrentState()).setClustered(l.clustered()).setOnlyPrimary(l.clustered() ? cacheMode.isDistributed() || cacheMode.isScattered() : l.primaryOnly()).setObservation(l.clustered() ? Listener.Observation.POST : l.observation()).setFilter(filter).setConverter(converter).setKeyDataConversion(keyConversion).setValueDataConversion(valueConversion).setIdentifier(generatedId).setClassLoader(classLoader);
            if (l.clustered()) {
                builder.setFilterAnnotations(this.findListenerCallbacks(listener));
            }
            foundMethods = this.validateAndAddListenerInvocations(listener, builder);
        }
        if (foundMethods && l.clustered()) {
            if (l.observation() == Listener.Observation.PRE) {
                throw log.clusterListenerRegisteredWithOnlyPreEvents(listener.getClass());
            }
            if (cacheMode.isInvalidation()) {
                throw new UnsupportedOperationException("Cluster listeners cannot be used with Invalidation Caches!");
            }
            if (cacheMode.isDistributed() || cacheMode.isScattered()) {
                this.clusterListenerIDs.put(listener, generatedId);
                Address ourAddress = null;
                List<Address> members = null;
                if (this.rpcManager != null) {
                    ourAddress = this.rpcManager.getAddress();
                    members = this.rpcManager.getMembers();
                }
                if (members != null && members.size() > 1) {
                    DistributedExecutionCompletionService<Void> decs = new DistributedExecutionCompletionService<Void>(this.distExecutorService);
                    if (trace) {
                        log.tracef("Replicating cluster listener to other nodes %s for cluster listener with id %s", members, generatedId);
                    }
                    ClusterListenerReplicateCallable<? super K, ? super V> callable = new ClusterListenerReplicateCallable<K, V>(generatedId, ourAddress, filter, converter, l.sync(), this.findListenerCallbacks(listener), keyDataConversion, valueDataConversion, useStorageFormat);
                    for (Address member : members) {
                        if (member.equals(ourAddress)) continue;
                        decs.submit(member, callable);
                    }
                    for (int i = 0; i < members.size() - 1; ++i) {
                        try {
                            ((CompletableFuture)decs.take()).get();
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new CacheListenerException((Throwable)e);
                        }
                        catch (ExecutionException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof SuspectException) continue;
                            throw new CacheListenerException(cause);
                        }
                    }
                    int extraCount = 0;
                    List<Address> membersAfter = this.rpcManager.getMembers();
                    for (Address member : membersAfter) {
                        if (members.contains(member) || member.equals(ourAddress)) continue;
                        if (trace) {
                            log.tracef("Found additional node %s that joined during replication of cluster listener with id %s", member, generatedId);
                        }
                        ++extraCount;
                        decs.submit(member, callable);
                    }
                    for (int i = 0; i < extraCount; ++i) {
                        try {
                            ((CompletableFuture)decs.take()).get();
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new CacheListenerException((Throwable)e);
                        }
                        catch (ExecutionException e) {
                            throw new CacheListenerException((Throwable)e);
                        }
                    }
                }
            }
        }
        if ((handler = (QueueingSegmentListener)this.segmentHandler.remove(generatedId)) != null) {
            if (trace) {
                log.tracef("Listener %s requests initial state for cache", generatedId);
            }
            try (Stream entryStream = this.cache.wired().withEncoding(keyConversion.getEncoderClass(), valueConversion.getEncoderClass()).cacheEntrySet().stream();){
                BaseStream usedStream = entryStream.segmentCompletionListener(handler);
                if (filter instanceof CacheEventFilterConverter && (filter == converter || converter == null)) {
                    usedStream = CacheFilters.filterAndConvert(usedStream, new CacheEventFilterConverterAsKeyValueFilterConverter((CacheEventFilterConverter)filter));
                } else {
                    usedStream = filter == null ? usedStream : usedStream.filter(CacheFilters.predicate(new CacheEventFilterAsKeyValueFilter<K, V>(filter)));
                    usedStream = converter == null ? usedStream : usedStream.map(CacheFilters.function(new CacheEventConverterAsConverter<K, V, C>(converter)));
                }
                Iterator iterator = usedStream.iterator();
                while (iterator.hasNext()) {
                    CacheEntry entry = (CacheEntry)iterator.next();
                    Object value = handler.markKeyAsProcessing(entry.getKey());
                    if (value == BaseQueueingSegmentListener.REMOVED) continue;
                    this.raiseEventForInitialTransfer(generatedId, entry, l.clustered(), null, null);
                    handler.notifiedKey(entry.getKey());
                }
            }
            Set entries = handler.findCreatedEntries();
            for (CacheEntry entry : entries) {
                this.raiseEventForInitialTransfer(generatedId, entry, l.clustered(), null, null);
            }
            handler.transferComplete();
            if (trace) {
                log.tracef("Listener %s initial state for cache completed", generatedId);
            }
        }
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, ClassLoader classLoader) {
        this.addListenerInternal(listener, DataConversion.IDENTITY_KEY, DataConversion.IDENTITY_VALUE, filter, converter, classLoader, false);
    }

    private FilterIndexingServiceProvider findIndexingServiceProvider(IndexedFilter indexedFilter) {
        if (this.filterIndexingServiceProviders != null) {
            for (FilterIndexingServiceProvider provider : this.filterIndexingServiceProviders) {
                if (!provider.supportsFilter(indexedFilter)) continue;
                return provider;
            }
        }
        log.noFilterIndexingServiceProviderFound(indexedFilter.getClass().getName());
        return null;
    }

    @Override
    public List<CacheEntryListenerInvocation<K, V>> getListenerCollectionForAnnotation(Class<? extends Annotation> annotation) {
        return super.getListenerCollectionForAnnotation(annotation);
    }

    private void raiseEventForInitialTransfer(UUID identifier, CacheEntry entry, boolean clustered, Function<Object, Object> kc, Function<Object, Object> kv) {
        EventImpl preEvent;
        if (kc == null) {
            kc = Function.identity();
        }
        if (kv == null) {
            kv = Function.identity();
        }
        if (clustered) {
            preEvent = null;
        } else {
            preEvent = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_CREATED);
            preEvent.setKey(kc.apply(entry.getKey()));
            preEvent.setPre(true);
            preEvent.setCurrentState(true);
        }
        EventImpl<Object, Object> postEvent = EventImpl.createEvent(this.cache.wired(), Event.Type.CACHE_ENTRY_CREATED);
        postEvent.setKey(kc.apply(entry.getKey()));
        postEvent.setValue(kv.apply(entry.getValue()));
        postEvent.setMetadata(entry.getMetadata());
        postEvent.setPre(false);
        postEvent.setCurrentState(true);
        for (CacheEntryListenerInvocation cacheEntryListenerInvocation : this.cacheEntryCreatedListeners) {
            if (cacheEntryListenerInvocation.getIdentifier() != identifier) continue;
            if (preEvent != null) {
                cacheEntryListenerInvocation.invokeNoChecks(new EventWrapper(null, preEvent), true, true, false);
            }
            cacheEntryListenerInvocation.invokeNoChecks(new EventWrapper(null, postEvent), true, true, false);
        }
    }

    @Override
    public void addListener(Object listener, KeyFilter<? super K> filter) {
        this.addListener(listener, filter, null);
    }

    @Override
    public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
        this.addListener(listener, filter, converter, null);
    }

    @Override
    public <C> void addFilteredListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.addFilteredListenerInternal(listener, null, null, filter, converter, filterAnnotations, false);
    }

    @Override
    public <C> void addStorageFormatFilteredListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.addFilteredListenerInternal(listener, null, null, filter, converter, filterAnnotations, false);
    }

    @Override
    public <C> void addListener(ListenerHolder listenerHolder, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, ClassLoader classLoader) {
        this.addListenerInternal(listenerHolder.getListener(), listenerHolder.getKeyDataConversion(), listenerHolder.getValueDataConversion(), filter, converter, classLoader, false);
    }

    @Override
    public <C> void addListener(ListenerHolder listenerHolder, KeyFilter<? super K> filter) {
        this.addListenerInternal(listenerHolder.getListener(), listenerHolder.getKeyDataConversion(), listenerHolder.getValueDataConversion(), new KeyFilterAsCacheEventFilter<K>(filter), null, null, listenerHolder.isFilterOnStorageFormat());
    }

    @Override
    public <C> void addFilteredListener(ListenerHolder listenerHolder, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations) {
        this.addFilteredListenerInternal(listenerHolder.getListener(), listenerHolder.getKeyDataConversion(), listenerHolder.getValueDataConversion(), filter, converter, filterAnnotations, listenerHolder.isFilterOnStorageFormat());
    }

    private <C> void addFilteredListenerInternal(Object listener, DataConversion keyDataConversion, DataConversion valueDataConversion, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter, Set<Class<? extends Annotation>> filterAnnotations, boolean useStorageFormat) {
        QueueingSegmentListener handler;
        CacheInvocationBuilder builder;
        DataConversion valueConversion;
        Listener l = CacheNotifierImpl.testListenerClassValidity(listener.getClass());
        UUID generatedId = UUID.randomUUID();
        CacheMode cacheMode = this.config.clustering().cacheMode();
        FilterIndexingServiceProvider indexingProvider = null;
        boolean foundMethods = false;
        DataConversion keyConversion = keyDataConversion == null ? DataConversion.IDENTITY_KEY : keyDataConversion;
        DataConversion dataConversion = valueConversion = valueDataConversion == null ? DataConversion.IDENTITY_VALUE : valueDataConversion;
        if (filter instanceof IndexedFilter && (indexingProvider = this.findIndexingServiceProvider((IndexedFilter)filter)) != null) {
            builder = new DelegatingCacheInvocationBuilder(indexingProvider);
            builder.setFilterAnnotations(filterAnnotations).setIncludeCurrentState(l.includeCurrentState()).setClustered(l.clustered()).setOnlyPrimary(l.clustered() ? cacheMode.isDistributed() : l.primaryOnly()).setObservation(l.clustered() ? Listener.Observation.POST : l.observation()).setFilter(filter).setConverter(converter).useStorageFormat(useStorageFormat).setKeyDataConversion(keyConversion).setValueDataConversion(valueConversion).setIdentifier(generatedId).setClassLoader(null);
            foundMethods = this.validateAndAddFilterListenerInvocations(listener, builder, filterAnnotations);
            ((DelegatingCacheInvocationBuilder)builder).registerListenerInvocations();
        }
        if (indexingProvider == null) {
            builder = new CacheInvocationBuilder();
            builder.setFilterAnnotations(filterAnnotations).setIncludeCurrentState(l.includeCurrentState()).setClustered(l.clustered()).setOnlyPrimary(l.clustered() ? cacheMode.isDistributed() : l.primaryOnly()).setObservation(l.clustered() ? Listener.Observation.POST : l.observation()).setFilter(filter).setKeyDataConversion(keyConversion).setValueDataConversion(valueConversion).setConverter(converter).useStorageFormat(useStorageFormat).setIdentifier(generatedId).setClassLoader(null);
            if (l.clustered()) {
                builder.setFilterAnnotations(this.findListenerCallbacks(listener));
            }
            foundMethods = this.validateAndAddFilterListenerInvocations(listener, builder, filterAnnotations);
        }
        if (foundMethods && l.clustered()) {
            if (l.observation() == Listener.Observation.PRE) {
                throw log.clusterListenerRegisteredWithOnlyPreEvents(listener.getClass());
            }
            if (cacheMode.isInvalidation()) {
                throw new UnsupportedOperationException("Cluster listeners cannot be used with Invalidation Caches!");
            }
            if (cacheMode.isDistributed()) {
                this.clusterListenerIDs.put(listener, generatedId);
                Address ourAddress = this.rpcManager.getAddress();
                List<Address> members = this.rpcManager.getMembers();
                if (members != null && members.size() > 1) {
                    DistributedExecutionCompletionService<Void> decs = new DistributedExecutionCompletionService<Void>(this.distExecutorService);
                    if (trace) {
                        log.tracef("Replicating cluster listener to other nodes %s for cluster listener with id %s", members, generatedId);
                    }
                    ClusterListenerReplicateCallable<? super K, ? super V> callable = new ClusterListenerReplicateCallable<K, V>(generatedId, ourAddress, filter, converter, l.sync(), filterAnnotations, keyDataConversion, valueDataConversion, useStorageFormat);
                    for (Address member : members) {
                        if (member.equals(ourAddress)) continue;
                        decs.submit(member, callable);
                    }
                    for (int i = 0; i < members.size() - 1; ++i) {
                        try {
                            ((CompletableFuture)decs.take()).get();
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new CacheListenerException((Throwable)e);
                        }
                        catch (ExecutionException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof SuspectException) continue;
                            throw new CacheListenerException(cause);
                        }
                    }
                    int extraCount = 0;
                    List<Address> membersAfter = this.rpcManager.getMembers();
                    for (Address member : membersAfter) {
                        if (members.contains(member) || member.equals(ourAddress)) continue;
                        if (trace) {
                            log.tracef("Found additional node %s that joined during replication of cluster listener with id %s", member, generatedId);
                        }
                        ++extraCount;
                        decs.submit(member, callable);
                    }
                    for (int i = 0; i < extraCount; ++i) {
                        try {
                            ((CompletableFuture)decs.take()).get();
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw new CacheListenerException((Throwable)e);
                        }
                        catch (ExecutionException e) {
                            Throwable cause = e.getCause();
                            if (cause instanceof SuspectException) continue;
                            throw new CacheListenerException((Throwable)e);
                        }
                    }
                }
            }
        }
        if ((handler = (QueueingSegmentListener)this.segmentHandler.remove(generatedId)) != null) {
            if (trace) {
                log.tracef("Listener %s requests initial state for cache", generatedId);
            }
            boolean hasFilter = false;
            MediaType storage = valueConversion.getStorageMediaType();
            MediaType keyReq = keyConversion.getRequestMediaType();
            MediaType valueReq = valueConversion.getRequestMediaType();
            AdvancedCache<Object, Object> iterationCache = this.cache.wired();
            if (keyReq != null && valueReq != null) {
                iterationCache = iterationCache.withMediaType(keyReq.toString(), valueReq.toString());
            }
            MediaType filterMediaType = null;
            if (filter != null) {
                hasFilter = true;
                filterMediaType = useStorageFormat ? null : filter.format();
                iterationCache = filterMediaType == null ? iterationCache.withMediaType(storage.toString(), storage.toString()) : iterationCache.withMediaType(filterMediaType.toString(), filterMediaType.toString());
            }
            if (converter != null) {
                hasFilter = true;
                filterMediaType = useStorageFormat ? null : converter.format();
                iterationCache = filterMediaType == null ? iterationCache.withEncoding(IdentityEncoder.class).withMediaType(storage.toString(), storage.toString()) : iterationCache.withEncoding(IdentityEncoder.class).withMediaType(filterMediaType.toString(), filterMediaType.toString());
            }
            try (Stream entryStream = iterationCache.cacheEntrySet().stream();){
                BaseStream usedStream = entryStream.segmentCompletionListener(handler);
                if (filter instanceof CacheEventFilterConverter && (filter == converter || converter == null)) {
                    usedStream = CacheFilters.filterAndConvert(usedStream, new CacheEventFilterConverterAsKeyValueFilterConverter((CacheEventFilterConverter)filter));
                } else {
                    usedStream = filter == null ? usedStream : usedStream.filter(CacheFilters.predicate(new CacheEventFilterAsKeyValueFilter<K, V>(filter)));
                    usedStream = converter == null ? usedStream : usedStream.map(CacheFilters.function(new CacheEventConverterAsConverter<K, V, C>(converter)));
                }
                Iterator iterator = usedStream.iterator();
                while (iterator.hasNext()) {
                    CacheEntry entry = (CacheEntry)iterator.next();
                    Object value = handler.markKeyAsProcessing(entry.getKey());
                    if (value == BaseQueueingSegmentListener.REMOVED) continue;
                    MediaType finalFilterMediaType = filterMediaType;
                    boolean finalHasFilter = hasFilter;
                    Function<Object, Object> kc = k -> {
                        if (!finalHasFilter) {
                            return k;
                        }
                        if (finalFilterMediaType == null || useStorageFormat || keyReq == null) {
                            return keyDataConversion.fromStorage(k);
                        }
                        return keyDataConversion.convert(k, finalFilterMediaType, keyDataConversion.getRequestMediaType());
                    };
                    Function<Object, Object> kv = v -> {
                        if (!finalHasFilter) {
                            return v;
                        }
                        if (finalFilterMediaType == null || useStorageFormat || valueReq == null) {
                            return valueConversion.fromStorage(v);
                        }
                        return valueConversion.convert(v, finalFilterMediaType, valueConversion.getRequestMediaType());
                    };
                    this.raiseEventForInitialTransfer(generatedId, entry, l.clustered(), kc, kv);
                    handler.notifiedKey(entry.getKey());
                }
            }
            Set entries = handler.findCreatedEntries();
            for (CacheEntry entry : entries) {
                this.raiseEventForInitialTransfer(generatedId, entry, l.clustered(), null, null);
            }
            handler.transferComplete();
            if (trace) {
                log.tracef("Listener %s initial state for cache completed", generatedId);
            }
        }
    }

    @Override
    public void removeListener(Object listener) {
        super.removeListener(listener);
        UUID id = this.clusterListenerIDs.remove(listener);
        if (id != null) {
            List<CompletableFuture<Void>> futures = this.distExecutorService.submitEverywhere(new ClusterListenerRemoveCallable(id));
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException e) {
                    throw new CacheListenerException((Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new CacheListenerException((Throwable)e);
                }
            }
        }
    }

    @Override
    protected Set<CacheEntryListenerInvocation<K, V>> removeListenerInvocation(Class<? extends Annotation> annotation, Object listener) {
        Set<CacheEntryListenerInvocation<K, V>> markedForRemoval = super.removeListenerInvocation(annotation, listener);
        for (CacheEntryListenerInvocation cacheEntryListenerInvocation : markedForRemoval) {
            if (!(cacheEntryListenerInvocation instanceof DelegatingCacheEntryListenerInvocation)) continue;
            ((DelegatingCacheEntryListenerInvocation)cacheEntryListenerInvocation).unregister();
        }
        return markedForRemoval;
    }

    static {
        allowedListeners.put(CacheEntryCreated.class, CacheEntryCreatedEvent.class);
        allowedListeners.put(CacheEntryRemoved.class, CacheEntryRemovedEvent.class);
        allowedListeners.put(CacheEntryVisited.class, CacheEntryVisitedEvent.class);
        allowedListeners.put(CacheEntryModified.class, CacheEntryModifiedEvent.class);
        allowedListeners.put(CacheEntryActivated.class, CacheEntryActivatedEvent.class);
        allowedListeners.put(CacheEntryPassivated.class, CacheEntryPassivatedEvent.class);
        allowedListeners.put(CacheEntryLoaded.class, CacheEntryLoadedEvent.class);
        allowedListeners.put(CacheEntriesEvicted.class, CacheEntriesEvictedEvent.class);
        allowedListeners.put(TransactionRegistered.class, TransactionRegisteredEvent.class);
        allowedListeners.put(TransactionCompleted.class, TransactionCompletedEvent.class);
        allowedListeners.put(CacheEntryInvalidated.class, CacheEntryInvalidatedEvent.class);
        allowedListeners.put(CacheEntryExpired.class, CacheEntryExpiredEvent.class);
        allowedListeners.put(DataRehashed.class, DataRehashedEvent.class);
        allowedListeners.put(TopologyChanged.class, TopologyChangedEvent.class);
        allowedListeners.put(PartitionStatusChanged.class, PartitionStatusChangedEvent.class);
        allowedListeners.put(PersistenceAvailabilityChanged.class, PersistenceAvailabilityChangedEvent.class);
        clusterAllowedListeners.put(CacheEntryCreated.class, CacheEntryCreatedEvent.class);
        clusterAllowedListeners.put(CacheEntryModified.class, CacheEntryModifiedEvent.class);
        clusterAllowedListeners.put(CacheEntryRemoved.class, CacheEntryRemovedEvent.class);
        clusterAllowedListeners.put(CacheEntryExpired.class, CacheEntryExpiredEvent.class);
    }

    protected static class BaseCacheEntryListenerInvocation<K, V>
    implements CacheEntryListenerInvocation<K, V> {
        protected final ListenerInvocation<Event<K, V>> invocation;
        protected final CacheEventFilter<? super K, ? super V> filter;
        protected final CacheEventConverter<? super K, ? super V, ?> converter;
        private final DataConversion keyDataConversion;
        private final DataConversion valueDataConversion;
        private final boolean useStorageFormat;
        protected final boolean onlyPrimary;
        protected final boolean clustered;
        protected final UUID identifier;
        protected final Class<? extends Annotation> annotation;
        protected final boolean sync;
        protected final boolean filterAndConvert;
        protected final Listener.Observation observation;
        protected final Set<Class<? extends Annotation>> filterAnnotations;

        protected BaseCacheEntryListenerInvocation(ListenerInvocation<Event<K, V>> invocation, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, ?> converter, Class<? extends Annotation> annotation, boolean onlyPrimary, boolean clustered, UUID identifier, boolean sync, Listener.Observation observation, Set<Class<? extends Annotation>> filterAnnotations, DataConversion keyDataConversion, DataConversion valueDataConversion, boolean useStorageFormat) {
            this.invocation = invocation;
            this.filter = filter;
            this.converter = converter;
            this.keyDataConversion = keyDataConversion;
            this.valueDataConversion = valueDataConversion;
            this.useStorageFormat = useStorageFormat;
            this.filterAndConvert = filter instanceof CacheEventFilterConverter && (filter == converter || converter == null);
            this.onlyPrimary = onlyPrimary;
            this.clustered = clustered;
            this.identifier = identifier;
            this.annotation = annotation;
            this.sync = sync;
            this.observation = observation;
            this.filterAnnotations = filterAnnotations;
        }

        @Override
        public void invoke(Event<K, V> event) {
            if (this.shouldInvoke(event)) {
                this.doRealInvocation(event);
            }
        }

        @Override
        public void invoke(EventWrapper<K, V, CacheEntryEvent<K, V>> wrapped, boolean isLocalNodePrimaryOwner) {
            CacheEntryEvent<K, V> resultingEvent = this.shouldInvoke(wrapped.getEvent(), isLocalNodePrimaryOwner);
            if (resultingEvent != null) {
                wrapped.setEvent(resultingEvent);
                this.invokeNoChecks(wrapped, false, this.filterAndConvert, false);
            }
        }

        @Override
        public void invokeNoChecks(EventWrapper<K, V, CacheEntryEvent<K, V>> wrapped, boolean skipQueue, boolean skipConverter, boolean needsTransform) {
            if (!skipConverter) {
                wrapped.setEvent(this.convertValue(this.converter, wrapped.getEvent()));
            }
            if (needsTransform) {
                CacheEntryEvent<K, V> event = wrapped.getEvent();
                EventImpl eventImpl = (EventImpl)event;
                wrapped.setEvent(this.convertEventToRequestFormat(eventImpl, this.filter, this.converter, eventImpl.getValue()));
            }
            if (skipQueue) {
                this.invocation.invoke(wrapped.getEvent());
            } else {
                this.doRealInvocation(wrapped);
            }
        }

        protected void doRealInvocation(EventWrapper<K, V, CacheEntryEvent<K, V>> event) {
            this.doRealInvocation(event.getEvent());
        }

        protected void doRealInvocation(Event<K, V> event) {
            this.invocation.invoke(event);
        }

        protected boolean shouldInvoke(Event<K, V> event) {
            return this.observation.shouldInvoke(event.isPre());
        }

        protected CacheEntryEvent<K, V> shouldInvoke(CacheEntryEvent<K, V> event, boolean isLocalNodePrimaryOwner) {
            if (trace) {
                log.tracef("Should invoke %s (filter %s)? (onlyPrimary=%s, isPrimary=%s)", new Object[]{event, this.filter, this.onlyPrimary, isLocalNodePrimaryOwner});
            }
            if (this.onlyPrimary && !isLocalNodePrimaryOwner) {
                return null;
            }
            if (event instanceof EventImpl) {
                EventType eventType;
                EventImpl eventImpl = (EventImpl)event;
                if (!this.shouldInvoke(event)) {
                    return null;
                }
                if (this.filter != null && (eventType = this.getEvent(eventImpl)) != null) {
                    if (this.filterAndConvert) {
                        Object newValue = ((CacheEventFilterConverter)this.filter).filterAndConvert(eventImpl.getKey(), eventImpl.getOldValue(), eventImpl.getOldMetadata(), eventImpl.getValue(), eventImpl.getMetadata(), eventType);
                        return newValue != null ? this.convertEventToRequestFormat(eventImpl, this.filter, null, newValue) : null;
                    }
                    boolean accept = this.filter.accept(eventImpl.getKey(), eventImpl.getOldValue(), eventImpl.getOldMetadata(), eventImpl.getValue(), eventImpl.getMetadata(), eventType);
                    if (!accept) {
                        return null;
                    }
                    if (this.converter == null) {
                        return this.convertEventToRequestFormat(eventImpl, this.filter, null, eventImpl.getValue());
                    }
                }
            }
            return event;
        }

        private EventType getEvent(EventImpl<K, V> event) {
            switch (event.getType()) {
                case CACHE_ENTRY_MODIFIED: 
                case CACHE_ENTRY_CREATED: 
                case CACHE_ENTRY_REMOVED: 
                case CACHE_ENTRY_EXPIRED: 
                case CACHE_ENTRY_ACTIVATED: 
                case CACHE_ENTRY_INVALIDATED: 
                case CACHE_ENTRY_LOADED: 
                case CACHE_ENTRY_PASSIVATED: 
                case CACHE_ENTRY_VISITED: {
                    return new EventType(event.isCommandRetried(), event.isPre(), event.getType());
                }
            }
            return null;
        }

        @Override
        public Object getTarget() {
            return this.invocation.getTarget();
        }

        @Override
        public CacheEventFilter<? super K, ? super V> getFilter() {
            return this.filter;
        }

        @Override
        public Set<Class<? extends Annotation>> getFilterAnnotations() {
            return this.filterAnnotations;
        }

        @Override
        public DataConversion getKeyDataConversion() {
            return this.keyDataConversion;
        }

        @Override
        public DataConversion getValueDataConversion() {
            return this.valueDataConversion;
        }

        @Override
        public boolean useStorageFormat() {
            return this.useStorageFormat;
        }

        @Override
        public CacheEventConverter<? super K, ? super V, ?> getConverter() {
            return this.converter;
        }

        @Override
        public boolean isClustered() {
            return this.clustered;
        }

        @Override
        public UUID getIdentifier() {
            return this.identifier;
        }

        @Override
        public Listener.Observation getObservation() {
            return this.observation;
        }

        @Override
        public Class<? extends Annotation> getAnnotation() {
            return this.annotation;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected CacheEntryEvent<K, V> convertValue(CacheEventConverter<? super K, ? super V, ?> converter, CacheEntryEvent<K, V> event) {
            Object newValue;
            if (converter == null) return event;
            if (!(event instanceof EventImpl)) throw new IllegalArgumentException("Provided event should be org.infinispan.notifications.cachelistener.event.impl.EventImpl when a converter is being used!");
            EventImpl eventImpl = (EventImpl)event;
            EventType evType = new EventType(eventImpl.isCommandRetried(), eventImpl.isPre(), eventImpl.getType());
            if (converter.useRequestFormat()) {
                eventImpl = this.convertEventToRequestFormat(eventImpl, null, converter, eventImpl.getValue());
                newValue = converter.convert(eventImpl.getKey(), eventImpl.getOldValue(), eventImpl.getOldMetadata(), eventImpl.getValue(), eventImpl.getMetadata(), evType);
                eventImpl.setValue(newValue);
            } else {
                newValue = converter.convert(eventImpl.getKey(), eventImpl.getOldValue(), eventImpl.getOldMetadata(), eventImpl.getValue(), eventImpl.getMetadata(), evType);
            }
            if (converter.useRequestFormat()) return eventImpl;
            return this.convertEventToRequestFormat(eventImpl, null, converter, newValue);
        }

        private EventImpl<K, V> convertEventToRequestFormat(EventImpl<K, V> eventImpl, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, ?> converter, Object newValue) {
            MediaType keyFromFormat = this.keyDataConversion.getStorageMediaType();
            MediaType valueFromFormat = this.valueDataConversion.getStorageMediaType();
            if (converter != null) {
                if (converter.format() != null && !this.useStorageFormat) {
                    keyFromFormat = converter.format();
                    valueFromFormat = converter.format();
                }
            } else if (filter != null && filter.format() != null && !this.useStorageFormat) {
                keyFromFormat = filter.format();
                valueFromFormat = filter.format();
            }
            Object convertedKey = this.keyDataConversion.convertToRequestFormat(eventImpl.getKey(), keyFromFormat);
            Object convertedValue = this.valueDataConversion.convertToRequestFormat(newValue, valueFromFormat);
            Object convertedOlfValue = this.valueDataConversion.convertToRequestFormat(eventImpl.getOldValue(), valueFromFormat);
            Object clone = eventImpl.clone();
            ((EventImpl)clone).setKey(convertedKey);
            ((EventImpl)clone).setValue(convertedValue);
            ((EventImpl)clone).setOldValue(convertedOlfValue);
            return clone;
        }

        @Override
        public boolean isSync() {
            return this.sync;
        }
    }

    protected static class ClusteredListenerInvocation<K, V>
    extends BaseCacheEntryListenerInvocation<K, V> {
        private final QueueingSegmentListener<K, V, CacheEntryEvent<K, V>> handler;

        public ClusteredListenerInvocation(ListenerInvocation<Event<K, V>> invocation, QueueingSegmentListener<K, V, CacheEntryEvent<K, V>> handler, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, ?> converter, Class<? extends Annotation> annotation, boolean onlyPrimary, UUID identifier, boolean sync, Listener.Observation observation, Set<Class<? extends Annotation>> filterAnnotations, DataConversion keyDataConversion, DataConversion valueDataConversion, boolean useStorageFormat) {
            super(invocation, filter, converter, annotation, onlyPrimary, true, identifier, sync, observation, filterAnnotations, keyDataConversion, valueDataConversion, useStorageFormat);
            this.handler = handler;
        }

        @Override
        public void invoke(Event<K, V> event) {
            throw new UnsupportedOperationException("Clustered initial transfer don't support regular events!");
        }

        @Override
        protected void doRealInvocation(EventWrapper<K, V, CacheEntryEvent<K, V>> wrapped) {
            if (!this.handler.handleEvent(wrapped, this.invocation)) {
                super.doRealInvocation(wrapped.getEvent());
            }
        }
    }

    protected class DelegatingCacheInvocationBuilder
    extends CacheInvocationBuilder {
        private final FilterIndexingServiceProvider provider;
        private final Map<Class<? extends Annotation>, List<DelegatingCacheEntryListenerInvocation<K, V>>> listeners;

        DelegatingCacheInvocationBuilder(FilterIndexingServiceProvider provider) {
            this.listeners = new HashMap(3);
            this.provider = provider;
        }

        @Override
        public DelegatingCacheEntryListenerInvocation<K, V> build() {
            DelegatingCacheEntryListenerInvocation invocation = this.provider.interceptListenerInvocation(super.build());
            List invocations = this.listeners.get(invocation.getAnnotation());
            if (invocations == null) {
                invocations = new ArrayList(2);
                this.listeners.put(invocation.getAnnotation(), invocations);
            }
            invocations.add(invocation);
            return invocation;
        }

        void registerListenerInvocations() {
            if (!this.listeners.isEmpty()) {
                boolean filterAndConvert = this.filter == this.converter || this.converter == null;
                this.provider.registerListenerInvocations(this.clustered, this.onlyPrimary, filterAndConvert, (IndexedFilter)this.filter, this.listeners, this.keyDataConversion, this.valueDataConversion);
            }
        }
    }

    protected class CacheInvocationBuilder
    extends AbstractListenerImpl.AbstractInvocationBuilder {
        CacheEventFilter<? super K, ? super V> filter;
        CacheEventConverter<? super K, ? super V, ?> converter;
        boolean onlyPrimary;
        boolean clustered;
        boolean includeCurrentState;
        UUID identifier;
        DataConversion keyDataConversion;
        DataConversion valueDataConversion;
        Listener.Observation observation;
        Set<Class<? extends Annotation>> filterAnnotations;
        boolean storageFormat;

        protected CacheInvocationBuilder() {
            super(CacheNotifierImpl.this);
        }

        public CacheEventFilter<? super K, ? super V> getFilter() {
            return this.filter;
        }

        public CacheInvocationBuilder setFilter(CacheEventFilter<? super K, ? super V> filter) {
            this.filter = filter;
            return this;
        }

        public CacheEventConverter<? super K, ? super V, ?> getConverter() {
            return this.converter;
        }

        public CacheInvocationBuilder setConverter(CacheEventConverter<? super K, ? super V, ?> converter) {
            this.converter = converter;
            return this;
        }

        public CacheInvocationBuilder useStorageFormat(boolean useStorageFormat) {
            this.storageFormat = useStorageFormat;
            return this;
        }

        public boolean isOnlyPrimary() {
            return this.onlyPrimary;
        }

        public CacheInvocationBuilder setOnlyPrimary(boolean onlyPrimary) {
            this.onlyPrimary = onlyPrimary;
            return this;
        }

        public boolean isClustered() {
            return this.clustered;
        }

        public CacheInvocationBuilder setClustered(boolean clustered) {
            this.clustered = clustered;
            return this;
        }

        public UUID getIdentifier() {
            return this.identifier;
        }

        public CacheInvocationBuilder setIdentifier(UUID identifier) {
            this.identifier = identifier;
            return this;
        }

        public CacheInvocationBuilder setKeyDataConversion(DataConversion dataConversion) {
            this.keyDataConversion = dataConversion;
            return this;
        }

        public CacheInvocationBuilder setValueDataConversion(DataConversion dataConversion) {
            this.valueDataConversion = dataConversion;
            return this;
        }

        public boolean isIncludeCurrentState() {
            return this.includeCurrentState;
        }

        public CacheInvocationBuilder setIncludeCurrentState(boolean includeCurrentState) {
            this.includeCurrentState = includeCurrentState;
            return this;
        }

        public Listener.Observation getObservation() {
            return this.observation;
        }

        public CacheInvocationBuilder setObservation(Listener.Observation observation) {
            this.observation = observation;
            return this;
        }

        public CacheInvocationBuilder setFilterAnnotations(Set<Class<? extends Annotation>> filterAnnotations) {
            this.filterAnnotations = filterAnnotations;
            return this;
        }

        public CacheEntryListenerInvocation<K, V> build() {
            BaseCacheEntryListenerInvocation returnValue;
            AbstractListenerImpl.ListenerInvocationImpl invocation = new AbstractListenerImpl.ListenerInvocationImpl(CacheNotifierImpl.this, this.target, this.method, this.sync, this.classLoader, this.subject);
            this.wireDependencies(this.filter, this.converter);
            if (this.includeCurrentState) {
                if (this.clustered) {
                    QueueingSegmentListener handler = (QueueingAllSegmentListener)CacheNotifierImpl.this.segmentHandler.get(this.identifier);
                    if (handler == null) {
                        if (CacheNotifierImpl.this.config.clustering().cacheMode().isDistributed()) {
                            LocalizedCacheTopology cacheTopology = ((ClusteringDependentLogic)CacheNotifierImpl.this.clusteringDependentLogic.running()).getCacheTopology();
                            handler = new DistributedQueueingSegmentListener(CacheNotifierImpl.this.entryFactory, cacheTopology.getCurrentCH().getNumSegments(), cacheTopology::getSegment);
                        } else {
                            handler = new QueueingAllSegmentListener(CacheNotifierImpl.this.entryFactory);
                        }
                        QueueingSegmentListener currentQueue = CacheNotifierImpl.this.segmentHandler.putIfAbsent(this.identifier, handler);
                        if (currentQueue != null) {
                            handler = currentQueue;
                        }
                    }
                    returnValue = new ClusteredListenerInvocation(invocation, handler, this.filter, this.converter, this.annotation, this.onlyPrimary, this.identifier, this.sync, this.observation, this.filterAnnotations, this.keyDataConversion, this.valueDataConversion, this.storageFormat);
                } else {
                    returnValue = new BaseCacheEntryListenerInvocation(invocation, this.filter, this.converter, this.annotation, this.onlyPrimary, this.clustered, this.identifier, this.sync, this.observation, this.filterAnnotations, this.keyDataConversion, this.valueDataConversion, this.storageFormat);
                }
            } else {
                returnValue = new BaseCacheEntryListenerInvocation(invocation, this.filter, this.converter, this.annotation, this.onlyPrimary, this.clustered, this.identifier, this.sync, this.observation, this.filterAnnotations, this.keyDataConversion, this.valueDataConversion, this.storageFormat);
            }
            return returnValue;
        }

        protected <C> void wireDependencies(CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
            if (filter != null) {
                CacheNotifierImpl.this.componentRegistry.wireDependencies(filter, false);
            }
            if (converter != null && converter != filter) {
                CacheNotifierImpl.this.componentRegistry.wireDependencies(converter, false);
            }
            if (this.keyDataConversion != null) {
                CacheNotifierImpl.this.componentRegistry.wireDependencies(this.keyDataConversion, false);
            }
            if (this.valueDataConversion != null) {
                CacheNotifierImpl.this.componentRegistry.wireDependencies(this.valueDataConversion, false);
            }
        }
    }
}

