/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.mechanism.scram;

import org.wildfly.security.mechanism.scram.ScramInitialClientMessage;
import org.wildfly.security.mechanism.scram.ScramMechanism;

public final class ScramInitialServerMessage {
    private final ScramInitialClientMessage initialResponse;
    private final byte[] serverNonce;
    private final byte[] salt;
    private final int iterationCount;
    private final byte[] messageBytes;

    ScramInitialServerMessage(ScramInitialClientMessage initialResponse, byte[] serverNonce, byte[] salt, int iterationCount, byte[] messageBytes) {
        this.initialResponse = initialResponse;
        this.serverNonce = serverNonce;
        this.salt = salt;
        this.iterationCount = iterationCount;
        this.messageBytes = messageBytes;
    }

    public ScramMechanism getMechanism() {
        return this.initialResponse.getMechanism();
    }

    public ScramInitialClientMessage getInitialResponse() {
        return this.initialResponse;
    }

    public byte[] getServerNonce() {
        return (byte[])this.serverNonce.clone();
    }

    byte[] getRawServerNonce() {
        return this.serverNonce;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    byte[] getRawSalt() {
        return this.salt;
    }

    byte[] getRawMessageBytes() {
        return this.messageBytes;
    }

    public byte[] getSalt() {
        return (byte[])this.salt.clone();
    }

    public byte[] getMessageBytes() {
        return (byte[])this.messageBytes.clone();
    }
}

