/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.uri.AbstractCFSchema;
import org.apache.activemq.artemis.uri.JMSConnectionOptions;
import org.apache.activemq.artemis.uri.schema.connector.TCPTransportConfigurationSchema;
import org.apache.activemq.artemis.uri.schema.serverLocator.TCPServerLocatorSchema;
import org.apache.activemq.artemis.utils.uri.BeanSupport;

public class TCPSchema
extends AbstractCFSchema {
    public String getSchemaName() {
        return "tcp";
    }

    protected ActiveMQConnectionFactory internalNewObject(URI uri, Map<String, String> query, String name) throws Exception {
        JMSConnectionOptions options = this.newConectionOptions(uri, query);
        List configurations = TCPTransportConfigurationSchema.getTransportConfigurations((URI)uri, query, (Set)TransportConstants.ALLOWABLE_CONNECTOR_KEYS, (String)name, (String)NettyConnectorFactory.class.getName());
        TransportConfiguration[] tcs = new TransportConfiguration[configurations.size()];
        configurations.toArray(tcs);
        ActiveMQConnectionFactory factory = options.isHa() ? ActiveMQJMSClient.createConnectionFactoryWithHA(options.getFactoryTypeEnum(), tcs) : ActiveMQJMSClient.createConnectionFactoryWithoutHA(options.getFactoryTypeEnum(), tcs);
        return this.setData(uri, query, factory);
    }

    protected URI internalNewURI(ActiveMQConnectionFactory bean) throws Exception {
        String query = BeanSupport.getData(null, (Object[])new Object[]{bean});
        TransportConfiguration[] staticConnectors = bean.getStaticConnectors();
        return TCPServerLocatorSchema.getURI((String)query, (TransportConfiguration[])staticConnectors);
    }
}

