/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.logging;

import java.util.List;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="WFLYRS", length=4)
public interface JaxrsLogger
extends BasicLogger {
    public static final JaxrsLogger JAXRS_LOGGER = (JaxrsLogger)Logger.getMessageLogger(JaxrsLogger.class, (String)"org.jboss.as.jaxrs");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="%s annotation not on Class: %s")
    public void classAnnotationNotFound(String var1, AnnotationTarget var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=2, value="%s annotation not on Class or Method: %s")
    public void classOrMethodAnnotationNotFound(String var1, AnnotationTarget var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="More than one mapping found for JAX-RS servlet: %s the second mapping %s will not work")
    public void moreThanOneServletMapping(String var1, String var2);

    @Message(id=6, value="Could not load JAX-RS Application class")
    public DeploymentUnitProcessingException cannotLoadApplicationClass(@Cause Throwable var1);

    @Message(id=10, value="JAX-RS resource %s does not correspond to a view on the EJB %s. @Path annotations can only be placed on classes or interfaces that represent a local, remote or no-interface view of an EJB.")
    public DeploymentUnitProcessingException typeNameNotAnEjbView(List<Class<?>> var1, String var2);

    @Message(id=11, value="Invalid value for parameter %s: %s")
    public DeploymentUnitProcessingException invalidParamValue(String var1, String var2);

    @Message(id=12, value="No spring integration jar found")
    public DeploymentUnitProcessingException noSpringIntegrationJar();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="The context param org.jboss.as.jaxrs.disableSpringIntegration is deprecated, and will be removed in a future release. Please use org.jboss.as.jaxrs.enableSpringIntegration instead")
    public void disablePropertyDeprecated();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=14, value="Failed to register management view for REST resource class: %s")
    public void failedToRegisterManagementViewForRESTResources(String var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15, value="No Servlet declaration found for JAX-RS application.  In %s either provide a class that extends javax.ws.rs.core.Application or declare a servlet class in web.xml.")
    public void noServletDeclaration(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16, value="RESTEasy version %s")
    public void resteasyVersion(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17, value="Failed to read attribute from JAX-RS deployment at %s with name %s")
    public void failedToReadAttribute(@Cause Exception var1, PathAddress var2, ModelNode var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18, value="Explicit usage of Jackson annotation in a JAX-RS deployment; the system will disable JSON-B processing for the current deployment. Consider setting the '%s' property to 'false' to restore JSON-B.")
    public void jacksonAnnotationDetected(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=19, value="Error converting default value %s for parameter %s in method %s using param converter %s. Exception: %s : %s")
    public void paramConverterFailed(String var1, String var2, String var3, String var4, String var5, String var6);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20, value="\"Error converting default value %s for parameter %s in method %s using method %s. Exception: %s : %s\"")
    public void baseTypeMethodFailed(String var1, String var2, String var3, String var4, String var5, String var6);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=21, value="%s %s")
    public void classIntrospectionFailure(String var1, String var2);

    @Message(id=22, value="\"Parameter %s is not a list\"")
    public OperationFailedException parameterNotList(String var1);

    @Message(id=23, value="Illegal value for parameter %s: %s")
    public String illegalArgument(String var1, String var2);
}

