/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.ra;

import java.util.Arrays;
import java.util.Enumeration;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.activemq.artemis.ra.ActiveMQRALogger;
import org.apache.activemq.artemis.ra.ActiveMQRASession;

public class ActiveMQRAMessage
implements Message {
    protected Message message;
    protected ActiveMQRASession session;

    public ActiveMQRAMessage(Message message, ActiveMQRASession session) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("constructor(" + message + ", " + session + ")");
        }
        this.message = message;
        this.session = session;
    }

    public void acknowledge() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("acknowledge()");
        }
        this.session.getSession();
        this.message.acknowledge();
    }

    public void clearBody() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("clearBody()");
        }
        this.message.clearBody();
    }

    public void clearProperties() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("clearProperties()");
        }
        this.message.clearProperties();
    }

    public boolean getBooleanProperty(String name) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getBooleanProperty(" + name + ")");
        }
        return this.message.getBooleanProperty(name);
    }

    public byte getByteProperty(String name) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getByteProperty(" + name + ")");
        }
        return this.message.getByteProperty(name);
    }

    public double getDoubleProperty(String name) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getDoubleProperty(" + name + ")");
        }
        return this.message.getDoubleProperty(name);
    }

    public float getFloatProperty(String name) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getFloatProperty(" + name + ")");
        }
        return this.message.getFloatProperty(name);
    }

    public int getIntProperty(String name) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getIntProperty(" + name + ")");
        }
        return this.message.getIntProperty(name);
    }

    public String getJMSCorrelationID() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSCorrelationID()");
        }
        return this.message.getJMSCorrelationID();
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSCorrelationIDAsBytes()");
        }
        return this.message.getJMSCorrelationIDAsBytes();
    }

    public int getJMSDeliveryMode() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSDeliveryMode()");
        }
        return this.message.getJMSDeliveryMode();
    }

    public Destination getJMSDestination() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSDestination()");
        }
        return this.message.getJMSDestination();
    }

    public long getJMSExpiration() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSExpiration()");
        }
        return this.message.getJMSExpiration();
    }

    public String getJMSMessageID() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSMessageID()");
        }
        return this.message.getJMSMessageID();
    }

    public int getJMSPriority() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSPriority()");
        }
        return this.message.getJMSPriority();
    }

    public boolean getJMSRedelivered() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSRedelivered()");
        }
        return this.message.getJMSRedelivered();
    }

    public Destination getJMSReplyTo() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSReplyTo()");
        }
        return this.message.getJMSReplyTo();
    }

    public long getJMSTimestamp() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSTimestamp()");
        }
        return this.message.getJMSTimestamp();
    }

    public String getJMSType() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSType()");
        }
        return this.message.getJMSType();
    }

    public long getLongProperty(String name) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getLongProperty(" + name + ")");
        }
        return this.message.getLongProperty(name);
    }

    public Object getObjectProperty(String name) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getObjectProperty(" + name + ")");
        }
        return this.message.getObjectProperty(name);
    }

    public Enumeration getPropertyNames() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getPropertyNames()");
        }
        return this.message.getPropertyNames();
    }

    public short getShortProperty(String name) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getShortProperty(" + name + ")");
        }
        return this.message.getShortProperty(name);
    }

    public String getStringProperty(String name) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getStringProperty(" + name + ")");
        }
        return this.message.getStringProperty(name);
    }

    public boolean propertyExists(String name) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("propertyExists(" + name + ")");
        }
        return this.message.propertyExists(name);
    }

    public void setBooleanProperty(String name, boolean value) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setBooleanProperty(" + name + ", " + value + ")");
        }
        this.message.setBooleanProperty(name, value);
    }

    public void setByteProperty(String name, byte value) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setByteProperty(" + name + ", " + value + ")");
        }
        this.message.setByteProperty(name, value);
    }

    public void setDoubleProperty(String name, double value) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setDoubleProperty(" + name + ", " + value + ")");
        }
        this.message.setDoubleProperty(name, value);
    }

    public void setFloatProperty(String name, float value) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setFloatProperty(" + name + ", " + value + ")");
        }
        this.message.setFloatProperty(name, value);
    }

    public void setIntProperty(String name, int value) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setIntProperty(" + name + ", " + value + ")");
        }
        this.message.setIntProperty(name, value);
    }

    public void setJMSCorrelationID(String correlationID) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setJMSCorrelationID(" + correlationID + ")");
        }
        this.message.setJMSCorrelationID(correlationID);
    }

    public void setJMSCorrelationIDAsBytes(byte[] correlationID) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setJMSCorrelationIDAsBytes(" + Arrays.toString(correlationID) + ")");
        }
        this.message.setJMSCorrelationIDAsBytes(correlationID);
    }

    public void setJMSDeliveryMode(int deliveryMode) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setJMSDeliveryMode(" + deliveryMode + ")");
        }
        this.message.setJMSDeliveryMode(deliveryMode);
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setJMSDestination(" + destination + ")");
        }
        this.message.setJMSDestination(destination);
    }

    public void setJMSExpiration(long expiration) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setJMSExpiration(" + expiration + ")");
        }
        this.message.setJMSExpiration(expiration);
    }

    public void setJMSMessageID(String id) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setJMSMessageID(" + id + ")");
        }
        this.message.setJMSMessageID(id);
    }

    public void setJMSPriority(int priority) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setJMSPriority(" + priority + ")");
        }
        this.message.setJMSPriority(priority);
    }

    public void setJMSRedelivered(boolean redelivered) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setJMSRedelivered(" + redelivered + ")");
        }
        this.message.setJMSRedelivered(redelivered);
    }

    public void setJMSReplyTo(Destination replyTo) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setJMSReplyTo(" + replyTo + ")");
        }
        this.message.setJMSReplyTo(replyTo);
    }

    public void setJMSTimestamp(long timestamp) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setJMSTimestamp(" + timestamp + ")");
        }
        this.message.setJMSTimestamp(timestamp);
    }

    public void setJMSType(String type) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setJMSType(" + type + ")");
        }
        this.message.setJMSType(type);
    }

    public void setLongProperty(String name, long value) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setLongProperty(" + name + ", " + value + ")");
        }
        this.message.setLongProperty(name, value);
    }

    public void setObjectProperty(String name, Object value) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setObjectProperty(" + name + ", " + value + ")");
        }
        this.message.setObjectProperty(name, value);
    }

    public void setShortProperty(String name, short value) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setShortProperty(" + name + ", " + value + ")");
        }
        this.message.setShortProperty(name, value);
    }

    public void setStringProperty(String name, String value) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setStringProperty(" + name + ", " + value + ")");
        }
        this.message.setStringProperty(name, value);
    }

    public long getJMSDeliveryTime() throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getJMSDeliveryTime()");
        }
        return this.message.getJMSDeliveryTime();
    }

    public void setJMSDeliveryTime(long deliveryTime) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("setJMSDeliveryTime(" + deliveryTime + ")");
        }
        this.message.setJMSDeliveryTime(deliveryTime);
    }

    public <T> T getBody(Class<T> c) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("getBody(" + c + ")");
        }
        return (T)this.message.getBody(c);
    }

    public boolean isBodyAssignableTo(Class c) throws JMSException {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("isBodyAssignableTo(" + c + ")");
        }
        return this.message.isBodyAssignableTo(c);
    }

    public int hashCode() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("hashCode()");
        }
        return this.message.hashCode();
    }

    public boolean equals(Object object) {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("equals(" + object + ")");
        }
        if (object != null && object instanceof ActiveMQRAMessage) {
            return this.message.equals(((ActiveMQRAMessage)object).message);
        }
        return this.message.equals(object);
    }

    public String toString() {
        if (ActiveMQRALogger.LOGGER.isTraceEnabled()) {
            ActiveMQRALogger.LOGGER.trace("toString()");
        }
        return this.message.toString();
    }
}

