/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.jdbc.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.jdbc.internal.model.AbstractJdbcType;
import org.picketlink.idm.jdbc.internal.model.db.AttributeStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.GroupStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.RelationshipStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.RoleStorageUtil;
import org.picketlink.idm.jdbc.internal.model.db.UserStorageUtil;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.basic.Agent;
import org.picketlink.idm.model.basic.Grant;
import org.picketlink.idm.model.basic.Group;
import org.picketlink.idm.model.basic.GroupMembership;
import org.picketlink.idm.model.basic.Role;
import org.picketlink.idm.model.basic.User;
import org.picketlink.idm.query.QueryParameter;

public class IdentityManagedJdbcType
extends AbstractJdbcType {
    protected String name;

    public IdentityManagedJdbcType() {
    }

    public IdentityManagedJdbcType(String name) {
        this.name = name;
    }

    public IdentityManagedJdbcType setName(String name) {
        this.name = name;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setAttribute(Attribute<? extends Serializable> attribute) {
        if (this.type == null) {
            throw IDMMessages.MESSAGES.nullArgument("type");
        }
        this.removeAttribute(attribute.getName());
        AttributeStorageUtil attributeStorageUtil = new AttributeStorageUtil();
        attributeStorageUtil.setAttribute(this.dataSource, this.type.getId(), attribute);
    }

    public void removeAttribute(String name) {
        if (this.type == null) {
            throw IDMMessages.MESSAGES.nullArgument("type");
        }
        AttributeStorageUtil attributeStorageUtil = new AttributeStorageUtil();
        attributeStorageUtil.deleteAttribute(this.dataSource, this.type.getId(), name);
    }

    public <T extends Serializable> Attribute<T> getAttribute(String name) {
        if (this.type == null) {
            throw IDMMessages.MESSAGES.nullArgument("type");
        }
        AttributeStorageUtil attributeStorageUtil = new AttributeStorageUtil();
        return attributeStorageUtil.getAttribute(this.dataSource, this.type.getId(), name);
    }

    public Collection<Attribute<? extends Serializable>> getAttributes() {
        if (this.dataSource == null) {
            throw IDMMessages.MESSAGES.nullArgument("datasource");
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void delete(AttributedType attributedType) {
        String attributedTypeId = attributedType.getId();
        if (attributedType instanceof User) {
            UserStorageUtil userStorageUtil = new UserStorageUtil();
            userStorageUtil.deleteUser(this.dataSource, (User)attributedType);
        } else if (attributedType instanceof Role) {
            RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
            roleStorageUtil.deleteRole(this.dataSource, (Role)attributedType);
        } else if (attributedType instanceof Group) {
            GroupStorageUtil groupStorageUtil = new GroupStorageUtil();
            groupStorageUtil.deleteGroup(this.dataSource, (Group)attributedType);
        } else if (attributedType instanceof Agent) {
            UserStorageUtil userStorageUtil = new UserStorageUtil();
            userStorageUtil.deleteAgent(this.dataSource, (Agent)attributedType);
        } else {
            throw IDMMessages.MESSAGES.unexpectedType(attributedType.getClass());
        }
    }

    @Override
    public void deleteRelationships(AttributedType attributedType) {
        RelationshipStorageUtil relationshipStorageUtil = new RelationshipStorageUtil();
        if (attributedType instanceof User) {
            List<GroupMembership> groupMemberships;
            List<Grant> grants = relationshipStorageUtil.loadGrantsForUser(this.dataSource, (User)attributedType);
            if (grants != null) {
                for (Grant grant : grants) {
                    relationshipStorageUtil.deleteGrant(this.dataSource, grant.getId());
                }
            }
            if ((groupMemberships = relationshipStorageUtil.loadGroupMembershipsForUser(this.dataSource, (User)attributedType)) != null) {
                for (GroupMembership groupMembership : groupMemberships) {
                    relationshipStorageUtil.deleteGroupMembership(this.dataSource, groupMembership.getId());
                }
            }
        } else if (attributedType instanceof Role) {
            List<Grant> grants = relationshipStorageUtil.loadGrantsForRole(this.dataSource, (Role)attributedType);
            if (grants != null) {
                for (Grant grant : grants) {
                    relationshipStorageUtil.deleteGrant(this.dataSource, grant.getId());
                }
            }
        } else if (attributedType instanceof Group) {
            List<GroupMembership> groupMemberships = relationshipStorageUtil.loadGroupMembershipForGroup(this.dataSource, (Group)attributedType);
            if (groupMemberships != null) {
                for (GroupMembership iterator : groupMemberships) {
                    relationshipStorageUtil.deleteGroupMembership(this.dataSource, iterator.getId());
                }
            }
        } else if (attributedType instanceof Agent) {
            Object groupMemberships;
            List<Grant> grants = relationshipStorageUtil.loadGrantsForAgent(this.dataSource, (Agent)attributedType);
            if (grants != null) {
                groupMemberships = grants.iterator();
                while (groupMemberships.hasNext()) {
                    Grant grant = groupMemberships.next();
                    relationshipStorageUtil.deleteGrant(this.dataSource, grant.getId());
                }
            }
            if ((groupMemberships = relationshipStorageUtil.loadGroupMembershipsForAgent(this.dataSource, (Agent)attributedType)) != null) {
                Iterator iterator = groupMemberships.iterator();
                while (iterator.hasNext()) {
                    GroupMembership groupMembership = (GroupMembership)iterator.next();
                    relationshipStorageUtil.deleteGroupMembership(this.dataSource, groupMembership.getId());
                }
            }
        } else {
            throw IDMMessages.MESSAGES.unexpectedType(attributedType.getClass());
        }
    }

    @Override
    public void persist(AttributedType attributedType) {
        String attributedTypeId = attributedType.getId();
        AttributedType storedType = this.load(attributedTypeId, attributedType);
        if (storedType != null) {
            this.update(storedType);
        } else if (attributedType instanceof User) {
            UserStorageUtil userStorageUtil = new UserStorageUtil();
            userStorageUtil.storeUser(this.dataSource, (User)attributedType);
        } else if (attributedType instanceof Role) {
            RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
            roleStorageUtil.storeRole(this.dataSource, (Role)attributedType);
        } else if (attributedType instanceof Group) {
            GroupStorageUtil groupStorageUtil = new GroupStorageUtil();
            groupStorageUtil.storeGroup(this.dataSource, (Group)attributedType);
        } else if (attributedType instanceof Agent) {
            UserStorageUtil userStorageUtil = new UserStorageUtil();
            userStorageUtil.storeAgent(this.dataSource, (Agent)attributedType);
        } else {
            throw IDMMessages.MESSAGES.unexpectedType(attributedType.getClass());
        }
    }

    @Override
    public AttributedType load(String id, AttributedType attributedType) {
        if (attributedType instanceof User || attributedType instanceof Agent) {
            UserStorageUtil userStorageUtil = new UserStorageUtil();
            return userStorageUtil.loadUser(this.dataSource, id);
        }
        if (attributedType instanceof Role) {
            RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
            return roleStorageUtil.loadRole(this.dataSource, id);
        }
        if (attributedType instanceof Group) {
            GroupStorageUtil groupStorageUtil = new GroupStorageUtil();
            return groupStorageUtil.loadGroup(this.dataSource, id);
        }
        throw IDMMessages.MESSAGES.unexpectedType(attributedType.getClass());
    }

    @Override
    public AttributedType load(String id, Class<? extends AttributedType> attributedType) {
        UserStorageUtil userStorageUtil = new UserStorageUtil();
        RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
        GroupStorageUtil groupStorageUtil = new GroupStorageUtil();
        if (attributedType == User.class || attributedType == Agent.class) {
            return userStorageUtil.loadUser(this.dataSource, id);
        }
        if (attributedType == Role.class) {
            return roleStorageUtil.loadRole(this.dataSource, id);
        }
        if (attributedType == Group.class) {
            return groupStorageUtil.loadGroup(this.dataSource, id);
        }
        if (attributedType == IdentityType.class) {
            User storedType = userStorageUtil.loadUser(this.dataSource, id);
            if (storedType != null) {
                return storedType;
            }
            storedType = roleStorageUtil.loadRole(this.dataSource, id);
            if (storedType != null) {
                return storedType;
            }
            storedType = groupStorageUtil.loadGroup(this.dataSource, id);
            if (storedType != null) {
                return storedType;
            }
            throw new RuntimeException("TODO: Cannot find identity type");
        }
        throw new RuntimeException();
    }

    @Override
    public List<? extends AttributedType> load(Map<QueryParameter, Object[]> params, Class<? extends AttributedType> attributedType) {
        ArrayList<User> result = new ArrayList<User>();
        User attributedType1 = null;
        if (attributedType == User.class) {
            UserStorageUtil userStorageUtil = new UserStorageUtil();
            attributedType1 = userStorageUtil.loadUser(this.dataSource, params);
        } else if (attributedType == Role.class) {
            RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
            attributedType1 = roleStorageUtil.loadRole(this.dataSource, params);
        } else if (attributedType == Group.class) {
            GroupStorageUtil groupStorageUtil = new GroupStorageUtil();
            attributedType1 = groupStorageUtil.loadGroup(this.dataSource, params);
        } else if (attributedType == Agent.class) {
            UserStorageUtil userStorageUtil = new UserStorageUtil();
            attributedType1 = userStorageUtil.loadUser(this.dataSource, params);
        } else {
            throw IDMMessages.MESSAGES.unexpectedType(attributedType.getClass());
        }
        if (attributedType1 != null) {
            result.add(attributedType1);
        }
        return result;
    }

    @Override
    public void update(AttributedType attributedType) {
        UserStorageUtil userStorageUtil = new UserStorageUtil();
        RoleStorageUtil roleStorageUtil = new RoleStorageUtil();
        GroupStorageUtil groupStorageUtil = new GroupStorageUtil();
        if (attributedType instanceof User) {
            userStorageUtil.updateUser(this.dataSource, (User)attributedType);
        } else if (attributedType instanceof Role) {
            roleStorageUtil.updateRole(this.dataSource, (Role)attributedType);
        } else if (attributedType instanceof Group) {
            groupStorageUtil.updateGroup(this.dataSource, (Group)attributedType);
        } else if (attributedType instanceof Agent) {
            userStorageUtil.updateAgent(this.dataSource, (Agent)attributedType);
        } else {
            throw new RuntimeException(attributedType.getClass().getName());
        }
    }
}

