/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractControllerService;
import org.jboss.as.controller.AbstractOperationContext;
import org.jboss.as.controller.BootErrorCollector;
import org.jboss.as.controller.CapabilityRegistry;
import org.jboss.as.controller.ContainerStateMonitor;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.CurrentOperationIdHolder;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.HostServerGroupTracker;
import org.jboss.as.controller.ManagementModel;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.ModelControllerClientFactoryImpl;
import org.jboss.as.controller.ModelControllerLock;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationContextImpl;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationHeaders;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ParallelBootOperationStepHandler;
import org.jboss.as.controller.ParsedBootOp;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ReadOnlyContext;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SecurityActions;
import org.jboss.as.controller.access.Authorizer;
import org.jboss.as.controller.audit.AuditLogger;
import org.jboss.as.controller.audit.ManagedAuditLogger;
import org.jboss.as.controller.capability.registry.RuntimeCapabilityRegistry;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationAttachments;
import org.jboss.as.controller.client.OperationMessageHandler;
import org.jboss.as.controller.client.OperationResponse;
import org.jboss.as.controller.extension.ExtensionAddHandler;
import org.jboss.as.controller.extension.MutableRootResourceRegistrationProvider;
import org.jboss.as.controller.extension.ParallelExtensionAddHandler;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.notification.NotificationSupport;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.DelegatingResource;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NotificationHandlerRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.security.auth.server.SecurityIdentity;

class ModelControllerImpl
implements ModelController {
    private static final String INITIAL_BOOT_OPERATION = "initial-boot-operation";
    private static final String POST_EXTENSION_BOOT_OPERATION = "post-extension-boot-operation";
    static final ModelNode EMPTY_ADDRESS = new ModelNode().setEmptyList();
    private static final PathAddress MODEL_CONTROLLER_ADDRESS;
    private final ServiceRegistry serviceRegistry;
    private final ServiceTarget serviceTarget;
    private final ModelControllerLock controllerLock = new ModelControllerLock();
    private final ContainerStateMonitor stateMonitor;
    private final AtomicReference<ManagementModelImpl> managementModel = new AtomicReference();
    private final ConfigurationPersister persister;
    private final ProcessType processType;
    private final RunningModeControl runningModeControl;
    private final AtomicBoolean bootingFlag = new AtomicBoolean(true);
    private final AtomicBoolean bootingReadOnlyFlag = new AtomicBoolean(false);
    private final OperationStepHandler prepareStep;
    private final ControlledProcessState processState;
    private final ExecutorService executorService;
    private final ExpressionResolver expressionResolver;
    private final Authorizer authorizer;
    private final Supplier<SecurityIdentity> securityIdentitySupplier;
    private final ConcurrentMap<Integer, OperationContextImpl> activeOperations = new ConcurrentHashMap<Integer, OperationContextImpl>();
    private final Random random = new Random();
    private final ManagedAuditLogger auditLogger;
    private final BootErrorCollector bootErrorCollector;
    private final NotificationSupport notificationSupport;
    private final HostServerGroupTracker hostServerGroupTracker;
    private final Resource.ResourceEntry modelControllerResource;
    private final OperationStepHandler extraValidationStepHandler;
    private final AbstractControllerService.PartialModelIndicator partialModelIndicator;
    private final AbstractControllerService.ControllerInstabilityListener instabilityListener;
    private volatile ModelControllerClientFactory clientFactory;
    private PathAddress modelControllerResourceAddress;

    ModelControllerImpl(ServiceRegistry serviceRegistry, ServiceTarget serviceTarget, ManagementResourceRegistration rootRegistration, ContainerStateMonitor stateMonitor, ConfigurationPersister persister, ProcessType processType, RunningModeControl runningModeControl, OperationStepHandler prepareStep, ControlledProcessState processState, ExecutorService executorService, ExpressionResolver expressionResolver, Authorizer authorizer, Supplier<SecurityIdentity> securityIdentitySupplier, ManagedAuditLogger auditLogger, NotificationSupport notificationSupport, BootErrorCollector bootErrorCollector, OperationStepHandler extraValidationStepHandler, CapabilityRegistry capabilityRegistry, AbstractControllerService.PartialModelIndicator partialModelIndicator, AbstractControllerService.ControllerInstabilityListener instabilityListener) {
        this.partialModelIndicator = partialModelIndicator;
        this.instabilityListener = instabilityListener;
        assert (serviceRegistry != null);
        this.serviceRegistry = serviceRegistry;
        assert (serviceTarget != null);
        this.serviceTarget = serviceTarget;
        assert (rootRegistration != null);
        assert (capabilityRegistry != null);
        ManagementModelImpl mmi = new ManagementModelImpl(rootRegistration, Resource.Factory.create(), capabilityRegistry);
        mmi.publish();
        assert (stateMonitor != null);
        this.stateMonitor = stateMonitor;
        assert (persister != null);
        this.persister = persister;
        assert (processType != null);
        this.processType = processType;
        assert (runningModeControl != null);
        this.runningModeControl = runningModeControl;
        assert (notificationSupport != null);
        this.notificationSupport = notificationSupport;
        OperationStepHandler operationStepHandler = this.prepareStep = prepareStep == null ? new DefaultPrepareStepHandler() : prepareStep;
        assert (processState != null);
        this.processState = processState;
        this.serviceTarget.addMonitor(stateMonitor.getStabilityMonitor());
        this.executorService = executorService;
        assert (expressionResolver != null);
        this.expressionResolver = expressionResolver;
        assert (securityIdentitySupplier != null);
        this.securityIdentitySupplier = securityIdentitySupplier;
        assert (authorizer != null);
        this.authorizer = authorizer;
        assert (auditLogger != null);
        this.auditLogger = auditLogger;
        assert (bootErrorCollector != null);
        this.bootErrorCollector = bootErrorCollector;
        this.hostServerGroupTracker = processType.isManagedDomain() ? new HostServerGroupTracker() : null;
        this.modelControllerResource = new ModelControllerResource();
        this.extraValidationStepHandler = extraValidationStepHandler;
        if (processType.isServer()) {
            this.modelControllerResourceAddress = MODEL_CONTROLLER_ADDRESS;
        }
        auditLogger.startBoot();
    }

    ModelControllerClientFactory getClientFactory() {
        if (this.clientFactory == null) {
            this.clientFactory = new ModelControllerClientFactoryImpl(this, this.securityIdentitySupplier);
        }
        return this.clientFactory;
    }

    @Override
    public ModelNode execute(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationAttachments attachments) {
        SecurityIdentity securityIdentity = this.securityIdentitySupplier.get();
        OperationResponse or = (OperationResponse)securityIdentity.runAs(() -> this.internalExecute(operation, handler, control, attachments, this.prepareStep, false, this.partialModelIndicator.isModelPartial()));
        ModelNode result = or.getResponseNode();
        try {
            or.close();
        }
        catch (IOException e) {
            ControllerLogger.ROOT_LOGGER.debugf(e, "Caught exception closing response to %s whose associated streams, if any, were not wanted", operation);
        }
        return result;
    }

    @Override
    public OperationResponse execute(Operation operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control) {
        SecurityIdentity securityIdentity = this.securityIdentitySupplier.get();
        return (OperationResponse)securityIdentity.runAs(() -> this.internalExecute(operation.getOperation(), handler, control, (OperationAttachments)operation, this.prepareStep, false, this.partialModelIndicator.isModelPartial()));
    }

    private AbstractOperationContext getDelegateContext(int operationId) {
        AbstractOperationContext delegateContext;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ModelController.ACCESS_PERMISSION);
        }
        if ((delegateContext = (AbstractOperationContext)this.activeOperations.get(operationId)) == null) {
            throw ControllerLogger.ROOT_LOGGER.noContextToDelegateTo(operationId);
        }
        return delegateContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelNode executeReadOnlyOperation(ModelNode operation, OperationMessageHandler handler, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep, int operationId) {
        AbstractOperationContext delegateContext = this.getDelegateContext(operationId);
        CurrentOperationIdHolder.setCurrentOperationID(operationId);
        try {
            ModelNode modelNode = this.executeReadOnlyOperation(operation, delegateContext.getManagementModel(), control, prepareStep, delegateContext);
            return modelNode;
        }
        finally {
            CurrentOperationIdHolder.setCurrentOperationID(null);
        }
    }

    protected ModelNode executeReadOnlyOperation(ModelNode operation, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep) {
        AbstractOperationContext delegateContext = this.getDelegateContext(CurrentOperationIdHolder.getCurrentOperationID());
        return this.executeReadOnlyOperation(operation, delegateContext.getManagementModel(), control, prepareStep, delegateContext);
    }

    protected ModelNode executeReadOnlyOperation(ModelNode operation, Resource resource, ModelController.OperationTransactionControl control, OperationStepHandler prepareStep) {
        int operationId = CurrentOperationIdHolder.getCurrentOperationID();
        AbstractOperationContext delegateContext = this.getDelegateContext(operationId);
        ManagementModelImpl current = delegateContext.getManagementModel();
        ManagementModelImpl mgmtModel = new ManagementModelImpl(current.getRootResourceRegistration(), resource, current.capabilityRegistry);
        return this.executeReadOnlyOperation(operation, mgmtModel, control, prepareStep, delegateContext);
    }

    protected ModelNode executeReadOnlyOperation(ModelNode operation, ManagementModelImpl model, final ModelController.OperationTransactionControl control, OperationStepHandler prepareStep, AbstractOperationContext delegateContext) {
        final ModelNode response = new ModelNode();
        int operationId = CurrentOperationIdHolder.getCurrentOperationID();
        ModelController.OperationTransactionControl txControl = control == null ? null : new ModelController.OperationTransactionControl(){

            @Override
            public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                control.operationPrepared(transaction, response);
            }
        };
        ReadOnlyContext context = new ReadOnlyContext(this.processType, this.runningModeControl.getRunningMode(), txControl, this.processState, false, model, delegateContext, this, operationId, this.securityIdentitySupplier);
        context.addStep(response, operation, prepareStep, OperationContext.Stage.MODEL);
        context.executeOperation();
        if (!response.hasDefined("response-headers") || !response.get("response-headers").hasDefined("process-state")) {
            ControlledProcessState.State state = this.processState.getState();
            switch (state) {
                case RELOAD_REQUIRED: 
                case RESTART_REQUIRED: {
                    response.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                    break;
                }
            }
        }
        return response;
    }

    /*
     * Unable to fully structure code
     */
    protected OperationResponse internalExecute(ModelNode operation, OperationMessageHandler handler, final ModelController.OperationTransactionControl control, OperationAttachments attachments, OperationStepHandler prepareStep, boolean attemptLock, boolean partialModel) {
        block32: {
            sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(ModelController.ACCESS_PERMISSION);
            }
            if ((responseNode = Util.validateOperation(operation)).hasDefined("failure-description")) {
                return OperationResponse.Factory.createSimple((ModelNode)responseNode);
            }
            try {
                headers = OperationHeaders.fromOperation(operation);
            }
            catch (OperationFailedException ofe) {
                return OperationHeaders.fromFailure(ofe);
            }
            originalResultTxControl = control == null ? null : new ModelController.OperationTransactionControl(){

                @Override
                public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result, OperationContext context) {
                    control.operationPrepared(transaction, responseNode, context);
                }

                @Override
                public void operationPrepared(ModelController.OperationTransaction transaction, ModelNode result) {
                    control.operationPrepared(transaction, responseNode);
                }
            };
            accessMechanism = null;
            accessContext = SecurityActions.currentAccessAuditContext();
            if (accessContext != null) {
                if (headers.getDomainUUID() != null) {
                    accessContext.setDomainUuid(headers.getDomainUUID());
                    accessContext.setDomainRollout(true);
                }
                if (headers.getAccessMechanism() != null) {
                    accessContext.setAccessMechanism(headers.getAccessMechanism());
                }
                accessMechanism = accessContext.getAccessMechanism();
            }
            if (accessMechanism != null && this.bootingFlag.get() || accessMechanism != null && !this.bootingFlag.get() && this.bootingReadOnlyFlag.get() && !this.isReadOnlyOperation(operation)) {
                return ModelControllerImpl.handleExternalRequestDuringBoot();
            }
            do {
                responseStreams = null;
            } while (this.activeOperations.putIfAbsent(operationID = Integer.valueOf(this.random.nextInt()), context = new OperationContextImpl(operationID, operation.get("operation").asString(), operation.get("address"), this, this.processType, this.runningModeControl.getRunningMode(), headers, handler, attachments, this.managementModel.get(), originalResultTxControl, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, accessContext, this.notificationSupport, false, this.extraValidationStepHandler, partialModel, this.securityIdentitySupplier)) != null);
            CurrentOperationIdHolder.setCurrentOperationID(operationID);
            shouldUnlock = false;
            if (!attemptLock) ** GOTO lbl52
            if (this.controllerLock.detectDeadlockAndGetLock(operationID)) break block32;
            responseNode.get("outcome").set("failed");
            responseNode.get("failure-description").set(ControllerLogger.ROOT_LOGGER.cannotGetControllerLock());
            var18_19 = OperationResponse.Factory.createSimple((ModelNode)responseNode);
            if (!responseNode.hasDefined("response-headers") || !responseNode.get("response-headers").hasDefined("process-state")) {
                state = this.processState.getState();
                switch (4.$SwitchMap$org$jboss$as$controller$ControlledProcessState$State[state.ordinal()]) {
                    case 1: 
                    case 2: {
                        responseNode.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                        break;
                    }
                }
            }
            if (shouldUnlock) {
                this.controllerLock.unlock(operationID);
            }
            this.activeOperations.remove(operationID);
            CurrentOperationIdHolder.setCurrentOperationID(null);
            return var18_19;
        }
        try {
            shouldUnlock = true;
lbl52:
            // 2 sources

            context.addStep(responseNode, operation, prepareStep, OperationContext.Stage.MODEL);
            ControllerLogger.MGMT_OP_LOGGER.tracef("Executing %s", operation);
            context.executeOperation();
            responseStreams = context.getResponseStreams();
        }
        catch (Error e) {
            try {
                try {
                    this.controllerUnstable();
                }
                catch (Error var19_23) {
                    // empty catch block
                }
                throw e;
            }
            catch (Throwable var20_24) {
                if (!responseNode.hasDefined("response-headers") || !responseNode.get("response-headers").hasDefined("process-state")) {
                    state = this.processState.getState();
                    switch (4.$SwitchMap$org$jboss$as$controller$ControlledProcessState$State[state.ordinal()]) {
                        case 1: 
                        case 2: {
                            responseNode.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                            break;
                        }
                    }
                }
                if (shouldUnlock) {
                    this.controllerLock.unlock(operationID);
                }
                this.activeOperations.remove(operationID);
                CurrentOperationIdHolder.setCurrentOperationID(null);
                throw var20_24;
            }
        }
        if (!responseNode.hasDefined("response-headers") || !responseNode.get("response-headers").hasDefined("process-state")) {
            state = this.processState.getState();
            switch (4.$SwitchMap$org$jboss$as$controller$ControlledProcessState$State[state.ordinal()]) {
                case 1: 
                case 2: {
                    responseNode.get(new String[]{"response-headers", "process-state"}).set(state.toString());
                    break;
                }
            }
        }
        if (shouldUnlock) {
            this.controllerLock.unlock(operationID);
        }
        this.activeOperations.remove(operationID);
        CurrentOperationIdHolder.setCurrentOperationID(null);
        if (responseStreams == null || responseStreams.size() == 0) {
            return OperationResponse.Factory.createSimple((ModelNode)responseNode);
        }
        return new OperationResponseImpl(responseNode, responseStreams);
    }

    private static OperationResponse handleExternalRequestDuringBoot() {
        ModelNode result = new ModelNode();
        result.get("outcome").set("failed");
        result.get("failure-description").set(ControllerLogger.MGMT_OP_LOGGER.managementUnavailableDuringBoot());
        return OperationResponse.Factory.createSimple((ModelNode)result);
    }

    boolean boot(List<ModelNode> bootList, OperationMessageHandler handler, ModelController.OperationTransactionControl control, boolean rollbackOnRuntimeFailure, MutableRootResourceRegistrationProvider parallelBootRootResourceRegistrationProvider, boolean skipModelValidation, boolean partialModel) {
        OperationContext.ResultAction resultAction;
        Integer operationID = this.random.nextInt();
        OperationHeaders headers = OperationHeaders.forBoot(rollbackOnRuntimeFailure);
        OperationContextImpl context = new OperationContextImpl(operationID, INITIAL_BOOT_OPERATION, EMPTY_ADDRESS, this, this.processType, this.runningModeControl.getRunningMode(), headers, handler, null, this.managementModel.get(), control, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, null, this.notificationSupport, true, this.extraValidationStepHandler, true, this.securityIdentitySupplier);
        BootOperations bootOperations = this.organizeBootOperations(bootList, operationID, parallelBootRootResourceRegistrationProvider);
        OperationContext.ResultAction resultAction2 = resultAction = bootOperations.invalid ? OperationContext.ResultAction.ROLLBACK : OperationContext.ResultAction.KEEP;
        if (bootOperations.initialOps.size() > 0) {
            for (Object initialOp : bootOperations.initialOps) {
                context.addBootStep((ParsedBootOp)initialOp);
            }
            resultAction = ((AbstractOperationContext)context).executeOperation();
        }
        if (resultAction == OperationContext.ResultAction.KEEP && bootOperations.postExtensionOps != null) {
            OperationContextImpl postExtContext = new OperationContextImpl(operationID, POST_EXTENSION_BOOT_OPERATION, EMPTY_ADDRESS, this, this.processType, this.runningModeControl.getRunningMode(), headers, handler, null, this.managementModel.get(), control, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, null, this.notificationSupport, true, this.extraValidationStepHandler, partialModel, this.securityIdentitySupplier);
            for (ParsedBootOp parsedOp : bootOperations.postExtensionOps) {
                if (parsedOp.handler == null) {
                    parsedOp = new ParsedBootOp(parsedOp, this.managementModel.get().getRootResourceRegistration().getOperationHandler(parsedOp.address, parsedOp.operationName));
                }
                if (parsedOp.handler == null) {
                    this.logNoHandler(parsedOp);
                    postExtContext.setRollbackOnly();
                    break;
                }
                postExtContext.addBootStep(parsedOp);
            }
            resultAction = ((AbstractOperationContext)postExtContext).executeOperation();
            if (!skipModelValidation && resultAction == OperationContext.ResultAction.KEEP && bootOperations.postExtensionOps != null) {
                HashSet<PathAddress> validateAddresses = new HashSet<PathAddress>();
                Resource root = this.managementModel.get().getRootResource();
                this.addAllAddresses(this.managementModel.get().getRootResourceRegistration(), PathAddress.EMPTY_ADDRESS, root, validateAddresses);
                OperationContextImpl validateContext = new OperationContextImpl(operationID, POST_EXTENSION_BOOT_OPERATION, EMPTY_ADDRESS, this, this.processType, this.runningModeControl.getRunningMode(), headers, handler, null, this.managementModel.get(), control, this.processState, this.auditLogger, this.bootingFlag.get(), this.hostServerGroupTracker, null, this.notificationSupport, false, this.extraValidationStepHandler, partialModel, this.securityIdentitySupplier);
                validateContext.addModifiedResourcesForModelValidation(validateAddresses);
                resultAction = ((AbstractOperationContext)validateContext).executeOperation();
            }
        }
        return resultAction == OperationContext.ResultAction.KEEP;
    }

    private void addAllAddresses(ImmutableManagementResourceRegistration mrr, PathAddress current, Resource resource, Set<PathAddress> addresses) {
        addresses.add(current);
        for (String name : ModelControllerImpl.getNonIgnoredChildTypes(mrr)) {
            for (Resource.ResourceEntry entry : resource.getChildren(name)) {
                if (entry.isProxy() || entry.isRuntime()) continue;
                this.addAllAddresses(mrr.getSubModel(PathAddress.pathAddress(entry.getPathElement())), current.append(entry.getPathElement()), entry, addresses);
            }
        }
    }

    private static Set<String> getNonIgnoredChildTypes(ImmutableManagementResourceRegistration mrr) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (PathElement pe : mrr.getChildAddresses(PathAddress.EMPTY_ADDRESS)) {
            ImmutableManagementResourceRegistration childMrr = mrr.getSubModel(PathAddress.pathAddress(pe));
            if (childMrr == null || childMrr.isRemote() || childMrr.isRuntimeOnly()) continue;
            result.add(pe.getKey());
        }
        return result;
    }

    private BootOperations organizeBootOperations(List<ModelNode> bootList, int lockPermit, MutableRootResourceRegistrationProvider parallelBootRootResourceRegistrationProvider) {
        ArrayList<ParsedBootOp> initialOps = new ArrayList<ParsedBootOp>();
        ArrayList<ParsedBootOp> postExtensionOps = null;
        boolean invalid = false;
        boolean sawExtensionAdd = false;
        ManagementResourceRegistration rootRegistration = this.managementModel.get().getRootResourceRegistration();
        MutableRootResourceRegistrationProvider parallellBRRRProvider = parallelBootRootResourceRegistrationProvider != null ? parallelBootRootResourceRegistrationProvider : ModelControllerImpl.getMutableRootResourceRegistrationProvider();
        ParallelExtensionAddHandler parallelExtensionAddHandler = this.executorService == null ? null : new ParallelExtensionAddHandler(this.executorService, parallellBRRRProvider);
        ParallelBootOperationStepHandler parallelSubsystemHandler = this.executorService != null && this.processType.isServer() && this.runningModeControl.getRunningMode() == RunningMode.NORMAL ? new ParallelBootOperationStepHandler(this.executorService, rootRegistration, this.processState, this, lockPermit, this.extraValidationStepHandler) : null;
        boolean registeredParallelSubsystemHandler = false;
        int subsystemIndex = 0;
        for (ModelNode bootOp : bootList) {
            OperationStepHandler stepHandler;
            ParsedBootOp parsedOp = new ParsedBootOp(bootOp);
            if (postExtensionOps != null) {
                if (parsedOp.isExtensionAdd()) {
                    stepHandler = (ExtensionAddHandler)rootRegistration.getOperationHandler(parsedOp.address, parsedOp.operationName);
                    if (parallelExtensionAddHandler != null) {
                        parallelExtensionAddHandler.addParsedOp(parsedOp, (ExtensionAddHandler)stepHandler);
                        continue;
                    }
                    initialOps.add(new ParsedBootOp(parsedOp, stepHandler));
                    continue;
                }
                if (parallelSubsystemHandler == null || !parallelSubsystemHandler.addSubsystemOperation(parsedOp)) {
                    if (registeredParallelSubsystemHandler && (parsedOp.isInterfaceOperation() || parsedOp.isSocketOperation())) {
                        postExtensionOps.add(subsystemIndex++, parsedOp);
                        continue;
                    }
                    postExtensionOps.add(parsedOp);
                    continue;
                }
                if (registeredParallelSubsystemHandler) continue;
                postExtensionOps.add(parallelSubsystemHandler.getParsedBootOp());
                subsystemIndex = postExtensionOps.size() - 1;
                registeredParallelSubsystemHandler = true;
                continue;
            }
            stepHandler = rootRegistration.getOperationHandler(parsedOp.address, parsedOp.operationName);
            if (!sawExtensionAdd && stepHandler == null) {
                this.logNoHandler(parsedOp);
                invalid = true;
                break;
            }
            if (stepHandler instanceof ExtensionAddHandler) {
                if (parallelExtensionAddHandler != null) {
                    parallelExtensionAddHandler.addParsedOp(parsedOp, (ExtensionAddHandler)stepHandler);
                    if (!sawExtensionAdd) {
                        initialOps.add(parallelExtensionAddHandler.getParsedBootOp());
                    }
                } else {
                    initialOps.add(new ParsedBootOp(parsedOp, stepHandler));
                }
                sawExtensionAdd = true;
                continue;
            }
            if (!sawExtensionAdd) {
                initialOps.add(new ParsedBootOp(parsedOp, stepHandler));
                continue;
            }
            postExtensionOps = new ArrayList<ParsedBootOp>(32);
            if (parallelSubsystemHandler == null || !parallelSubsystemHandler.addSubsystemOperation(parsedOp)) {
                postExtensionOps.add(parsedOp);
                continue;
            }
            postExtensionOps.add(parallelSubsystemHandler.getParsedBootOp());
            registeredParallelSubsystemHandler = true;
        }
        return new BootOperations(initialOps, postExtensionOps, invalid);
    }

    void finishBoot() {
        this.auditLogger.bootDone();
        this.bootingReadOnlyFlag.set(false);
        this.bootingFlag.set(false);
    }

    void finishBoot(boolean readOnly) {
        this.auditLogger.bootDone();
        this.bootingReadOnlyFlag.set(readOnly);
        this.bootingFlag.set(false);
    }

    void clearBootingReadOnlyFlag() {
        this.bootingReadOnlyFlag.set(false);
    }

    ManagementModel getManagementModel() {
        return this.managementModel.get();
    }

    Resource.ResourceEntry getModelControllerResource() {
        return this.modelControllerResource;
    }

    @Override
    public ModelControllerClient createClient(Executor executor) {
        return this.getClientFactory().createSuperUserClient(executor, false);
    }

    ConfigurationPersister.PersistenceResource writeModel(final ManagementModelImpl model, Set<PathAddress> affectedAddresses, final boolean resourceTreeModified, final boolean capabilityRegistryModified, final boolean resourceRegistrationModified) throws ConfigurationPersistenceException {
        ConfigurationPersister.PersistenceResource delegate;
        if (resourceTreeModified) {
            if (this.persister.isPersisting()) {
                ControllerLogger.MGMT_OP_LOGGER.tracef("persisting %s from %s", model.rootResource, model);
                ModelNode newModel = Resource.Tools.readModel(model.rootResource, model.resourceRegistration);
                delegate = this.persister.store(newModel, affectedAddresses);
            } else {
                ControllerLogger.MGMT_OP_LOGGER.tracef("Ignoring permanent persistence during boot", new Object[0]);
                delegate = null;
            }
        } else {
            ControllerLogger.MGMT_OP_LOGGER.tracef("persisting with no resource tree changes to %s", model);
            delegate = null;
        }
        return new ConfigurationPersister.PersistenceResource(){

            @Override
            public void commit() {
                if (ModelControllerImpl.this.hostServerGroupTracker != null) {
                    ModelControllerImpl.this.hostServerGroupTracker.invalidate();
                }
                if ((capabilityRegistryModified || resourceRegistrationModified) && model.capabilityRegistry.isModified()) {
                    model.capabilityRegistry.publish();
                }
                if (resourceTreeModified) {
                    model.publish();
                    if (delegate != null) {
                        delegate.commit();
                    }
                }
            }

            @Override
            public void rollback() {
                if (delegate != null) {
                    delegate.rollback();
                }
            }
        };
    }

    void discardModel(ManagementModelImpl model, boolean resourceTreeModified, boolean capabilityRegistryModified, boolean resourceRegistrationModified) {
        if ((capabilityRegistryModified || resourceRegistrationModified) && model.capabilityRegistry.isModified()) {
            model.capabilityRegistry.rollback();
        }
        if (resourceTreeModified) {
            model.discard();
        }
    }

    void acquireWriteLock(Integer permit, boolean interruptibly) throws InterruptedException {
        if (interruptibly) {
            this.controllerLock.lockInterruptibly(permit);
        } else {
            this.controllerLock.lock(permit);
        }
    }

    void acquireReadLock(Integer permit, boolean interruptibly) throws InterruptedException {
        if (interruptibly) {
            this.controllerLock.lockSharedInterruptibly(permit);
        } else {
            this.controllerLock.lockShared(permit);
        }
    }

    boolean acquireWriteLock(Integer permit, boolean interruptibly, long timeout) throws InterruptedException {
        if (interruptibly) {
            return this.controllerLock.lockInterruptibly(permit, timeout, TimeUnit.SECONDS);
        }
        return this.controllerLock.lock(permit, timeout, TimeUnit.SECONDS);
    }

    void releaseWriteLock(Integer permit) {
        this.controllerLock.unlock(permit);
    }

    void releaseReadLock(Integer permit) {
        this.controllerLock.unlockShared(permit);
    }

    void logContainerStateChangesAndReset() {
        this.stateMonitor.logContainerStateChangesAndReset();
    }

    void awaitContainerStability(long timeout, TimeUnit timeUnit, boolean interruptibly) throws InterruptedException, TimeoutException {
        if (interruptibly) {
            this.stateMonitor.awaitStability(timeout, timeUnit);
        } else {
            this.stateMonitor.awaitStabilityUninterruptibly(timeout, timeUnit);
        }
    }

    ContainerStateMonitor.ContainerStateChangeReport awaitContainerStateChangeReport(long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        return this.stateMonitor.awaitContainerStateChangeReport(timeout, timeUnit);
    }

    void containerCannotStabilize() {
        this.controllerUnstable();
    }

    private void controllerUnstable() {
        this.processState.setRestartRequired();
        if (this.instabilityListener != null) {
            this.instabilityListener.controllerUnstable();
        }
    }

    ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    @Override
    public NotificationHandlerRegistration getNotificationRegistry() {
        return this.notificationSupport.getNotificationRegistry();
    }

    NotificationSupport getNotificationSupport() {
        return this.notificationSupport;
    }

    ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        return this.expressionResolver.resolveExpressions(node);
    }

    Authorizer getAuthorizer() {
        return this.authorizer;
    }

    private void logNoHandler(ParsedBootOp parsedOp) {
        ManagementResourceRegistration child = this.managementModel.get().getRootResourceRegistration().getSubModel(parsedOp.address);
        if (child == null) {
            ControllerLogger.ROOT_LOGGER.error(ControllerLogger.ROOT_LOGGER.noSuchResourceType(parsedOp.address));
        } else {
            ControllerLogger.ROOT_LOGGER.error(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(parsedOp.operationName, parsedOp.address));
        }
    }

    AuditLogger getAuditLogger() {
        return this.auditLogger;
    }

    static MutableRootResourceRegistrationProvider getMutableRootResourceRegistrationProvider() {
        return MutableRootResourceRegistrationProviderImpl.INSTANCE;
    }

    void addFailureDescription(ModelNode operation, ModelNode failure) {
        if (this.bootingFlag.get()) {
            this.bootErrorCollector.addFailureDescription(operation, failure);
        }
    }

    PathAddress getModelControllerResourceAddress(ManagementModel managementModel) {
        if (this.modelControllerResourceAddress == null) {
            Set<String> hosts = managementModel.getRootResource().getChildrenNames("host");
            if (hosts.size() == 0) {
                return null;
            }
            String hostName = hosts.iterator().next();
            this.modelControllerResourceAddress = PathAddress.pathAddress("host", hostName).append(MODEL_CONTROLLER_ADDRESS);
        }
        return this.modelControllerResourceAddress;
    }

    private OperationEntry resolveOperationHandler(PathAddress address, String operationName) {
        PathElement pe;
        ManagementResourceRegistration rootRegistration = this.managementModel.get().getRootResourceRegistration();
        OperationEntry result = rootRegistration.getOperationEntry(address, operationName);
        if (result == null && address.size() > 0 && (pe = address.getLastElement()).isWildcard()) {
            String type = pe.getKey();
            PathAddress parent = address.subAddress(0, address.size() - 1);
            Set<PathElement> children = rootRegistration.getChildAddresses(parent);
            if (children != null) {
                OperationEntry found = null;
                for (PathElement child : children) {
                    OperationStepHandler osh;
                    if (!type.equals(child.getKey())) continue;
                    OperationEntry oe = rootRegistration.getOperationEntry(parent.append(child), operationName);
                    OperationStepHandler operationStepHandler = osh = oe == null ? null : oe.getOperationHandler();
                    if (osh == null || found != null && !osh.equals(found.getOperationHandler())) {
                        found = null;
                        break;
                    }
                    found = oe;
                }
                if (found != null) {
                    result = found;
                }
            }
        }
        return result;
    }

    private boolean isReadOnlyOperation(ModelNode operation) {
        if (operation.hasDefined("steps")) {
            ModelNode step;
            List steps = operation.get("steps").asList();
            boolean readOnly = !steps.isEmpty();
            Iterator iterator = steps.iterator();
            while (iterator.hasNext() && (readOnly = this.isReadOnlyOperation(step = (ModelNode)iterator.next()))) {
            }
            return readOnly;
        }
        String operationName = operation.get("operation").asString();
        return GlobalOperationHandlers.STD_READ_OPS.contains(operationName) || "read-boot-errors".equals(operationName) || "find-non-progressing-operation".equals(operationName) || "whoami".equals(operationName) || "read-log-file".equals(operationName);
    }

    static {
        EMPTY_ADDRESS.protect();
        MODEL_CONTROLLER_ADDRESS = PathAddress.pathAddress(PathElement.pathElement("core-service", "management"), PathElement.pathElement("service", "management-operations"));
    }

    private static class OperationResponseImpl
    implements OperationResponse {
        private final ModelNode simpleResponse;
        private final Map<String, OperationResponse.StreamEntry> inputStreams;

        private OperationResponseImpl(ModelNode simpleResponse, Map<String, OperationResponse.StreamEntry> inputStreams) {
            this.simpleResponse = simpleResponse;
            this.inputStreams = inputStreams;
            ModelNode header = simpleResponse.get(new String[]{"response-headers", "attached-streams"});
            header.setEmptyList();
            for (OperationResponse.StreamEntry entry : inputStreams.values()) {
                ModelNode streamNode = new ModelNode();
                streamNode.get("uuid").set(entry.getUUID());
                streamNode.get("mime-type").set(entry.getMimeType());
                header.add(streamNode);
            }
        }

        public ModelNode getResponseNode() {
            return this.simpleResponse;
        }

        public List<OperationResponse.StreamEntry> getInputStreams() {
            return new ArrayList<OperationResponse.StreamEntry>(this.inputStreams.values());
        }

        public OperationResponse.StreamEntry getInputStream(String uuid) {
            return this.inputStreams.get(uuid);
        }

        public void close() throws IOException {
            int i = 0;
            for (OperationResponse.StreamEntry is : this.inputStreams.values()) {
                try {
                    is.getStream().close();
                }
                catch (Exception e) {
                    ControllerLogger.MGMT_OP_LOGGER.debugf(e, "Failed closing response stream at index %d", i);
                }
                ++i;
            }
        }
    }

    final class ManagementModelImpl
    implements ManagementModel {
        private final ManagementResourceRegistration resourceRegistration;
        private final Resource rootResource;
        private final ManagementResourceRegistration delegatingResourceRegistration;
        private final Resource delegatingResource;
        private final CapabilityRegistry capabilityRegistry;
        private volatile boolean published;

        ManagementModelImpl(ManagementResourceRegistration resourceRegistration, final Resource rootResource, CapabilityRegistry capabilityRegistry) {
            this.resourceRegistration = resourceRegistration;
            this.rootResource = rootResource;
            assert (capabilityRegistry != null);
            this.capabilityRegistry = capabilityRegistry;
            this.delegatingResourceRegistration = resourceRegistration;
            this.delegatingResource = new DelegatingResource(new DelegatingResource.ResourceDelegateProvider(){

                @Override
                public Resource getDelegateResource() {
                    Resource result = ManagementModelImpl.this.published ? ((ManagementModelImpl)ModelControllerImpl.this.managementModel.get()).rootResource : rootResource;
                    return result;
                }
            });
        }

        @Override
        public ManagementResourceRegistration getRootResourceRegistration() {
            return this.delegatingResourceRegistration;
        }

        @Override
        public Resource getRootResource() {
            return this.delegatingResource;
        }

        @Override
        public RuntimeCapabilityRegistry getCapabilityRegistry() {
            return this.capabilityRegistry;
        }

        ManagementModelImpl cloneRootResource() {
            CapabilityRegistry currentCaps;
            Resource currentResource;
            ManagementResourceRegistration mrr;
            if (this.published) {
                ManagementModelImpl currentPublished = (ManagementModelImpl)ModelControllerImpl.this.managementModel.get();
                mrr = currentPublished.resourceRegistration;
                currentResource = currentPublished.rootResource;
                currentCaps = currentPublished.capabilityRegistry;
            } else {
                mrr = this.resourceRegistration;
                currentResource = this.rootResource;
                currentCaps = this.capabilityRegistry;
            }
            Resource clone = currentResource.clone();
            ManagementModelImpl result = new ManagementModelImpl(mrr, clone, currentCaps);
            ControllerLogger.MGMT_OP_LOGGER.tracef("cloned to %s to create %s and %s", currentResource, clone, result);
            return result;
        }

        CapabilityRegistry.CapabilityValidation validateCapabilityRegistry(boolean forceCheck, boolean hostXmlOnly) {
            if (!this.published || this.capabilityRegistry.isModified() || forceCheck) {
                return this.capabilityRegistry.resolveCapabilities(this.getRootResource(), hostXmlOnly);
            }
            return CapabilityRegistry.CapabilityValidation.OK;
        }

        private void publish() {
            ModelControllerImpl.this.managementModel.set(this);
            this.published = true;
            ControllerLogger.MGMT_OP_LOGGER.tracef("published %s", this);
        }

        private void discard() {
            this.published = true;
            ControllerLogger.MGMT_OP_LOGGER.tracef("discarded %s", this);
        }
    }

    private static class MutableRootResourceRegistrationProviderImpl
    implements MutableRootResourceRegistrationProvider {
        private static final MutableRootResourceRegistrationProvider INSTANCE = new MutableRootResourceRegistrationProviderImpl();

        private MutableRootResourceRegistrationProviderImpl() {
        }

        @Override
        public ManagementResourceRegistration getRootResourceRegistrationForUpdate(OperationContext context) {
            assert (context instanceof AbstractOperationContext);
            return ((AbstractOperationContext)context).getRootResourceRegistrationForUpdate();
        }
    }

    private final class ModelControllerResource
    extends PlaceholderResource.PlaceholderResourceEntry {
        private ModelControllerResource() {
            super("service", "management-operations");
        }

        @Override
        public boolean hasChild(PathElement element) {
            try {
                return "active-operation".equals(element.getKey()) && ModelControllerImpl.this.activeOperations.containsKey(Integer.valueOf(element.getValue()));
            }
            catch (NumberFormatException e) {
                return false;
            }
        }

        @Override
        public Resource getChild(PathElement element) {
            Resource.ResourceEntry result = null;
            if ("active-operation".equals(element.getKey())) {
                try {
                    OperationContextImpl context = (OperationContextImpl)ModelControllerImpl.this.activeOperations.get(Integer.valueOf(element.getValue()));
                    if (context != null) {
                        result = context.getActiveOperationResource();
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return result;
        }

        @Override
        public Resource requireChild(PathElement element) {
            Resource resource = this.getChild(element);
            if (resource == null) {
                throw new Resource.NoSuchResourceException(element);
            }
            return resource;
        }

        @Override
        public boolean hasChildren(String childType) {
            return "active-operation".equals(childType) && ModelControllerImpl.this.activeOperations.size() > 0;
        }

        @Override
        public Set<String> getChildTypes() {
            return Collections.singleton("active-operation");
        }

        @Override
        public Set<String> getChildrenNames(String childType) {
            HashSet<String> result = new HashSet<String>(ModelControllerImpl.this.activeOperations.size());
            for (Integer id : ModelControllerImpl.this.activeOperations.keySet()) {
                result.add(id.toString());
            }
            return result;
        }

        @Override
        public Set<Resource.ResourceEntry> getChildren(String childType) {
            HashSet<Resource.ResourceEntry> result = new HashSet<Resource.ResourceEntry>(ModelControllerImpl.this.activeOperations.size());
            for (OperationContextImpl context : ModelControllerImpl.this.activeOperations.values()) {
                result.add(context.getActiveOperationResource());
            }
            return result;
        }
    }

    private static final class BootOperations {
        private final List<ParsedBootOp> initialOps;
        private final List<ParsedBootOp> postExtensionOps;
        private final boolean invalid;

        private BootOperations(List<ParsedBootOp> initialOps, List<ParsedBootOp> postExtensionOps, boolean invalid) {
            this.initialOps = initialOps;
            this.postExtensionOps = postExtensionOps;
            this.invalid = invalid;
        }
    }

    private class DefaultPrepareStepHandler
    implements OperationStepHandler {
        private DefaultPrepareStepHandler() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            String operationName;
            PathAddress address;
            OperationEntry stepOperation;
            if (ControllerLogger.MGMT_OP_LOGGER.isTraceEnabled()) {
                ControllerLogger.MGMT_OP_LOGGER.tracef("Executing %s %s", operation.get("operation"), operation.get("address"));
            }
            if ((stepOperation = ModelControllerImpl.this.resolveOperationHandler(address = context.getCurrentAddress(), operationName = operation.require("operation").asString())) != null) {
                if (!context.isBooting() && stepOperation.getType() == OperationEntry.EntryType.PRIVATE && operation.hasDefined(new String[]{"operation-headers", "caller-type"}) && "user".equals(operation.get(new String[]{"operation-headers", "caller-type"}).asString())) {
                    context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(operationName, address));
                } else {
                    context.addModelStep(stepOperation.getOperationDefinition(), stepOperation.getOperationHandler(), false);
                }
            } else {
                ManagementResourceRegistration child = ((ManagementModelImpl)ModelControllerImpl.this.managementModel.get()).getRootResourceRegistration().getSubModel(address);
                if (child == null) {
                    context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.noSuchResourceType(address));
                } else {
                    context.getFailureDescription().set(ControllerLogger.ROOT_LOGGER.noHandlerForOperation(operationName, address));
                }
            }
            context.completeStep(OperationContext.ResultHandler.NOOP_RESULT_HANDLER);
        }
    }
}

