/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.util;

import io.smallrye.openapi.api.OpenApiConstants;
import io.smallrye.openapi.runtime.util.JandexUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TransferQueue;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.PrimitiveType;
import org.jboss.jandex.Type;
import org.jboss.jandex.WildcardType;

public class TypeUtil {
    private static final DotName DOTNAME_OBJECT = DotName.createSimple((String)Object.class.getName());
    private static final Type OBJECT_TYPE = Type.create((DotName)DOTNAME_OBJECT, (Type.Kind)Type.Kind.CLASS);
    private static final String UUID_PATTERN = "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}";
    private static final TypeWithFormat STRING_FORMAT = new TypeWithFormat(Schema.SchemaType.STRING, DataFormat.NONE);
    private static final TypeWithFormat BYTE_FORMAT = new TypeWithFormat(Schema.SchemaType.STRING, "byte");
    private static final TypeWithFormat CHAR_FORMAT = new TypeWithFormat(Schema.SchemaType.STRING, "byte");
    private static final TypeWithFormat UUID_FORMAT = new TypeWithFormat(Schema.SchemaType.STRING, "uuid", "[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}");
    private static final TypeWithFormat URI_FORMAT = new TypeWithFormat(Schema.SchemaType.STRING, "uri");
    private static final TypeWithFormat NUMBER_FORMAT = new TypeWithFormat(Schema.SchemaType.NUMBER, DataFormat.NONE);
    private static final TypeWithFormat BIGDECIMAL_FORMAT = new TypeWithFormat(Schema.SchemaType.NUMBER, DataFormat.NONE);
    private static final TypeWithFormat DOUBLE_FORMAT = new TypeWithFormat(Schema.SchemaType.NUMBER, "double");
    private static final TypeWithFormat FLOAT_FORMAT = new TypeWithFormat(Schema.SchemaType.NUMBER, "float");
    private static final TypeWithFormat BIGINTEGER_FORMAT = new TypeWithFormat(Schema.SchemaType.INTEGER, DataFormat.NONE);
    private static final TypeWithFormat INTEGER_FORMAT = new TypeWithFormat(Schema.SchemaType.INTEGER, "int32");
    private static final TypeWithFormat LONG_FORMAT = new TypeWithFormat(Schema.SchemaType.INTEGER, "int64");
    private static final TypeWithFormat SHORT_FORMAT = new TypeWithFormat(Schema.SchemaType.INTEGER, DataFormat.NONE);
    private static final TypeWithFormat BOOLEAN_FORMAT = new TypeWithFormat(Schema.SchemaType.BOOLEAN, DataFormat.NONE);
    private static final TypeWithFormat ARRAY_FORMAT = new TypeWithFormat(Schema.SchemaType.ARRAY, DataFormat.NONE);
    private static final TypeWithFormat OBJECT_FORMAT = new TypeWithFormat(Schema.SchemaType.OBJECT, DataFormat.NONE);
    private static final TypeWithFormat DATE_FORMAT = new TypeWithFormat(Schema.SchemaType.STRING, "date");
    private static final TypeWithFormat DATE_TIME_FORMAT = new TypeWithFormat(Schema.SchemaType.STRING, "date-time");
    private static final Map<DotName, TypeWithFormat> TYPE_MAP = new LinkedHashMap<DotName, TypeWithFormat>();
    private static final IndexView jdkIndex;

    private static void index(Indexer indexer, Class<?> klazz) {
        try (InputStream stream = klazz.getResourceAsStream(klazz.getSimpleName() + ".class");){
            indexer.index(stream);
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    private TypeUtil() {
    }

    private static TypeWithFormat getTypeFormat(Type type) {
        if (type.kind() == Type.Kind.ARRAY) {
            return TypeUtil.arrayFormat();
        }
        return TYPE_MAP.getOrDefault(TypeUtil.getName(type), TypeUtil.objectFormat());
    }

    public static boolean allowRegistration(IndexView index, Type classType) {
        TypeWithFormat typeFormat = TypeUtil.getTypeFormat(classType);
        switch (typeFormat.getSchemaType()) {
            case ARRAY: 
            case OBJECT: {
                return index.getClassByName(classType.name()) != null;
            }
        }
        return typeFormat.getProperties().size() > 2;
    }

    public static Map<String, Object> getTypeAttributes(Type classType) {
        return TypeUtil.getTypeFormat(classType).getProperties();
    }

    public static void applyTypeAttributes(Type classType, Schema schema) {
        TypeWithFormat attrs = TypeUtil.getTypeFormat(classType);
        schema.setType(attrs.getSchemaType());
        schema.setFormat(attrs.getFormat());
        schema.setPattern(attrs.getPattern());
    }

    public static void clearMatchingDefaultAttributes(Schema fieldSchema, Schema typeSchema) {
        if (Objects.equals(fieldSchema.getType(), typeSchema.getType())) {
            fieldSchema.setType(null);
        }
        if (Objects.equals(fieldSchema.getFormat(), typeSchema.getFormat())) {
            fieldSchema.setFormat(null);
        }
        if (Objects.equals(fieldSchema.getPattern(), typeSchema.getPattern())) {
            fieldSchema.setPattern(null);
        }
    }

    public static TypeWithFormat arrayFormat() {
        return ARRAY_FORMAT;
    }

    public static TypeWithFormat objectFormat() {
        return OBJECT_FORMAT;
    }

    static Class<?> getClass(DotName name) throws ClassNotFoundException {
        return Class.forName(name.toString(), true, Thread.currentThread().getContextClassLoader());
    }

    static boolean isAssignableFrom(DotName subject, DotName object) {
        try {
            Class<?> subjectKlazz = TypeUtil.getClass(subject);
            Class<?> objectKlazz = TypeUtil.getClass(object);
            return objectKlazz.isAssignableFrom(subjectKlazz);
        }
        catch (ClassNotFoundException nfe) {
            return false;
        }
    }

    static ClassInfo getClassInfo(IndexView appIndex, Type type) {
        DotName className = TypeUtil.getName(type);
        ClassInfo clazz = appIndex.getClassByName(className);
        if (clazz == null) {
            clazz = jdkIndex.getClassByName(className);
        }
        return clazz;
    }

    public static boolean isA(IndexView index, Type testSubject, Type testObject) {
        if (TypeUtil.getName(testSubject).equals((Object)TypeUtil.getName(testObject))) {
            return true;
        }
        if (testSubject.kind() == Type.Kind.PRIMITIVE && testObject.kind() != Type.Kind.PRIMITIVE) {
            return false;
        }
        ClassInfo subJandexKlazz = TypeUtil.getClassInfo(index, testSubject);
        if (subJandexKlazz != null) {
            return subJandexKlazz.interfaceNames().contains(TypeUtil.getName(testObject)) || TypeUtil.hasSuper(index, subJandexKlazz, testObject);
        }
        return TypeUtil.isAssignableFrom(testSubject.name(), testObject.name());
    }

    private static boolean hasSuper(IndexView index, ClassInfo testSubject, Type testObject) {
        Type superKlazzType = testSubject.superClassType();
        while (superKlazzType != null) {
            if (TypeUtil.getName(superKlazzType).equals((Object)TypeUtil.getName(testObject))) {
                return true;
            }
            if (DOTNAME_OBJECT.equals((Object)TypeUtil.getName(superKlazzType))) {
                return false;
            }
            ClassInfo superKlazz = TypeUtil.getClassInfo(index, superKlazzType);
            if (superKlazz != null) {
                if (superKlazz.interfaceNames().contains(TypeUtil.getName(testObject))) {
                    return true;
                }
            } else {
                return TypeUtil.isAssignableFrom(testSubject.name(), testObject.name());
            }
            superKlazzType = superKlazz.superClassType();
        }
        return false;
    }

    public static boolean isTerminalType(Type type) {
        if (type.kind() == Type.Kind.TYPE_VARIABLE || type.kind() == Type.Kind.WILDCARD_TYPE || type.kind() == Type.Kind.ARRAY) {
            return false;
        }
        if (type.kind() == Type.Kind.PRIMITIVE || type.kind() == Type.Kind.VOID) {
            return true;
        }
        TypeWithFormat tf = TypeUtil.getTypeFormat(type);
        return tf.getSchemaType() != Schema.SchemaType.OBJECT && tf.getSchemaType() != Schema.SchemaType.ARRAY;
    }

    public static boolean isOptional(Type type) {
        return type != null && OpenApiConstants.DOTNAME_OPTIONALS.contains(type.name());
    }

    public static Type getOptionalType(Type type) {
        if (type == null) {
            return null;
        }
        if (OpenApiConstants.DOTNAME_OPTIONAL.equals((Object)type.name())) {
            return (Type)type.asParameterizedType().arguments().get(0);
        }
        if (OpenApiConstants.DOTNAME_OPTIONAL_DOUBLE.equals((Object)type.name())) {
            return PrimitiveType.DOUBLE;
        }
        if (OpenApiConstants.DOTNAME_OPTIONAL_INT.equals((Object)type.name())) {
            return PrimitiveType.INT;
        }
        if (OpenApiConstants.DOTNAME_OPTIONAL_LONG.equals((Object)type.name())) {
            return PrimitiveType.LONG;
        }
        return null;
    }

    public static DotName getName(Type type) {
        if (type.kind() == Type.Kind.ARRAY) {
            return type.asArrayType().component().name();
        }
        if (type.kind() == Type.Kind.WILDCARD_TYPE) {
            return TypeUtil.getBound(type.asWildcardType()).name();
        }
        return type.name();
    }

    public static Type getBound(WildcardType wct) {
        if (wct.extendsBound() != null) {
            return wct.extendsBound();
        }
        return OBJECT_TYPE;
    }

    public static Type resolveWildcard(WildcardType wildcardType) {
        return TypeUtil.getBound(wildcardType);
    }

    public static Type resolveWildcard(Type type) {
        if (type.kind() != Type.Kind.WILDCARD_TYPE) {
            return type;
        }
        return TypeUtil.getBound(type.asWildcardType());
    }

    public static boolean equalTypes(Type type1, Type type2) {
        if (type1.name().equals((Object)type2.name())) {
            return true;
        }
        return TypeUtil.equalWrappedTypes(type1, type2) || TypeUtil.equalWrappedTypes(type2, type1);
    }

    public static boolean equalWrappedTypes(Type primitiveCandidate, Type wrappedCandidate) {
        return primitiveCandidate.kind().equals((Object)Type.Kind.PRIMITIVE) && wrappedCandidate.kind().equals((Object)Type.Kind.CLASS) && TypeUtil.isPrimitiveWrapper(primitiveCandidate.asPrimitiveType(), wrappedCandidate);
    }

    public static boolean isPrimitiveWrapper(PrimitiveType primitive, Type wrapped) {
        Class wrapperType;
        switch (primitive.primitive()) {
            case BOOLEAN: {
                wrapperType = Boolean.class;
                break;
            }
            case BYTE: {
                wrapperType = Byte.class;
                break;
            }
            case CHAR: {
                wrapperType = Character.class;
                break;
            }
            case DOUBLE: {
                wrapperType = Double.class;
                break;
            }
            case FLOAT: {
                wrapperType = Float.class;
                break;
            }
            case INT: {
                wrapperType = Integer.class;
                break;
            }
            case LONG: {
                wrapperType = Long.class;
                break;
            }
            case SHORT: {
                wrapperType = Short.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown primitive: " + primitive);
            }
        }
        return DotName.createSimple((String)wrapperType.getName()).equals((Object)wrapped.name());
    }

    public static AnnotationInstance getSchemaAnnotation(AnnotationTarget annotationTarget) {
        return TypeUtil.getAnnotation(annotationTarget, OpenApiConstants.DOTNAME_SCHEMA);
    }

    public static AnnotationInstance getSchemaAnnotation(ClassInfo field) {
        return TypeUtil.getAnnotation(field, OpenApiConstants.DOTNAME_SCHEMA);
    }

    public static AnnotationInstance getSchemaAnnotation(FieldInfo field) {
        return TypeUtil.getAnnotation(field, OpenApiConstants.DOTNAME_SCHEMA);
    }

    public static AnnotationInstance getSchemaAnnotation(Type type) {
        return TypeUtil.getAnnotation(type, OpenApiConstants.DOTNAME_SCHEMA);
    }

    public static boolean hasAnnotation(AnnotationTarget target, DotName annotationName) {
        if (target == null) {
            return false;
        }
        switch (target.kind()) {
            case CLASS: {
                return target.asClass().classAnnotation(annotationName) != null;
            }
            case FIELD: {
                return target.asField().hasAnnotation(annotationName);
            }
            case METHOD: {
                return target.asMethod().hasAnnotation(annotationName);
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = target.asMethodParameter();
                return parameter.method().annotations().stream().filter(a -> a.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).filter(a -> a.target().asMethodParameter().position() == parameter.position()).anyMatch(a -> a.name().equals((Object)annotationName));
            }
        }
        return false;
    }

    public static AnnotationInstance getAnnotation(AnnotationTarget annotationTarget, DotName annotationName) {
        if (annotationTarget == null) {
            return null;
        }
        return TypeUtil.getAnnotations(annotationTarget).stream().filter(annotation -> annotation.name().equals((Object)annotationName)).findFirst().orElse(null);
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, DotName annotationName) {
        return TypeUtil.getAnnotationValue(target, annotationName, "value", null);
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, DotName annotationName, String propertyName) {
        return TypeUtil.getAnnotationValue(target, annotationName, propertyName, null);
    }

    public static <T> T getAnnotationValue(AnnotationTarget target, DotName annotationName, String propertyName, T defaultValue) {
        AnnotationInstance annotation = TypeUtil.getAnnotation(target, annotationName);
        if (annotation != null) {
            return JandexUtil.value(annotation, propertyName);
        }
        return defaultValue;
    }

    public static Collection<AnnotationInstance> getAnnotations(AnnotationTarget type) {
        switch (type.kind()) {
            case CLASS: {
                return type.asClass().classAnnotations();
            }
            case FIELD: {
                return type.asField().annotations();
            }
            case METHOD: {
                return type.asMethod().annotations();
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = type.asMethodParameter();
                return parameter.method().annotations().stream().filter(a -> a.target().kind() == AnnotationTarget.Kind.METHOD_PARAMETER).filter(a -> a.target().asMethodParameter().position() == parameter.position()).collect(Collectors.toList());
            }
        }
        return Collections.emptyList();
    }

    public static ClassInfo getDeclaringClass(AnnotationTarget type) {
        switch (type.kind()) {
            case FIELD: {
                return type.asField().declaringClass();
            }
            case METHOD: {
                return type.asMethod().declaringClass();
            }
            case METHOD_PARAMETER: {
                MethodParameterInfo parameter = type.asMethodParameter();
                return parameter.method().declaringClass();
            }
        }
        return null;
    }

    public static AnnotationInstance getAnnotation(Type type, DotName annotationName) {
        return type.annotations().stream().filter(annotation -> annotation.name().equals((Object)annotationName)).findFirst().orElse(null);
    }

    public static AnnotationInstance getAnnotation(ClassInfo field, DotName annotationName) {
        return field.classAnnotations().stream().filter(annotation -> annotation.name().equals((Object)annotationName)).findFirst().orElse(null);
    }

    public static AnnotationInstance getAnnotation(FieldInfo field, DotName annotationName) {
        return field.annotations().stream().filter(annotation -> annotation.name().equals((Object)annotationName)).findFirst().orElse(null);
    }

    static {
        TYPE_MAP.put(DotName.createSimple((String)String.class.getName()), STRING_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)StringBuffer.class.getName()), STRING_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)StringBuilder.class.getName()), STRING_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)CharSequence.class.getName()), STRING_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)URI.class.getName()), URI_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)UUID.class.getName()), UUID_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Byte.class.getName()), BYTE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Byte.TYPE.getName()), BYTE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Character.class.getName()), CHAR_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Character.TYPE.getName()), CHAR_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Number.class.getName()), NUMBER_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)BigDecimal.class.getName()), BIGDECIMAL_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Double.class.getName()), DOUBLE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Double.TYPE.getName()), DOUBLE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Float.class.getName()), FLOAT_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Float.TYPE.getName()), FLOAT_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)BigInteger.class.getName()), BIGINTEGER_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Integer.class.getName()), INTEGER_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Integer.TYPE.getName()), INTEGER_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Long.class.getName()), LONG_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Long.TYPE.getName()), LONG_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Short.class.getName()), SHORT_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Short.TYPE.getName()), SHORT_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Boolean.class.getName()), BOOLEAN_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Boolean.TYPE.getName()), BOOLEAN_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)Date.class.getName()), DATE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)java.sql.Date.class.getName()), DATE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)LocalDate.class.getName()), DATE_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)LocalDateTime.class.getName()), DATE_TIME_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)ZonedDateTime.class.getName()), DATE_TIME_FORMAT);
        TYPE_MAP.put(DotName.createSimple((String)OffsetDateTime.class.getName()), DATE_TIME_FORMAT);
        Indexer indexer = new Indexer();
        TypeUtil.index(indexer, Enum.class);
        TypeUtil.index(indexer, Object.class);
        TypeUtil.index(indexer, Boolean.class);
        TypeUtil.index(indexer, Byte.class);
        TypeUtil.index(indexer, Character.class);
        TypeUtil.index(indexer, Double.class);
        TypeUtil.index(indexer, Float.class);
        TypeUtil.index(indexer, Integer.class);
        TypeUtil.index(indexer, Long.class);
        TypeUtil.index(indexer, Number.class);
        TypeUtil.index(indexer, Short.class);
        TypeUtil.index(indexer, String.class);
        TypeUtil.index(indexer, Void.class);
        TypeUtil.index(indexer, UUID.class);
        TypeUtil.index(indexer, Collection.class);
        TypeUtil.index(indexer, Deque.class);
        TypeUtil.index(indexer, List.class);
        TypeUtil.index(indexer, Map.class);
        TypeUtil.index(indexer, NavigableMap.class);
        TypeUtil.index(indexer, NavigableSet.class);
        TypeUtil.index(indexer, Queue.class);
        TypeUtil.index(indexer, Set.class);
        TypeUtil.index(indexer, SortedMap.class);
        TypeUtil.index(indexer, SortedSet.class);
        TypeUtil.index(indexer, BlockingDeque.class);
        TypeUtil.index(indexer, BlockingQueue.class);
        TypeUtil.index(indexer, ConcurrentMap.class);
        TypeUtil.index(indexer, ConcurrentNavigableMap.class);
        TypeUtil.index(indexer, TransferQueue.class);
        TypeUtil.index(indexer, AbstractCollection.class);
        TypeUtil.index(indexer, AbstractList.class);
        TypeUtil.index(indexer, AbstractMap.class);
        TypeUtil.index(indexer, AbstractQueue.class);
        TypeUtil.index(indexer, AbstractSequentialList.class);
        TypeUtil.index(indexer, AbstractSet.class);
        TypeUtil.index(indexer, EnumSet.class);
        TypeUtil.index(indexer, ArrayDeque.class);
        TypeUtil.index(indexer, ArrayList.class);
        TypeUtil.index(indexer, EnumMap.class);
        TypeUtil.index(indexer, HashMap.class);
        TypeUtil.index(indexer, HashSet.class);
        TypeUtil.index(indexer, Hashtable.class);
        TypeUtil.index(indexer, IdentityHashMap.class);
        TypeUtil.index(indexer, LinkedHashMap.class);
        TypeUtil.index(indexer, LinkedHashSet.class);
        TypeUtil.index(indexer, LinkedList.class);
        TypeUtil.index(indexer, PriorityQueue.class);
        TypeUtil.index(indexer, Properties.class);
        TypeUtil.index(indexer, Stack.class);
        TypeUtil.index(indexer, TreeMap.class);
        TypeUtil.index(indexer, TreeSet.class);
        TypeUtil.index(indexer, Vector.class);
        TypeUtil.index(indexer, ArrayBlockingQueue.class);
        TypeUtil.index(indexer, ConcurrentHashMap.class);
        TypeUtil.index(indexer, ConcurrentLinkedDeque.class);
        TypeUtil.index(indexer, ConcurrentLinkedQueue.class);
        TypeUtil.index(indexer, ConcurrentSkipListMap.class);
        TypeUtil.index(indexer, ConcurrentSkipListSet.class);
        TypeUtil.index(indexer, CopyOnWriteArrayList.class);
        TypeUtil.index(indexer, CopyOnWriteArraySet.class);
        TypeUtil.index(indexer, DelayQueue.class);
        TypeUtil.index(indexer, LinkedBlockingDeque.class);
        TypeUtil.index(indexer, LinkedBlockingQueue.class);
        TypeUtil.index(indexer, LinkedTransferQueue.class);
        TypeUtil.index(indexer, PriorityBlockingQueue.class);
        TypeUtil.index(indexer, SynchronousQueue.class);
        jdkIndex = indexer.complete();
    }

    private static class DataFormat {
        static final String NONE = null;
        static final String INT32 = "int32";
        static final String INT64 = "int64";
        static final String FLOAT = "float";
        static final String DOUBLE = "double";
        static final String BYTE = "byte";
        static final String DATE = "date";
        static final String DATE_TIME = "date-time";
        static final String URI = "uri";
        static final String UUID = "uuid";

        private DataFormat() {
        }
    }

    static final class TypeWithFormat {
        private final Map<String, Object> properties;

        public TypeWithFormat(@NotNull Schema.SchemaType schemaType, @NotNull String format) {
            this(schemaType, format, null);
        }

        public TypeWithFormat(@NotNull Schema.SchemaType schemaType, @NotNull String format, String pattern) {
            HashMap<String, Object> props = new HashMap<String, Object>(3);
            props.put("type", schemaType);
            props.put("format", format);
            if (pattern != null) {
                props.put("pattern", pattern);
            }
            this.properties = Collections.unmodifiableMap(props);
        }

        Schema.SchemaType getSchemaType() {
            return (Schema.SchemaType)this.properties.get("type");
        }

        String getFormat() {
            return (String)this.properties.get("format");
        }

        String getPattern() {
            return (String)this.properties.get("pattern");
        }

        Map<String, Object> getProperties() {
            return this.properties;
        }
    }
}

