/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.subsystem;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.ejb3.cache.CacheFactoryBuilderServiceNameProvider;
import org.jboss.as.ejb3.cache.distributable.DistributableCacheFactoryBuilderServiceNameProvider;
import org.jboss.as.ejb3.cache.simple.SimpleCacheFactoryBuilderServiceConfigurator;
import org.jboss.as.ejb3.subsystem.CacheFactoryResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.IdentityServiceConfigurator;

public class CacheFactoryAdd
extends AbstractAddStepHandler {
    private final AttributeDefinition[] attributes;

    CacheFactoryAdd(AttributeDefinition ... attributes) {
        this.attributes = attributes;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : this.attributes) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String name = PathAddress.pathAddress((ModelNode)operation.get("address")).getLastElement().getValue();
        ModelNode passivationStoreModel = CacheFactoryResourceDefinition.PASSIVATION_STORE.resolveModelAttribute(context, model);
        String passivationStore = passivationStoreModel.isDefined() ? passivationStoreModel.asString() : null;
        List unwrappedAliasValues = CacheFactoryResourceDefinition.ALIASES.unwrap((ExpressionResolver)context, model);
        HashSet aliases = unwrappedAliasValues != null ? new HashSet(unwrappedAliasValues) : Collections.emptySet();
        ServiceTarget target = context.getServiceTarget();
        Object configurator = passivationStore != null ? new IdentityServiceConfigurator(new CacheFactoryBuilderServiceNameProvider(name).getServiceName(), new DistributableCacheFactoryBuilderServiceNameProvider(passivationStore).getServiceName()) : new SimpleCacheFactoryBuilderServiceConfigurator(name);
        ServiceBuilder builder = configurator.build(target);
        for (String alias : aliases) {
            new IdentityServiceConfigurator(new CacheFactoryBuilderServiceNameProvider(alias).getServiceName(), configurator.getServiceName()).build(target).install();
        }
        builder.install();
    }
}

