/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.near;

import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryExpired;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryModified;
import org.infinispan.client.hotrod.annotation.ClientCacheEntryRemoved;
import org.infinispan.client.hotrod.annotation.ClientCacheFailover;
import org.infinispan.client.hotrod.annotation.ClientListener;
import org.infinispan.client.hotrod.configuration.NearCacheConfiguration;
import org.infinispan.client.hotrod.event.ClientCacheEntryExpiredEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryModifiedEvent;
import org.infinispan.client.hotrod.event.ClientCacheEntryRemovedEvent;
import org.infinispan.client.hotrod.event.ClientCacheFailoverEvent;
import org.infinispan.client.hotrod.event.impl.ClientListenerNotifier;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.client.hotrod.near.BoundedConcurrentMapNearCache;
import org.infinispan.client.hotrod.near.ConcurrentMapNearCache;
import org.infinispan.client.hotrod.near.NearCache;
import org.infinispan.commons.util.Util;

public class NearCacheService<K, V>
implements NearCache<K, V> {
    private static final Log log = LogFactory.getLog(NearCacheService.class);
    private static final boolean trace = log.isTraceEnabled();
    private final NearCacheConfiguration config;
    private final ClientListenerNotifier listenerNotifier;
    private Object listener;
    private byte[] listenerId;
    private NearCache<K, V> cache;
    private Runnable invalidationCallback;

    protected NearCacheService(NearCacheConfiguration config, ClientListenerNotifier listenerNotifier) {
        this.config = config;
        this.listenerNotifier = listenerNotifier;
    }

    public void start(RemoteCache<K, V> remote) {
        if (this.cache == null) {
            this.cache = this.createNearCache(this.config);
            this.listener = new InvalidatedNearCacheListener(this);
            remote.addClientListener(this.listener);
            this.listenerId = this.listenerNotifier.findListenerId(this.listener);
        }
    }

    public void stop(RemoteCache<K, V> remote) {
        if (trace) {
            log.tracef("Stop near cache, remove underlying listener id %s", Util.printArray((byte[])this.listenerId));
        }
        remote.removeClientListener(this.listener);
        this.cache.clear();
    }

    protected NearCache<K, V> createNearCache(NearCacheConfiguration config) {
        return config.maxEntries() > 0 ? BoundedConcurrentMapNearCache.create(config) : ConcurrentMapNearCache.create();
    }

    public static <K, V> NearCacheService<K, V> create(NearCacheConfiguration config, ClientListenerNotifier listenerNotifier) {
        return new NearCacheService<K, V>(config, listenerNotifier);
    }

    @Override
    public void put(K key, MetadataValue<V> value) {
        this.cache.put(key, value);
        if (trace) {
            log.tracef("Put key=%s and value=%s in near cache (listenerId=%s)", key, value, Util.printArray((byte[])this.listenerId));
        }
    }

    @Override
    public void putIfAbsent(K key, MetadataValue<V> value) {
        this.cache.putIfAbsent(key, value);
        if (trace) {
            log.tracef("Conditionally put key=%s and value=%s if absent in near cache (listenerId=%s)", key, value, Util.printArray((byte[])this.listenerId));
        }
    }

    @Override
    public boolean remove(K key) {
        boolean removed = this.cache.remove(key);
        if (removed && this.invalidationCallback != null) {
            this.invalidationCallback.run();
        }
        if (trace) {
            log.tracef("Removed key=%s from near cache (listenedId=%s)", key, Util.printArray((byte[])this.listenerId));
        }
        return removed;
    }

    @Override
    public MetadataValue<V> get(K key) {
        boolean listenerConnected = this.isConnected();
        if (listenerConnected) {
            MetadataValue<V> value = this.cache.get(key);
            if (trace) {
                log.tracef("Get key=%s returns value=%s (listenerId=%s)", key, value, Util.printArray((byte[])this.listenerId));
            }
            return value;
        }
        if (trace) {
            log.tracef("Near cache disconnected from server, returning null for key=%s (listenedId=%s)", key, Util.printArray((byte[])this.listenerId));
        }
        return null;
    }

    @Override
    public void clear() {
        this.cache.clear();
        if (trace) {
            log.tracef("Cleared near cache (listenerId=%s)", Util.printArray((byte[])this.listenerId));
        }
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    private boolean isConnected() {
        return this.listenerNotifier.isListenerConnected(this.listenerId);
    }

    public void setInvalidationCallback(Runnable r) {
        this.invalidationCallback = r;
    }

    @ClientListener
    private static class InvalidatedNearCacheListener<K, V> {
        private static final Log log = LogFactory.getLog(InvalidatedNearCacheListener.class);
        private final NearCache<K, V> cache;

        private InvalidatedNearCacheListener(NearCache<K, V> cache) {
            this.cache = cache;
        }

        @ClientCacheEntryModified
        public void handleModifiedEvent(ClientCacheEntryModifiedEvent<K> event) {
            this.invalidate(event.getKey());
        }

        @ClientCacheEntryRemoved
        public void handleRemovedEvent(ClientCacheEntryRemovedEvent<K> event) {
            this.invalidate(event.getKey());
        }

        @ClientCacheEntryExpired
        public void handleExpiredEvent(ClientCacheEntryExpiredEvent<K> event) {
            this.invalidate(event.getKey());
        }

        @ClientCacheFailover
        public void handleFailover(ClientCacheFailoverEvent e) {
            if (trace) {
                log.trace("Clear near cache after fail-over of server");
            }
            this.cache.clear();
        }

        private void invalidate(K key) {
            this.cache.remove(key);
        }
    }
}

