/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.util.introspection;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.velocity.util.introspection.Converter;
import org.apache.velocity.util.introspection.IntrospectionUtils;
import org.apache.velocity.util.introspection.TypeConversionHandler;

public class TypeConversionHandlerImpl
implements TypeConversionHandler {
    static Map<Pair<String, String>, Converter> standardConverterMap = new HashMap<Pair<String, String>, Converter>();
    static Converter toString;
    static Converter cacheMiss;
    static final long minByte = -128L;
    static final long maxByte = 127L;
    static final long minShort = -32768L;
    static final long maxShort = 32767L;
    static final long minInt = Integer.MIN_VALUE;
    static final long maxInt = Integer.MAX_VALUE;
    static final double minLong = -9.223372036854776E18;
    static final double maxLong = 9.223372036854776E18;
    Map<Pair<String, String>, Converter> converterCacheMap = new ConcurrentHashMap<Pair<String, String>, Converter>();
    static final String BOOLEAN_TYPE = "boolean";
    static final String BYTE_TYPE = "byte";
    static final String SHORT_TYPE = "short";
    static final String INTEGER_TYPE = "int";
    static final String LONG_TYPE = "long";
    static final String FLOAT_TYPE = "float";
    static final String DOUBLE_TYPE = "double";
    static final String CHARACTER_TYPE = "char";
    static final String BOOLEAN_CLASS = "java.lang.Boolean";
    static final String BYTE_CLASS = "java.lang.Byte";
    static final String SHORT_CLASS = "java.lang.Short";
    static final String INTEGER_CLASS = "java.lang.Integer";
    static final String LONG_CLASS = "java.lang.Long";
    static final String FLOAT_CLASS = "java.lang.Float";
    static final String DOUBLE_CLASS = "java.lang.Double";
    static final String NUMBER_CLASS = "java.lang.Number";
    static final String CHARACTER_CLASS = "java.lang.Character";
    static final String STRING_CLASS = "java.lang.String";
    static final String LOCALE_CLASS = "java.util.Locale";

    @Override
    public boolean isExplicitlyConvertible(Type formal, Class actual, boolean possibleVarArg) {
        Class formalClass = IntrospectionUtils.getTypeClass(formal);
        if (formalClass != null && formalClass == actual || IntrospectionUtils.isMethodInvocationConvertible(formal, actual, possibleVarArg) || this.getNeededConverter(formal, actual) != null) {
            return true;
        }
        if (possibleVarArg && TypeUtils.isArrayType((Type)formal)) {
            if (actual.isArray()) {
                actual = actual.getComponentType();
            }
            return this.isExplicitlyConvertible(TypeUtils.getArrayComponentType((Type)formal), actual, false);
        }
        return false;
    }

    @Override
    public Converter getNeededConverter(Type formal, Class actual) {
        if (actual == null) {
            return null;
        }
        Pair key = Pair.of((Object)formal.getTypeName(), (Object)actual.getTypeName());
        Converter converter = standardConverterMap.get(key);
        if (converter == null && (converter = this.converterCacheMap.get(key)) == null) {
            Class formalClass = IntrospectionUtils.getTypeClass(formal);
            if (formal == String.class) {
                converter = toString;
            } else if (formalClass != null && formalClass.isEnum() && actual == String.class) {
                final Class enumClass = formalClass;
                converter = new Converter(){

                    public Object convert(Object o) {
                        return Enum.valueOf(enumClass, (String)o);
                    }
                };
            }
            this.converterCacheMap.put((Pair<String, String>)key, converter == null ? cacheMiss : converter);
        }
        return converter == cacheMiss ? null : converter;
    }

    @Override
    public void addConverter(Type formal, Class actual, Converter converter) {
        Pair key = Pair.of((Object)formal.getTypeName(), (Object)actual.getTypeName());
        this.converterCacheMap.put((Pair<String, String>)key, converter);
        Class formalClass = IntrospectionUtils.getTypeClass(formal);
        if (formalClass != null) {
            if (formalClass.isPrimitive()) {
                key = Pair.of((Object)IntrospectionUtils.getBoxedClass(formalClass).getTypeName(), (Object)actual.getTypeName());
                this.converterCacheMap.put((Pair<String, String>)key, converter);
            } else {
                Class unboxedFormal = IntrospectionUtils.getUnboxedClass(formalClass);
                if (unboxedFormal != formalClass) {
                    key = Pair.of((Object)unboxedFormal.getTypeName(), (Object)actual.getTypeName());
                    this.converterCacheMap.put((Pair<String, String>)key, converter);
                }
            }
        }
    }

    static {
        cacheMiss = new Converter<Object>(){

            @Override
            public Object convert(Object o) {
                return o;
            }
        };
        Converter<Boolean> numberToBool = new Converter<Boolean>(){

            @Override
            public Boolean convert(Object o) {
                return o == null ? null : Boolean.valueOf(((Number)o).intValue() != 0);
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)BYTE_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)SHORT_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)INTEGER_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)LONG_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)FLOAT_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)DOUBLE_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)NUMBER_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)BYTE_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)SHORT_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)INTEGER_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)LONG_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)FLOAT_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)DOUBLE_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)BYTE_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)SHORT_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)INTEGER_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)LONG_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)FLOAT_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)DOUBLE_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)NUMBER_CLASS), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)BYTE_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)SHORT_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)INTEGER_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)LONG_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)FLOAT_TYPE), numberToBool);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)DOUBLE_TYPE), numberToBool);
        Converter<Boolean> charToBoolean = new Converter<Boolean>(){

            @Override
            public Boolean convert(Object o) {
                return o == null ? null : Boolean.valueOf(((Character)o).charValue() != '\u0000');
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)CHARACTER_CLASS), charToBoolean);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)CHARACTER_TYPE), charToBoolean);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)CHARACTER_CLASS), charToBoolean);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)CHARACTER_TYPE), charToBoolean);
        Converter<Boolean> stringToBoolean = new Converter<Boolean>(){

            @Override
            public Boolean convert(Object o) {
                return Boolean.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_CLASS, (Object)STRING_CLASS), stringToBoolean);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BOOLEAN_TYPE, (Object)STRING_CLASS), stringToBoolean);
        Converter<Byte> narrowingToByte = new Converter<Byte>(){

            @Override
            public Byte convert(Object o) {
                if (o == null) {
                    return null;
                }
                long l = ((Number)o).longValue();
                if (l < -128L || l > 127L) {
                    throw new NumberFormatException("value out of range for byte type: " + l);
                }
                return ((Number)o).byteValue();
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)SHORT_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)INTEGER_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)LONG_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)FLOAT_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)DOUBLE_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)NUMBER_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)SHORT_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)INTEGER_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)LONG_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)FLOAT_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)DOUBLE_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)SHORT_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)INTEGER_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)LONG_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)FLOAT_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)DOUBLE_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)NUMBER_CLASS), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)SHORT_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)INTEGER_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)LONG_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)FLOAT_TYPE), narrowingToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)DOUBLE_TYPE), narrowingToByte);
        Converter<Byte> stringToByte = new Converter<Byte>(){

            @Override
            public Byte convert(Object o) {
                return Byte.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)STRING_CLASS), stringToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)STRING_CLASS), stringToByte);
        Converter<Short> narrowingToShort = new Converter<Short>(){

            @Override
            public Short convert(Object o) {
                if (o == null) {
                    return null;
                }
                long l = ((Number)o).longValue();
                if (l < -32768L || l > 32767L) {
                    throw new NumberFormatException("value out of range for short type: " + l);
                }
                return ((Number)o).shortValue();
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)INTEGER_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)LONG_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)FLOAT_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)DOUBLE_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)NUMBER_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)INTEGER_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)LONG_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)FLOAT_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)DOUBLE_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)INTEGER_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)LONG_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)FLOAT_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)DOUBLE_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)NUMBER_CLASS), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)INTEGER_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)LONG_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)FLOAT_TYPE), narrowingToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)DOUBLE_TYPE), narrowingToShort);
        Converter<Short> stringToShort = new Converter<Short>(){

            @Override
            public Short convert(Object o) {
                return Short.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)STRING_CLASS), stringToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)STRING_CLASS), stringToShort);
        Converter<Integer> narrowingToInteger = new Converter<Integer>(){

            @Override
            public Integer convert(Object o) {
                if (o == null) {
                    return null;
                }
                long l = ((Number)o).longValue();
                if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
                    throw new NumberFormatException("value out of range for integer type: " + l);
                }
                return ((Number)o).intValue();
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)LONG_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)FLOAT_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)DOUBLE_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)NUMBER_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)LONG_TYPE), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)FLOAT_TYPE), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)DOUBLE_TYPE), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)LONG_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)FLOAT_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)DOUBLE_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)NUMBER_CLASS), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)LONG_TYPE), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)FLOAT_TYPE), narrowingToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)DOUBLE_TYPE), narrowingToInteger);
        Converter<Integer> wideningToInteger = new Converter<Integer>(){

            @Override
            public Integer convert(Object o) {
                if (o == null) {
                    return null;
                }
                return ((Number)o).intValue();
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)SHORT_CLASS), wideningToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)SHORT_TYPE), wideningToInteger);
        Converter<Integer> stringToInteger = new Converter<Integer>(){

            @Override
            public Integer convert(Object o) {
                return Integer.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)STRING_CLASS), stringToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)STRING_CLASS), stringToInteger);
        Converter<Long> narrowingToLong = new Converter<Long>(){

            @Override
            public Long convert(Object o) {
                if (o == null) {
                    return null;
                }
                double d = ((Number)o).doubleValue();
                if (d < -9.223372036854776E18 || d > 9.223372036854776E18) {
                    throw new NumberFormatException("value out of range for long type: " + d);
                }
                return ((Number)o).longValue();
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)FLOAT_CLASS), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)DOUBLE_CLASS), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)NUMBER_CLASS), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)FLOAT_TYPE), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)DOUBLE_TYPE), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)FLOAT_CLASS), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)DOUBLE_CLASS), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)NUMBER_CLASS), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)FLOAT_TYPE), narrowingToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)DOUBLE_TYPE), narrowingToLong);
        Converter<Long> wideningToLong = new Converter<Long>(){

            @Override
            public Long convert(Object o) {
                if (o == null) {
                    return null;
                }
                return ((Number)o).longValue();
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)SHORT_CLASS), wideningToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)INTEGER_CLASS), wideningToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)SHORT_TYPE), wideningToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)INTEGER_TYPE), wideningToLong);
        Converter<Long> stringToLong = new Converter<Long>(){

            @Override
            public Long convert(Object o) {
                return Long.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)STRING_CLASS), stringToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)STRING_CLASS), stringToLong);
        Converter<Float> narrowingToFloat = new Converter<Float>(){

            @Override
            public Float convert(Object o) {
                return o == null ? null : Float.valueOf(((Number)o).floatValue());
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)DOUBLE_CLASS), narrowingToFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)NUMBER_CLASS), narrowingToFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)DOUBLE_TYPE), narrowingToFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_TYPE, (Object)DOUBLE_CLASS), narrowingToFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_TYPE, (Object)NUMBER_CLASS), narrowingToFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_TYPE, (Object)DOUBLE_TYPE), narrowingToFloat);
        Converter<Float> toFloat = new Converter<Float>(){

            @Override
            public Float convert(Object o) {
                if (o == null) {
                    return null;
                }
                return Float.valueOf(((Number)o).floatValue());
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)SHORT_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)INTEGER_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)LONG_CLASS), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)SHORT_TYPE), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)INTEGER_TYPE), toFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)LONG_TYPE), toFloat);
        Converter<Float> stringToFloat = new Converter<Float>(){

            @Override
            public Float convert(Object o) {
                return Float.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_CLASS, (Object)STRING_CLASS), stringToFloat);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)FLOAT_TYPE, (Object)STRING_CLASS), stringToFloat);
        Converter<Double> toDouble = new Converter<Double>(){

            @Override
            public Double convert(Object o) {
                if (o == null) {
                    return null;
                }
                return ((Number)o).doubleValue();
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)SHORT_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)INTEGER_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)LONG_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)FLOAT_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)NUMBER_CLASS), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)SHORT_TYPE), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)INTEGER_TYPE), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)LONG_TYPE), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)FLOAT_TYPE), toDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_TYPE, (Object)NUMBER_CLASS), toDouble);
        Converter<Double> stringToDouble = new Converter<Double>(){

            @Override
            public Double convert(Object o) {
                return Double.valueOf(String.valueOf(o));
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_CLASS, (Object)STRING_CLASS), stringToDouble);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)DOUBLE_TYPE, (Object)STRING_CLASS), stringToDouble);
        Converter<Byte> booleanToByte = new Converter<Byte>(){

            @Override
            public Byte convert(Object o) {
                return o == null ? null : Byte.valueOf((Boolean)o != false ? (byte)1 : 0);
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)BOOLEAN_CLASS), booleanToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_CLASS, (Object)BOOLEAN_TYPE), booleanToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)BOOLEAN_CLASS), booleanToByte);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)BYTE_TYPE, (Object)BOOLEAN_TYPE), booleanToByte);
        Converter<Short> booleanToShort = new Converter<Short>(){

            @Override
            public Short convert(Object o) {
                return o == null ? null : Short.valueOf((Boolean)o != false ? (short)1 : 0);
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)BOOLEAN_CLASS), booleanToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_CLASS, (Object)BOOLEAN_TYPE), booleanToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)BOOLEAN_CLASS), booleanToShort);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)SHORT_TYPE, (Object)BOOLEAN_TYPE), booleanToShort);
        Converter<Integer> booleanToInteger = new Converter<Integer>(){

            @Override
            public Integer convert(Object o) {
                return o == null ? null : ((Boolean)o != false ? Integer.valueOf(1) : Integer.valueOf(0));
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)BOOLEAN_CLASS), booleanToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_CLASS, (Object)BOOLEAN_TYPE), booleanToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)BOOLEAN_CLASS), booleanToInteger);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)INTEGER_TYPE, (Object)BOOLEAN_TYPE), booleanToInteger);
        Converter<Long> booleanToLong = new Converter<Long>(){

            @Override
            public Long convert(Object o) {
                return o == null ? null : Long.valueOf((Boolean)o != false ? 1L : 0L);
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)BOOLEAN_CLASS), booleanToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_CLASS, (Object)BOOLEAN_TYPE), booleanToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)BOOLEAN_CLASS), booleanToLong);
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LONG_TYPE, (Object)BOOLEAN_TYPE), booleanToLong);
        toString = new Converter<String>(){

            @Override
            public String convert(Object o) {
                return String.valueOf(o);
            }
        };
        Converter<Locale> stringToLocale = new Converter<Locale>(){

            @Override
            public Locale convert(Object o) {
                return o == null ? null : LocaleUtils.toLocale((String)((String)o));
            }
        };
        standardConverterMap.put((Pair<String, String>)Pair.of((Object)LOCALE_CLASS, (Object)STRING_CLASS), stringToLocale);
    }
}

