/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.group;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.function.Consumers;
import org.jboss.as.clustering.function.Functions;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.Address;
import org.wildfly.clustering.infinispan.spi.InfinispanCacheRequirement;
import org.wildfly.clustering.server.group.CacheGroup;
import org.wildfly.clustering.server.group.CacheGroupConfiguration;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleServiceNameProvider;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.clustering.spi.ClusteringRequirement;
import org.wildfly.clustering.spi.NodeFactory;

public class CacheGroupServiceConfigurator
extends SimpleServiceNameProvider
implements CapabilityServiceConfigurator,
CacheGroupConfiguration,
Supplier<CacheGroup> {
    private final String containerName;
    private final String cacheName;
    private volatile SupplierDependency<Cache<?, ?>> cache;
    private volatile SupplierDependency<NodeFactory<Address>> factory;

    public CacheGroupServiceConfigurator(ServiceName name, String containerName, String cacheName) {
        super(name);
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public CacheGroup get() {
        return new CacheGroup(this);
    }

    public ServiceConfigurator configure(CapabilityServiceSupport support) {
        this.cache = new ServiceSupplierDependency(InfinispanCacheRequirement.CACHE.getServiceName(support, this.containerName, this.cacheName));
        this.factory = new ServiceSupplierDependency(ClusteringRequirement.GROUP.getServiceName(support, this.containerName));
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer group = new CompositeDependency(new Dependency[]{this.cache, this.factory}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(group, Functions.identity(), (Supplier)this, Consumers.close());
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    @Override
    public Cache<?, ?> getCache() {
        return (Cache)this.cache.get();
    }

    @Override
    public NodeFactory<Address> getMemberFactory() {
        return (NodeFactory)this.factory.get();
    }
}

