/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.spi.util;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.function.Function;
import org.wildfly.clustering.marshalling.spi.util.MapExternalizer;

public class LinkedHashMapExternalizer
extends MapExternalizer<LinkedHashMap<Object, Object>, Boolean> {
    public LinkedHashMapExternalizer() {
        super(LinkedHashMap.class, new Function<Boolean, LinkedHashMap<Object, Object>>(){

            @Override
            public LinkedHashMap<Object, Object> apply(Boolean accessOrder) {
                return new LinkedHashMap<Object, Object>(16, 0.75f, accessOrder);
            }
        });
    }

    @Override
    protected void writeContext(ObjectOutput output, LinkedHashMap<Object, Object> map) throws IOException {
        Object insertOrder = new Object();
        Object accessOrder = new Object();
        map.put(insertOrder, null);
        map.put(accessOrder, null);
        map.get(insertOrder);
        Iterator<Object> keys = map.keySet().iterator();
        Object element = keys.next();
        while (element != insertOrder && element != accessOrder) {
            element = keys.next();
        }
        map.remove(insertOrder);
        map.remove(accessOrder);
        output.writeBoolean(element == accessOrder);
    }

    @Override
    protected Boolean readContext(ObjectInput input) throws IOException {
        return input.readBoolean();
    }
}

