/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSessionContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.DelegatingResource;
import org.jboss.as.controller.registry.PlaceholderResource;
import org.jboss.as.controller.registry.Resource;
import org.jboss.msc.service.ServiceController;
import org.wildfly.common.iteration.ByteIterator;

class SSLContextResource
extends DelegatingResource {
    private ServiceController<SSLContext> sslContextServiceController;
    private boolean server;

    SSLContextResource(Resource delegate, boolean server) {
        super(delegate);
        this.server = server;
    }

    void setSSLContextServiceController(ServiceController<SSLContext> sslContextServiceController) {
        this.sslContextServiceController = sslContextServiceController;
    }

    public Set<String> getChildTypes() {
        if (this.hasActiveSessions()) {
            return Collections.singleton("ssl-session");
        }
        return Collections.emptySet();
    }

    public boolean hasChildren(String childType) {
        return "ssl-session".equals(childType) && this.hasActiveSessions();
    }

    public boolean hasChild(PathElement element) {
        SSLContext sslContext;
        if ("ssl-session".equals(element.getKey()) && (sslContext = SSLContextResource.getSSLContext(this.sslContextServiceController)) != null) {
            byte[] sessionId = ByteIterator.ofBytes((byte[])element.getValue().getBytes(StandardCharsets.UTF_8)).asUtf8String().hexDecode().drain();
            SSLSessionContext sslSessionContext = this.server ? sslContext.getServerSessionContext() : sslContext.getClientSessionContext();
            return sslSessionContext.getSession(sessionId) != null;
        }
        return false;
    }

    public Resource getChild(PathElement element) {
        return this.hasChild(element) ? PlaceholderResource.INSTANCE : null;
    }

    public Resource requireChild(PathElement element) {
        Resource resource = this.getChild(element);
        if (resource == null) {
            throw new Resource.NoSuchResourceException(element);
        }
        return resource;
    }

    public Set<String> getChildrenNames(String childType) {
        SSLContext sslContext;
        if ("ssl-session".equals(childType) && (sslContext = SSLContextResource.getSSLContext(this.sslContextServiceController)) != null) {
            SSLSessionContext sslSessionContext = this.server ? sslContext.getServerSessionContext() : sslContext.getClientSessionContext();
            HashSet<String> set = new HashSet<String>();
            for (byte[] b : Collections.list(sslSessionContext.getIds())) {
                String s = ByteIterator.ofBytes((byte[])b).hexEncode(true).drainToString();
                set.add(s);
            }
            return set;
        }
        return Collections.emptySet();
    }

    public Set<Resource.ResourceEntry> getChildren(String childType) {
        HashSet<Resource.ResourceEntry> set = new HashSet<Resource.ResourceEntry>();
        for (String s : this.getChildrenNames(childType)) {
            PlaceholderResource.PlaceholderResourceEntry placeholderResourceEntry = new PlaceholderResource.PlaceholderResourceEntry("ssl-session", s);
            set.add((Resource.ResourceEntry)placeholderResourceEntry);
        }
        return set;
    }

    public Resource navigate(PathAddress address) {
        return Resource.Tools.navigate((Resource)this, (PathAddress)address);
    }

    public Resource clone() {
        SSLContextResource sslContextResource = new SSLContextResource(super.clone(), this.server);
        sslContextResource.setSSLContextServiceController(this.sslContextServiceController);
        return sslContextResource;
    }

    private boolean hasActiveSessions() {
        SSLContext sslContext = SSLContextResource.getSSLContext(this.sslContextServiceController);
        if (sslContext == null) {
            return false;
        }
        SSLSessionContext sslSessionContext = this.server ? sslContext.getServerSessionContext() : sslContext.getClientSessionContext();
        return sslSessionContext.getIds().hasMoreElements();
    }

    static SSLContext getSSLContext(ServiceController<SSLContext> sslContextServiceController) {
        if (sslContextServiceController == null || sslContextServiceController.getState() != ServiceController.State.UP) {
            return null;
        }
        return (SSLContext)sslContextServiceController.getValue();
    }
}

