/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.remote.upgrade;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.infinispan.Cache;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.ConcurrentHashSet;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.context.Flag;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.threads.DefaultThreadFactory;
import org.infinispan.metadata.EmbeddedMetadata;
import org.infinispan.metadata.Metadata;
import org.infinispan.metadata.impl.InternalMetadataImpl;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryRemovedEvent;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.logging.Log;
import org.infinispan.persistence.remote.upgrade.HotRodMigratorHelper;
import org.infinispan.persistence.remote.upgrade.MigrationMarshaller;
import org.infinispan.persistence.remote.upgrade.RemovedFilter;
import org.infinispan.util.logging.LogFactory;

public class MigrationTask
implements DistributedCallable<Object, Object, Integer> {
    private static final Log log = (Log)LogFactory.getLog(MigrationTask.class, Log.class);
    private static final String THREAD_NAME = "RollingUpgrade-MigrationTask";
    private final Set<Integer> segments;
    private final int readBatch;
    private final int threads;
    private final ConcurrentHashSet<WrappedByteArray> deletedKeys = new ConcurrentHashSet();
    private byte[] ignoredKey;
    private transient Set<RemoteStore> stores;
    private transient Cache<Object, Object> cache;
    private transient ExecutorService executorService;
    private final transient RemoveListener listener = new RemoveListener();

    public MigrationTask(Set<Integer> segments, int readBatch, int threads) {
        this.segments = segments;
        this.readBatch = readBatch;
        this.threads = threads;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer call() throws Exception {
        try {
            Iterator<RemoteStore> storeIterator = this.stores.iterator();
            if (storeIterator.hasNext()) {
                RemoteStore store = storeIterator.next();
                RemoteCache<Object, Object> storeCache = store.getRemoteCache();
                RemoteStoreConfiguration storeConfig = store.getConfiguration();
                if (!storeConfig.hotRodWrapping()) {
                    throw log.remoteStoreNoHotRodWrapping(this.cache.getName());
                }
                AtomicInteger counter = new AtomicInteger(0);
                this.migrateEntriesWithMetadata(storeCache, counter);
                HotRodMigratorHelper.awaitTermination(this.executorService);
                Integer n = counter.intValue();
                return n;
            }
            Integer n = null;
            return n;
        }
        finally {
            this.cache.removeListener((Object)this.listener);
            if (this.executorService != null) {
                this.executorService.shutdownNow();
            }
        }
    }

    private void migrateEntriesWithMetadata(RemoteCache<Object, Object> sourceCache, AtomicInteger counter) {
        try (CloseableIterator iterator = sourceCache.retrieveEntriesWithMetadata(this.segments, this.readBatch);){
            while (iterator.hasNext() && !Thread.currentThread().isInterrupted()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                if (Arrays.equals((byte[])entry.getKey(), this.ignoredKey)) continue;
                MetadataValue metadataValue = (MetadataValue)entry.getValue();
                int lifespan = metadataValue.getLifespan();
                int maxIdle = metadataValue.getMaxIdle();
                long version = metadataValue.getVersion();
                long created = metadataValue.getCreated();
                long lastUsed = metadataValue.getLastUsed();
                Metadata metadata = new EmbeddedMetadata.Builder().version((EntryVersion)new NumericVersion(version)).lifespan((long)lifespan, TimeUnit.SECONDS).maxIdle((long)maxIdle, TimeUnit.SECONDS).build();
                InternalMetadataImpl internalMetadata = new InternalMetadataImpl(metadata, created, lastUsed);
                this.executorService.submit(() -> {
                    Object key = entry.getKey();
                    if (!this.deletedKeys.contains((Object)new WrappedByteArray((byte[])key))) {
                        this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_LOAD, Flag.ROLLING_UPGRADE}).putIfAbsent(entry.getKey(), ((MetadataValue)entry.getValue()).getValue(), (Metadata)internalMetadata);
                    }
                    int currentCount = counter.incrementAndGet();
                    if (log.isDebugEnabled() && currentCount % 100 == 0) {
                        log.debugf(">>    Migrated %s entries\n", currentCount);
                    }
                });
            }
        }
    }

    public void setEnvironment(Cache<Object, Object> cache, Set<Object> inputKeys) {
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        PersistenceManager loaderManager = (PersistenceManager)cr.getComponent(PersistenceManager.class);
        this.stores = loaderManager.getStores(RemoteStore.class);
        MigrationMarshaller marshaller = new MigrationMarshaller(cache.getCacheManager().getClassWhiteList());
        this.cache = cache;
        this.cache.addFilteredListener((Object)this.listener, new RemovedFilter(), null, Util.asSet((Object[])new Class[]{CacheEntryRemoved.class}));
        DefaultThreadFactory threadFactory = new DefaultThreadFactory(null, 1, "RollingUpgrade-MigrationTask-%t", null, null);
        this.executorService = Executors.newFixedThreadPool(this.threads, (ThreadFactory)threadFactory);
        try {
            this.ignoredKey = marshaller.objectToByteBuffer("___MigrationManager_HotRod_KnownKeys___");
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    public static class Externalizer
    extends AbstractExternalizer<MigrationTask> {
        public Set<Class<? extends MigrationTask>> getTypeClasses() {
            return Collections.singleton(MigrationTask.class);
        }

        public void writeObject(ObjectOutput output, MigrationTask task) throws IOException {
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)task.readBatch);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)task.threads);
            BitSet bs = new BitSet();
            for (Integer segment : task.segments) {
                bs.set(segment);
            }
            byte[] bytes = bs.toByteArray();
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)bytes.length);
            output.write(bs.toByteArray());
        }

        public MigrationTask readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int readBatch = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            int threads = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            int segmentsSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            byte[] bytes = new byte[segmentsSize];
            input.read(bytes);
            BitSet bitSet = BitSet.valueOf(bytes);
            Set<Integer> segments = bitSet.stream().boxed().collect(Collectors.toSet());
            return new MigrationTask(segments, readBatch, threads);
        }
    }

    @Listener(clustered=true)
    private class RemoveListener {
        private RemoveListener() {
        }

        @CacheEntryRemoved
        public void entryRemoved(CacheEntryRemovedEvent event) {
            MigrationTask.this.deletedKeys.add((Object)new WrappedByteArray((byte[])event.getKey()));
        }
    }
}

