/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.hotrod.session;

import java.time.Duration;
import javax.servlet.ServletContext;
import org.infinispan.client.hotrod.RemoteCache;
import org.wildfly.clustering.Registrar;
import org.wildfly.clustering.ee.Batcher;
import org.wildfly.clustering.ee.Scheduler;
import org.wildfly.clustering.ee.cache.tx.TransactionBatch;
import org.wildfly.clustering.ee.hotrod.tx.HotRodBatcher;
import org.wildfly.clustering.marshalling.spi.Marshallability;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;
import org.wildfly.clustering.web.IdentifierFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionFactory;
import org.wildfly.clustering.web.cache.session.CompositeSessionMetaDataEntry;
import org.wildfly.clustering.web.cache.session.MarshalledValueSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.cache.session.SessionAttributesFactory;
import org.wildfly.clustering.web.cache.session.SessionFactory;
import org.wildfly.clustering.web.hotrod.session.ExpiredSessionRemover;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionAttributesFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManager;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionManagerFactoryConfiguration;
import org.wildfly.clustering.web.hotrod.session.HotRodSessionMetaDataFactory;
import org.wildfly.clustering.web.hotrod.session.SessionExpirationScheduler;
import org.wildfly.clustering.web.hotrod.session.coarse.CoarseSessionAttributesFactory;
import org.wildfly.clustering.web.hotrod.session.fine.FineSessionAttributesFactory;
import org.wildfly.clustering.web.session.ImmutableSessionMetaData;
import org.wildfly.clustering.web.session.SessionExpirationListener;
import org.wildfly.clustering.web.session.SessionManager;
import org.wildfly.clustering.web.session.SessionManagerConfiguration;
import org.wildfly.clustering.web.session.SessionManagerFactory;

public class HotRodSessionManagerFactory<L, C extends Marshallability>
implements SessionManagerFactory<L, TransactionBatch> {
    final Registrar<SessionExpirationListener> expirationRegistrar;
    final Scheduler<String, ImmutableSessionMetaData> expirationScheduler;
    final Batcher<TransactionBatch> batcher;
    final Duration transactionTimeout;
    private final SessionFactory<CompositeSessionMetaDataEntry<L>, ?, L> sessionFactory;

    public HotRodSessionManagerFactory(HotRodSessionManagerFactoryConfiguration<C, L> config) {
        HotRodSessionMetaDataFactory metaDataFactory = new HotRodSessionMetaDataFactory(config);
        this.sessionFactory = new CompositeSessionFactory(metaDataFactory, this.createSessionAttributesFactory(config), config.getLocalContextFactory());
        ExpiredSessionRemover remover = new ExpiredSessionRemover(this.sessionFactory);
        this.expirationRegistrar = remover;
        this.batcher = new HotRodBatcher(config.getCache());
        this.expirationScheduler = new SessionExpirationScheduler(this.batcher, remover, Duration.ofMillis(config.getCache().getRemoteCacheManager().getConfiguration().transaction().timeout()));
        this.transactionTimeout = Duration.ofMillis(config.getCache().getRemoteCacheManager().getConfiguration().transaction().timeout());
    }

    public SessionManager<L, TransactionBatch> createSessionManager(final SessionManagerConfiguration configuration) {
        HotRodSessionManagerConfiguration config = new HotRodSessionManagerConfiguration(){

            @Override
            public SessionExpirationListener getExpirationListener() {
                return configuration.getExpirationListener();
            }

            @Override
            public Registrar<SessionExpirationListener> getExpirationRegistrar() {
                return HotRodSessionManagerFactory.this.expirationRegistrar;
            }

            @Override
            public Scheduler<String, ImmutableSessionMetaData> getExpirationScheduler() {
                return HotRodSessionManagerFactory.this.expirationScheduler;
            }

            @Override
            public IdentifierFactory<String> getIdentifierFactory() {
                return configuration.getIdentifierFactory();
            }

            @Override
            public ServletContext getServletContext() {
                return configuration.getServletContext();
            }

            @Override
            public Batcher<TransactionBatch> getBatcher() {
                return HotRodSessionManagerFactory.this.batcher;
            }

            @Override
            public Duration getStopTimeout() {
                return HotRodSessionManagerFactory.this.transactionTimeout;
            }
        };
        return new HotRodSessionManager(this.sessionFactory, config);
    }

    public void close() {
        this.expirationScheduler.close();
    }

    private SessionAttributesFactory<?> createSessionAttributesFactory(HotRodSessionManagerFactoryConfiguration<C, L> configuration) {
        switch (configuration.getAttributePersistenceStrategy()) {
            case FINE: {
                return new FineSessionAttributesFactory(new HotRodMarshalledValueSessionAttributesFactoryConfiguration(configuration));
            }
            case COARSE: {
                return new CoarseSessionAttributesFactory(new HotRodMarshalledValueSessionAttributesFactoryConfiguration(configuration));
            }
        }
        throw new IllegalStateException();
    }

    private static class HotRodMarshalledValueSessionAttributesFactoryConfiguration<V, C extends Marshallability, L>
    extends MarshalledValueSessionAttributesFactoryConfiguration<V, C, L>
    implements HotRodSessionAttributesFactoryConfiguration<V, MarshalledValue<V, C>> {
        private final HotRodSessionManagerFactoryConfiguration<C, L> configuration;

        HotRodMarshalledValueSessionAttributesFactoryConfiguration(HotRodSessionManagerFactoryConfiguration<C, L> configuration) {
            super(configuration);
            this.configuration = configuration;
        }

        @Override
        public <CK, CV> RemoteCache<CK, CV> getCache() {
            return this.configuration.getCache();
        }
    }
}

