/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap.events.configurator;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.inject.spi.configurator.ProducerConfigurator;
import org.jboss.weld.bootstrap.events.configurator.Configurator;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.reflection.Reflections;

public class ProducerConfiguratorImpl<T>
implements ProducerConfigurator<T>,
Configurator<Producer<T>> {
    private Function<CreationalContext<T>, T> produceCallback = c -> producer.produce(c);
    private Consumer<T> disposeCallback = i -> producer.dispose(i);
    private final Set<InjectionPoint> injectionPoints;

    public ProducerConfiguratorImpl(Producer<T> producer) {
        this.injectionPoints = producer.getInjectionPoints();
    }

    public <U extends T> ProducerConfigurator<T> produceWith(Function<CreationalContext<U>, U> callback) {
        Preconditions.checkArgumentNotNull(callback);
        this.produceCallback = (Function)Reflections.cast(callback);
        return this;
    }

    public ProducerConfigurator<T> disposeWith(Consumer<T> callback) {
        Preconditions.checkArgumentNotNull(callback);
        this.disposeCallback = (Consumer)Reflections.cast(callback);
        return this;
    }

    @Override
    public Producer<T> complete() {
        return new ProducerImpl(this);
    }

    static class ProducerImpl<T>
    implements Producer<T> {
        private final Function<CreationalContext<T>, T> produceCallback;
        private final Consumer<T> disposeCallback;
        private final Set<InjectionPoint> injectionPoints;

        ProducerImpl(ProducerConfiguratorImpl<T> configurator) {
            this.injectionPoints = ((ProducerConfiguratorImpl)configurator).injectionPoints;
            this.produceCallback = ((ProducerConfiguratorImpl)configurator).produceCallback;
            this.disposeCallback = ((ProducerConfiguratorImpl)configurator).disposeCallback;
        }

        public T produce(CreationalContext<T> ctx) {
            return this.produceCallback.apply(ctx);
        }

        public void dispose(T instance) {
            this.disposeCallback.accept(instance);
        }

        public Set<InjectionPoint> getInjectionPoints() {
            return this.injectionPoints;
        }
    }
}

