/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.amqp.transport;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.UnsignedInteger;
import org.apache.qpid.proton.amqp.UnsignedShort;
import org.apache.qpid.proton.amqp.transport.FrameBody;

public final class Open
implements FrameBody {
    private String _containerId;
    private String _hostname;
    private UnsignedInteger _maxFrameSize = UnsignedInteger.valueOf(-1);
    private UnsignedShort _channelMax = UnsignedShort.valueOf((short)-1);
    private UnsignedInteger _idleTimeOut;
    private Symbol[] _outgoingLocales;
    private Symbol[] _incomingLocales;
    private Symbol[] _offeredCapabilities;
    private Symbol[] _desiredCapabilities;
    private Map _properties;

    public Open() {
    }

    public Open(Open other) {
        this._containerId = other._containerId;
        this._hostname = other._hostname;
        this._maxFrameSize = other._maxFrameSize;
        this._channelMax = other._channelMax;
        this._idleTimeOut = other._idleTimeOut;
        if (other._outgoingLocales != null) {
            this._outgoingLocales = Arrays.copyOf(other._outgoingLocales, other._outgoingLocales.length);
        }
        if (other._incomingLocales != null) {
            this._incomingLocales = Arrays.copyOf(other._incomingLocales, other._incomingLocales.length);
        }
        if (other._offeredCapabilities != null) {
            this._offeredCapabilities = Arrays.copyOf(other._offeredCapabilities, other._offeredCapabilities.length);
        }
        if (other._desiredCapabilities != null) {
            this._desiredCapabilities = Arrays.copyOf(other._desiredCapabilities, other._desiredCapabilities.length);
        }
        if (other._properties != null) {
            this._properties = new LinkedHashMap(other._properties);
        }
    }

    public String getContainerId() {
        return this._containerId;
    }

    public void setContainerId(String containerId) {
        if (containerId == null) {
            throw new NullPointerException("the container-id field is mandatory");
        }
        this._containerId = containerId;
    }

    public String getHostname() {
        return this._hostname;
    }

    public void setHostname(String hostname) {
        this._hostname = hostname;
    }

    public UnsignedInteger getMaxFrameSize() {
        return this._maxFrameSize;
    }

    public void setMaxFrameSize(UnsignedInteger maxFrameSize) {
        this._maxFrameSize = maxFrameSize;
    }

    public UnsignedShort getChannelMax() {
        return this._channelMax;
    }

    public void setChannelMax(UnsignedShort channelMax) {
        this._channelMax = channelMax;
    }

    public UnsignedInteger getIdleTimeOut() {
        return this._idleTimeOut;
    }

    public void setIdleTimeOut(UnsignedInteger idleTimeOut) {
        this._idleTimeOut = idleTimeOut;
    }

    public Symbol[] getOutgoingLocales() {
        return this._outgoingLocales;
    }

    public void setOutgoingLocales(Symbol ... outgoingLocales) {
        this._outgoingLocales = outgoingLocales;
    }

    public Symbol[] getIncomingLocales() {
        return this._incomingLocales;
    }

    public void setIncomingLocales(Symbol ... incomingLocales) {
        this._incomingLocales = incomingLocales;
    }

    public Symbol[] getOfferedCapabilities() {
        return this._offeredCapabilities;
    }

    public void setOfferedCapabilities(Symbol ... offeredCapabilities) {
        this._offeredCapabilities = offeredCapabilities;
    }

    public Symbol[] getDesiredCapabilities() {
        return this._desiredCapabilities;
    }

    public void setDesiredCapabilities(Symbol ... desiredCapabilities) {
        this._desiredCapabilities = desiredCapabilities;
    }

    public Map getProperties() {
        return this._properties;
    }

    public void setProperties(Map properties) {
        this._properties = properties;
    }

    @Override
    public <E> void invoke(FrameBody.FrameBodyHandler<E> handler, Binary payload, E context) {
        handler.handleOpen(this, payload, context);
    }

    public String toString() {
        return "Open{ containerId='" + this._containerId + '\'' + ", hostname='" + this._hostname + '\'' + ", maxFrameSize=" + this._maxFrameSize + ", channelMax=" + this._channelMax + ", idleTimeOut=" + this._idleTimeOut + ", outgoingLocales=" + (this._outgoingLocales == null ? null : Arrays.asList(this._outgoingLocales)) + ", incomingLocales=" + (this._incomingLocales == null ? null : Arrays.asList(this._incomingLocales)) + ", offeredCapabilities=" + (this._offeredCapabilities == null ? null : Arrays.asList(this._offeredCapabilities)) + ", desiredCapabilities=" + (this._desiredCapabilities == null ? null : Arrays.asList(this._desiredCapabilities)) + ", properties=" + this._properties + '}';
    }

    @Override
    public Open copy() {
        return new Open(this);
    }
}

