/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.NotFoundException;
import org.jboss.resteasy.core.LocatorRegistry;
import org.jboss.resteasy.core.ResourceInvoker;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.MethodInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.jboss.resteasy.spi.metadata.ResourceLocator;
import org.jboss.resteasy.spi.statistics.MethodStatisticsLogger;
import org.jboss.resteasy.statistics.StatisticsControllerImpl;
import org.jboss.resteasy.util.GetRestful;

public class ResourceLocatorInvoker
implements ResourceInvoker {
    protected InjectorFactory injector;
    protected MethodInjector methodInjector;
    protected ResourceFactory resource;
    protected ResteasyProviderFactory providerFactory;
    protected ResourceLocator method;
    protected ConcurrentHashMap<Class<?>, LocatorRegistry> cachedSubresources = new ConcurrentHashMap();
    protected MethodStatisticsLogger methodStatisticsLogger;

    public ResourceLocatorInvoker(ResourceFactory resource, InjectorFactory injector, ResteasyProviderFactory providerFactory, ResourceLocator locator) {
        this.resource = resource;
        this.injector = injector;
        this.providerFactory = providerFactory;
        this.method = locator;
        this.methodInjector = injector.createMethodInjector(locator, providerFactory);
        StatisticsControllerImpl cfr_ignored_0 = (StatisticsControllerImpl)providerFactory.getStatisticsController();
        this.methodStatisticsLogger = StatisticsControllerImpl.EMPTY;
    }

    protected Object createResource(HttpRequest request, HttpResponse response) {
        Object resource = this.resource.createResource(request, response, this.providerFactory);
        return this.createResource(request, response, resource);
    }

    protected Object createResource(HttpRequest request, HttpResponse response, Object locator) {
        ResteasyUriInfo uriInfo = request.getUri();
        Object[] args = new Object[]{};
        RuntimeException lastException = (RuntimeException)request.getAttribute("registry.matching.exception");
        try {
            args = this.methodInjector.injectArguments(request, response);
        }
        catch (NotFoundException failure) {
            if (lastException != null) {
                throw lastException;
            }
            throw failure;
        }
        try {
            uriInfo.pushCurrentResource(locator);
            Object subResource = this.method.getMethod().invoke(locator, args);
            if (subResource instanceof Class) {
                subResource = this.providerFactory.injectedInstance((Class)subResource);
            }
            return subResource;
        }
        catch (IllegalAccessException e) {
            throw new InternalServerErrorException(e);
        }
        catch (InvocationTargetException e) {
            throw new ApplicationException(e.getCause());
        }
        catch (SecurityException e) {
            throw new ApplicationException(e.getCause());
        }
    }

    @Override
    public Method getMethod() {
        return this.method.getMethod();
    }

    @Override
    public BuiltResponse invoke(HttpRequest request, HttpResponse response) {
        Object target = this.createResource(request, response);
        return this.invokeOnTargetObject(request, response, target);
    }

    @Override
    public BuiltResponse invoke(HttpRequest request, HttpResponse response, Object locator) {
        Object target = this.createResource(request, response, locator);
        return this.invokeOnTargetObject(request, response, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuiltResponse invokeOnTargetObject(HttpRequest request, HttpResponse response, Object target) {
        ResourceInvoker invoker;
        if (target == null) {
            NotFoundException notFound = new NotFoundException(Messages.MESSAGES.nullSubresource(request.getUri().getAbsolutePath()));
            throw notFound;
        }
        Class<?> clazz = target.getClass();
        LocatorRegistry registry = this.cachedSubresources.get(clazz);
        if (registry == null) {
            if (!GetRestful.isSubResourceClass(clazz)) {
                String msg = Messages.MESSAGES.subresourceHasNoJaxRsAnnotations(clazz.getName());
                throw new InternalServerErrorException(msg);
            }
            registry = new LocatorRegistry(clazz, this.providerFactory);
            this.cachedSubresources.putIfAbsent(clazz, registry);
        }
        if ((invoker = registry.getResourceInvoker(request)) instanceof ResourceLocatorInvoker) {
            ResourceLocatorInvoker locator = (ResourceLocatorInvoker)invoker;
            long timeStamp = this.methodStatisticsLogger.timestamp();
            try {
                BuiltResponse builtResponse = locator.invoke(request, response, target);
                return builtResponse;
            }
            finally {
                this.methodStatisticsLogger.duration(timeStamp);
            }
        }
        ResourceMethodInvoker method = (ResourceMethodInvoker)invoker;
        return method.invoke(request, response, target);
    }

    @Override
    public void setMethodStatisticsLogger(MethodStatisticsLogger msLogger) {
        this.methodStatisticsLogger = msLogger;
    }

    @Override
    public MethodStatisticsLogger getMethodStatisticsLogger() {
        return this.methodStatisticsLogger;
    }
}

