/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.config.federation;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.activemq.artemis.core.config.federation.FederationConnectionConfiguration;

public class FederationUpstreamConfiguration
implements Serializable {
    private String name;
    private FederationConnectionConfiguration connectionConfiguration = new FederationConnectionConfiguration();
    private Set<String> policyRefs = new HashSet<String>();

    public String getName() {
        return this.name;
    }

    public FederationUpstreamConfiguration setName(String name) {
        this.name = name;
        return this;
    }

    public Set<String> getPolicyRefs() {
        return this.policyRefs;
    }

    public FederationUpstreamConfiguration addPolicyRef(String name) {
        this.policyRefs.add(name);
        return this;
    }

    public FederationUpstreamConfiguration addPolicyRefs(Collection<String> names) {
        this.policyRefs.addAll(names);
        return this;
    }

    public FederationConnectionConfiguration getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FederationUpstreamConfiguration)) {
            return false;
        }
        FederationUpstreamConfiguration that = (FederationUpstreamConfiguration)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.connectionConfiguration, that.connectionConfiguration) && Objects.equals(this.policyRefs, that.policyRefs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.connectionConfiguration, this.policyRefs);
    }
}

