/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.MessageHandler;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.client.impl.TopologyMemberImpl;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.ActiveMQServerSideProtocolManagerFactory;
import org.apache.activemq.artemis.core.server.cluster.ClusterConnection;
import org.apache.activemq.artemis.core.server.cluster.ClusterManager;
import org.apache.activemq.artemis.core.server.cluster.MessageFlowRecord;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeImpl;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManagerFactory;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.jboss.logging.Logger;

public class ClusterConnectionBridge
extends BridgeImpl {
    private static final Logger logger = Logger.getLogger(ClusterConnectionBridge.class);
    private final ClusterConnection clusterConnection;
    private final ClusterManager clusterManager;
    private final MessageFlowRecord flowRecord;
    private final SimpleString managementAddress;
    private final SimpleString managementNotificationAddress;
    private ClientConsumer notifConsumer;
    private final SimpleString idsHeaderName;
    private final long targetNodeEventUID;
    private final ServerLocatorInternal discoveryLocator;
    private final String storeAndForwardPrefix;
    private TopologyMemberImpl member;

    public ClusterConnectionBridge(ClusterConnection clusterConnection, ClusterManager clusterManager, ServerLocatorInternal targetLocator, ServerLocatorInternal discoveryLocator, int initialConnectAttempts, int reconnectAttempts, long retryInterval, double retryMultiplier, long maxRetryInterval, UUID nodeUUID, long targetNodeEventUID, String targetNodeID, SimpleString name, Queue queue, Executor executor, Filter filterString, SimpleString forwardingAddress, ScheduledExecutorService scheduledExecutor, Transformer transformer, boolean useDuplicateDetection, String user, String password, ActiveMQServer server, SimpleString managementAddress, SimpleString managementNotificationAddress, MessageFlowRecord flowRecord, TransportConfiguration connector, String storeAndForwardPrefix) {
        super(targetLocator, initialConnectAttempts, reconnectAttempts, 0, retryInterval, retryMultiplier, maxRetryInterval, nodeUUID, name, queue, executor, filterString, forwardingAddress, scheduledExecutor, transformer, useDuplicateDetection, user, password, server, ComponentConfigurationRoutingType.valueOf((String)ActiveMQDefaultConfiguration.getDefaultBridgeRoutingType()));
        this.discoveryLocator = discoveryLocator;
        this.idsHeaderName = Message.HDR_ROUTE_TO_IDS.concat(name);
        this.clusterConnection = clusterConnection;
        this.clusterManager = clusterManager;
        this.targetNodeEventUID = targetNodeEventUID;
        this.targetNodeID = targetNodeID;
        this.managementAddress = managementAddress;
        this.managementNotificationAddress = managementNotificationAddress;
        this.flowRecord = flowRecord;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Setting up bridge between " + clusterConnection.getConnector() + " and " + targetLocator), (Throwable)new Exception("trace"));
        }
        this.storeAndForwardPrefix = storeAndForwardPrefix;
    }

    @Override
    protected ClientSessionFactoryInternal createSessionFactory() throws Exception {
        this.serverLocator.setProtocolManagerFactory((ClientProtocolManagerFactory)ActiveMQServerSideProtocolManagerFactory.getInstance((ServerLocator)this.serverLocator));
        ClientSessionFactoryInternal factory = (ClientSessionFactoryInternal)this.serverLocator.createSessionFactory(this.targetNodeID);
        if (factory == null && (factory = this.reconnectOnOriginalNode()) == null) {
            return null;
        }
        this.setSessionFactory(factory);
        if (factory == null) {
            return null;
        }
        factory.setReconnectAttempts(0);
        factory.getConnection().addFailureListener((FailureListener)this);
        return factory;
    }

    @Override
    protected Message beforeForward(Message message, SimpleString forwardingAddress) {
        Message messageCopy = message.copy();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Clustered bridge  copied message " + message + " as " + messageCopy + " before delivery"));
        }
        HashSet propNames = new HashSet(messageCopy.getPropertyNames());
        byte[] queueIds = message.getExtraBytesProperty(this.idsHeaderName);
        if (queueIds == null) {
            ActiveMQServerLogger.LOGGER.noQueueIdDefined(message, messageCopy, this.idsHeaderName);
            throw new IllegalStateException("no queueIDs defined");
        }
        for (SimpleString propName : propNames) {
            if (!propName.startsWith(Message.HDR_ROUTE_TO_IDS)) continue;
            messageCopy.removeProperty(propName);
        }
        messageCopy.putExtraBytesProperty(Message.HDR_ROUTE_TO_IDS, queueIds);
        messageCopy = super.beforeForwardingNoCopy(messageCopy, forwardingAddress);
        return messageCopy;
    }

    private void setupNotificationConsumer() throws Exception {
        if (this.flowRecord != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Setting up notificationConsumer between " + this.clusterConnection.getConnector() + " and " + this.flowRecord.getBridge().getForwardingConnection() + " clusterConnection = " + this.clusterConnection.getName() + " on server " + this.clusterConnection.getServer()));
            }
            this.flowRecord.reset();
            if (this.notifConsumer != null) {
                try {
                    logger.debug((Object)("Closing notification Consumer for reopening " + this.notifConsumer + " on bridge " + this.getName()));
                    this.notifConsumer.close();
                    this.notifConsumer = null;
                }
                catch (ActiveMQException e) {
                    ActiveMQServerLogger.LOGGER.errorClosingConsumer((Exception)((Object)e));
                }
            }
            String qName = "notif." + UUIDGenerator.getInstance().generateStringUUID() + "." + this.clusterConnection.getServer().toString().replaceAll(CompositeAddress.SEPARATOR, "_");
            SimpleString notifQueueName = new SimpleString(qName);
            SimpleString filter = new SimpleString(ManagementHelper.HDR_BINDING_TYPE + "<>" + BindingType.DIVERT.toInt() + " AND " + ManagementHelper.HDR_NOTIFICATION_TYPE + " IN ('" + CoreNotificationType.SESSION_CREATED + "','" + CoreNotificationType.BINDING_ADDED + "','" + CoreNotificationType.BINDING_REMOVED + "','" + CoreNotificationType.CONSUMER_CREATED + "','" + CoreNotificationType.CONSUMER_CLOSED + "','" + CoreNotificationType.PROPOSAL + "','" + CoreNotificationType.PROPOSAL_RESPONSE + "','" + CoreNotificationType.UNPROPOSAL + "') AND " + ManagementHelper.HDR_DISTANCE + "<" + this.flowRecord.getMaxHops() + " AND (" + ClusterConnectionBridge.createSelectorFromAddress(this.appendIgnoresToFilter(this.flowRecord.getAddress())) + ") AND (" + this.createPermissiveManagementNotificationToFilter() + ")");
            this.sessionConsumer.createTemporaryQueue(this.managementNotificationAddress, notifQueueName, filter);
            this.notifConsumer = this.sessionConsumer.createConsumer(notifQueueName);
            this.notifConsumer.setMessageHandler((MessageHandler)this.flowRecord);
            this.sessionConsumer.start();
            ClientMessage message = this.sessionConsumer.createMessage(false);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Requesting sendQueueInfoToQueue through " + this), (Throwable)new Exception("trace"));
            }
            ManagementHelper.putOperationInvocation((ICoreMessage)message, (String)"broker", (String)"sendQueueInfoToQueue", (Object[])new Object[]{notifQueueName.toString(), this.flowRecord.getAddress()});
            try (ClientProducer prod = this.sessionConsumer.createProducer(this.managementAddress);){
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cluster connection bridge on " + this.clusterConnection + " requesting information on queues"));
                }
                prod.send((Message)message);
            }
        }
    }

    public static String createSelectorFromAddress(String address) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!address.contains(",")) {
            if (address.startsWith("!")) {
                stringBuilder.append(ManagementHelper.HDR_ADDRESS + " NOT LIKE '" + address.substring(1, address.length()) + "%'");
            } else {
                stringBuilder.append(ManagementHelper.HDR_ADDRESS + " LIKE '" + address + "%'");
            }
            return stringBuilder.toString();
        }
        return ClusterConnectionBridge.buildSelectorFromArray(address.split(","));
    }

    public static String buildSelectorFromArray(String[] list) {
        int i;
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        for (String s : list) {
            if (s.startsWith("!")) {
                excludes.add(s.substring(1, s.length()));
                continue;
            }
            includes.add(s);
        }
        StringBuilder builder = new StringBuilder("(");
        if (includes.size() > 0) {
            if (excludes.size() > 0) {
                builder.append("(");
            }
            for (i = 0; i < includes.size(); ++i) {
                builder.append("(" + ManagementHelper.HDR_ADDRESS + " LIKE '" + (String)includes.get(i) + "%')");
                if (i >= includes.size() - 1) continue;
                builder.append(" OR ");
            }
            if (excludes.size() > 0) {
                builder.append(")");
            }
        }
        if (excludes.size() > 0) {
            if (includes.size() > 0) {
                builder.append(" AND (");
            }
            for (i = 0; i < excludes.size(); ++i) {
                builder.append("(" + ManagementHelper.HDR_ADDRESS + " NOT LIKE '" + (String)excludes.get(i) + "%')");
                if (i >= excludes.size() - 1) continue;
                builder.append(" AND ");
            }
            if (includes.size() > 0) {
                builder.append(")");
            }
        }
        builder.append(")");
        return builder.toString();
    }

    private String appendIgnoresToFilter(String filterString) {
        if (filterString != null && !filterString.isEmpty()) {
            filterString = filterString + ",";
        }
        filterString = filterString + "!" + this.storeAndForwardPrefix;
        filterString = filterString + ",!" + this.managementAddress;
        return filterString;
    }

    private String createPermissiveManagementNotificationToFilter() {
        StringBuilder filterBuilder = new StringBuilder((CharSequence)ManagementHelper.HDR_NOTIFICATION_TYPE).append(" = '").append(CoreNotificationType.SESSION_CREATED).append("' OR (").append((CharSequence)ManagementHelper.HDR_ADDRESS).append(" NOT LIKE '").append((CharSequence)this.managementNotificationAddress).append("%')");
        return filterBuilder.toString();
    }

    @Override
    protected void nodeUP(TopologyMember member, boolean last) {
        if (member != null && this.targetNodeID != null && !this.targetNodeID.equals(member.getNodeId())) {
            return;
        }
        super.nodeUP(member, last);
    }

    @Override
    protected void afterConnect() throws Exception {
        super.afterConnect();
        this.setupNotificationConsumer();
    }

    @Override
    protected void tryScheduleRetryReconnect(ActiveMQExceptionType type) {
        if (type != ActiveMQExceptionType.DISCONNECTED) {
            this.scheduleRetryConnect();
        }
    }

    @Override
    protected void fail(boolean permanently, boolean scaleDown) {
        logger.debug((Object)("Cluster Bridge " + this.getName() + " failed, permanently=" + permanently));
        super.fail(permanently, scaleDown);
        if (permanently) {
            logger.debug((Object)("cluster node for bridge " + this.getName() + " is permanently down"));
            this.clusterConnection.removeRecord(this.targetNodeID);
            if (scaleDown) {
                try {
                    this.queue.deleteQueue(true);
                    this.queue.removeAddress();
                }
                catch (Exception e) {
                    logger.warn((Object)e.getMessage(), (Throwable)e);
                }
            }
        } else {
            this.clusterConnection.disconnectRecord(this.targetNodeID);
        }
    }
}

