/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Objects;

public final class RuntimePackageDependency {
    private final String name;
    private final TYPE type;

    private RuntimePackageDependency(String name, TYPE type) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(type);
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOptional() {
        return this.type == TYPE.OPTIONAL || this.type == TYPE.PASSIVE;
    }

    public boolean isRequired() {
        return this.type == TYPE.REQUIRED;
    }

    public boolean isPassive() {
        return this.type == TYPE.PASSIVE;
    }

    public static RuntimePackageDependency passive(String name) {
        return new RuntimePackageDependency(name, TYPE.PASSIVE);
    }

    public static RuntimePackageDependency required(String name) {
        return new RuntimePackageDependency(name, TYPE.REQUIRED);
    }

    public static RuntimePackageDependency optional(String name) {
        return new RuntimePackageDependency(name, TYPE.OPTIONAL);
    }

    private static enum TYPE {
        REQUIRED,
        OPTIONAL,
        PASSIVE;

    }
}

