/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller.transform;

import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.ResourceTransformationContext;
import org.jboss.as.controller.transform.ResourceTransformer;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class LegacyPropertyResourceTransformer
implements ResourceTransformer {
    public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
        ModelNode model = resource.getModel();
        ModelNode properties = model.remove("properties");
        ResourceTransformationContext parentContext = context.addTransformedResourceFromRoot(address, resource);
        LegacyPropertyResourceTransformer.transformPropertiesToChildrenResources(properties, address, parentContext);
        context.processChildren(resource);
    }

    public static void transformPropertiesToChildrenResources(ModelNode properties, PathAddress address, ResourceTransformationContext parentContext) {
        if (properties.isDefined()) {
            for (Property property : properties.asPropertyList()) {
                String key = property.getName();
                ModelNode value = property.getValue();
                Resource propertyResource = Resource.Factory.create();
                propertyResource.getModel().get("value").set(value);
                PathAddress absoluteAddress = address.append("property", key);
                parentContext.addTransformedResourceFromRoot(absoluteAddress, propertyResource);
            }
        }
    }
}

