/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.CapabilityServiceConfigurator;
import org.jboss.as.clustering.controller.ModuleServiceConfigurator;
import org.jboss.as.clustering.controller.ResourceServiceConfiguratorFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanBindingFactory;
import org.jboss.as.clustering.infinispan.subsystem.TransactionResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.XAResourceRecoveryServiceConfigurator;
import org.jboss.as.clustering.naming.BinderServiceConfigurator;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.service.CacheServiceConfigurator;
import org.wildfly.clustering.service.IdentityServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceNameRegistry;
import org.wildfly.clustering.spi.CacheServiceConfiguratorProvider;
import org.wildfly.clustering.spi.CapabilityServiceNameRegistry;

public class CacheServiceHandler
implements ResourceServiceHandler {
    private final ResourceServiceConfiguratorFactory configuratorFactory;
    private final Class<? extends CacheServiceConfiguratorProvider> providerClass;

    CacheServiceHandler(ResourceServiceConfiguratorFactory configuratorFactory, Class<? extends CacheServiceConfiguratorProvider> providerClass) {
        this.configuratorFactory = configuratorFactory;
        this.providerClass = providerClass;
    }

    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        PathAddress cacheAddress = context.getCurrentAddress();
        PathAddress containerAddress = cacheAddress.getParent();
        String containerName = containerAddress.getLastElement().getValue();
        String cacheName = cacheAddress.getLastElement().getValue();
        ServiceTarget target = context.getServiceTarget();
        ServiceName moduleServiceName = CacheComponent.MODULE.getServiceName(cacheAddress);
        if (model.hasDefined(CacheResourceDefinition.Attribute.MODULE.getName())) {
            new ModuleServiceConfigurator(moduleServiceName, (Attribute)CacheResourceDefinition.Attribute.MODULE).configure(context, model).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        } else {
            new IdentityServiceConfigurator(moduleServiceName, CacheContainerComponent.MODULE.getServiceName(containerAddress)).build(target).install();
        }
        this.configuratorFactory.createServiceConfigurator(cacheAddress).configure(context, model).build(target).install();
        new CacheServiceConfigurator(CacheResourceDefinition.Capability.CACHE.getServiceName(cacheAddress), containerName, cacheName).configure(context).build(target).install();
        if (context.hasOptionalCapability(TransactionResourceDefinition.TransactionRequirement.XA_RESOURCE_RECOVERY_REGISTRY.getName(), null, null)) {
            new XAResourceRecoveryServiceConfigurator(cacheAddress).configure(context).build(target).install();
        }
        new BinderServiceConfigurator(InfinispanBindingFactory.createCacheConfigurationBinding(containerName, cacheName), CacheResourceDefinition.Capability.CONFIGURATION.getServiceName(cacheAddress)).build(target).install();
        new BinderServiceConfigurator(InfinispanBindingFactory.createCacheBinding(containerName, cacheName), CacheResourceDefinition.Capability.CACHE.getServiceName(cacheAddress)).build(target).install();
        CapabilityServiceNameRegistry registry = new CapabilityServiceNameRegistry(CacheResourceDefinition.CLUSTERING_CAPABILITIES, cacheAddress);
        for (CacheServiceConfiguratorProvider cacheServiceConfiguratorProvider : ServiceLoader.load(this.providerClass, this.providerClass.getClassLoader())) {
            for (CapabilityServiceConfigurator configurator : cacheServiceConfiguratorProvider.getServiceConfigurators((ServiceNameRegistry)registry, containerName, cacheName)) {
                configurator.configure(context).build(target).install();
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) {
        PathAddress cacheAddress = context.getCurrentAddress();
        PathAddress containerAddress = cacheAddress.getParent();
        String containerName = containerAddress.getLastElement().getValue();
        String cacheName = cacheAddress.getLastElement().getValue();
        CapabilityServiceNameRegistry registry = new CapabilityServiceNameRegistry(CacheResourceDefinition.CLUSTERING_CAPABILITIES, cacheAddress);
        for (CacheServiceConfiguratorProvider cacheServiceConfiguratorProvider : ServiceLoader.load(this.providerClass, this.providerClass.getClassLoader())) {
            for (ServiceNameProvider configurator : cacheServiceConfiguratorProvider.getServiceConfigurators((ServiceNameRegistry)registry, containerName, cacheName)) {
                context.removeService(configurator.getServiceName());
            }
        }
        context.removeService(InfinispanBindingFactory.createCacheBinding(containerName, cacheName).getBinderServiceName());
        context.removeService(InfinispanBindingFactory.createCacheConfigurationBinding(containerName, cacheName).getBinderServiceName());
        context.removeService(new XAResourceRecoveryServiceConfigurator(cacheAddress).getServiceName());
        context.removeService(CacheComponent.MODULE.getServiceName(cacheAddress));
        for (CacheResourceDefinition.Capability capability : EnumSet.allOf(CacheResourceDefinition.Capability.class)) {
            context.removeService(capability.getServiceName(cacheAddress));
        }
    }
}

