/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.infinispan.Cache;
import org.infinispan.affinity.KeyAffinityService;
import org.infinispan.affinity.KeyGenerator;
import org.infinispan.affinity.impl.KeyAffinityServiceImpl;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.remoting.transport.Address;
import org.jboss.as.clustering.context.DefaultExecutorService;
import org.jboss.as.clustering.context.DefaultThreadFactory;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityServiceNameProvider;
import org.jboss.as.clustering.infinispan.subsystem.CacheContainerResourceDefinition;
import org.jboss.as.controller.PathAddress;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.spi.affinity.KeyAffinityServiceFactory;
import org.wildfly.clustering.service.AsyncServiceConfigurator;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.security.ParametricPrivilegedAction;
import org.wildfly.security.manager.WildFlySecurityManager;

public class KeyAffinityServiceFactoryServiceConfigurator
extends CapabilityServiceNameProvider
implements ServiceConfigurator,
Function<ExecutorService, KeyAffinityServiceFactory>,
Supplier<ExecutorService>,
Consumer<ExecutorService> {
    private volatile int bufferSize = 100;

    public KeyAffinityServiceFactoryServiceConfigurator(PathAddress address) {
        super((Capability)CacheContainerResourceDefinition.Capability.KEY_AFFINITY_FACTORY, address);
    }

    public KeyAffinityServiceFactoryServiceConfigurator setBufferSize(int size) {
        this.bufferSize = size;
        return this;
    }

    @Override
    public ExecutorService get() {
        return Executors.newCachedThreadPool((ThreadFactory)new DefaultThreadFactory(KeyAffinityService.class));
    }

    @Override
    public KeyAffinityServiceFactory apply(final ExecutorService executor) {
        final int bufferSize = this.bufferSize;
        return new KeyAffinityServiceFactory(){

            public <K> KeyAffinityService<K> createService(Cache<K, ?> cache, KeyGenerator<K> generator) {
                CacheMode mode = cache.getCacheConfiguration().clustering().cacheMode();
                return mode.needsStateTransfer() ? new KeyAffinityServiceImpl((Executor)executor, cache, generator, bufferSize, Collections.singleton(cache.getCacheManager().getAddress()), false) : new SimpleKeyAffinityService<K>(generator);
            }
        };
    }

    @Override
    public void accept(ExecutorService executor) {
        WildFlySecurityManager.doUnchecked((Object)executor, (ParametricPrivilegedAction)DefaultExecutorService.SHUTDOWN_NOW_ACTION);
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = new AsyncServiceConfigurator(this.getServiceName()).startSynchronously().build(target);
        Consumer affinityFactory = builder.provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(affinityFactory, (Function)this, (Supplier)this, (Consumer)this);
        return builder.setInstance((Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    private static class SimpleKeyAffinityService<K>
    implements KeyAffinityService<K> {
        private final KeyGenerator<K> generator;
        private volatile boolean started = false;

        SimpleKeyAffinityService(KeyGenerator<K> generator) {
            this.generator = generator;
        }

        public void start() {
            this.started = true;
        }

        public void stop() {
            this.started = false;
        }

        public K getKeyForAddress(Address address) {
            return (K)this.generator.getKey();
        }

        public K getCollocatedKey(K otherKey) {
            return (K)this.generator.getKey();
        }

        public boolean isStarted() {
            return this.started;
        }
    }
}

