/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.saml.md.providers;

import java.io.InputStream;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.SPType;
import org.picketlink.config.federation.handler.Handler;
import org.picketlink.config.federation.handler.Handlers;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;

public class MetadataProviderUtils {
    public static String getLogoutURL(ProviderType providerType) {
        if (providerType instanceof SPType) {
            SPType spType = (SPType)providerType;
            return spType.getLogoutUrl();
        }
        return null;
    }

    public static String getServiceURL(ProviderType providerType) {
        if (providerType instanceof SPType) {
            SPType spType = (SPType)providerType;
            return spType.getServiceURL();
        }
        return null;
    }

    public static String getBindingURI(ProviderType providerType) {
        if (providerType instanceof SPType) {
            SPType spType = (SPType)providerType;
            if (spType.getBindingType().equals("POST")) {
                return JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get();
            }
            if (spType.getBindingType().equals("REDIRECT")) {
                return JBossSAMLURIConstants.SAML_HTTP_REDIRECT_BINDING.get();
            }
        }
        return null;
    }

    public static String getLogoutResponseLocation(ProviderType providerType) {
        if (providerType instanceof SPType) {
            SPType spType = (SPType)providerType;
            return spType.getLogoutResponseLocation();
        }
        return null;
    }

    public static PicketLinkType getPicketLinkConf(InputStream is) {
        try {
            return ConfigurationUtil.getConfiguration(is);
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
    }

    public static ProviderType getProviderType(PicketLinkType picketLinkConfiguration) {
        ProviderType providerType = null;
        if (picketLinkConfiguration != null) {
            providerType = picketLinkConfiguration.getIdpOrSP();
        }
        return providerType;
    }

    public static Handler getHandler(PicketLinkType picketLinkType, String handlerName) throws ParsingException {
        Handlers handlers = picketLinkType.getHandlers();
        for (Handler h : handlers.getHandler()) {
            if (!h.getClazz().equals(handlerName)) continue;
            return h;
        }
        return null;
    }
}

